package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun intSchemaImpl(
    isNullable: Boolean,
    initialValue: Int?,
    computedInitialValue: InitialValue<Int?>?,
    computedValue: ComputedValue<Int?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Int>?,
    computedAllowedValues: AllowedValues<Int>?,
    min: Int?,
    computedMin: Bound<Int>?,
    max: Int?,
    computedMax: Bound<Int>?,
    validations: List<Validation<Int>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Int?> {
    val schema = createSchemaWithCommonProps(
        "number",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().isInteger = true
    schema.asDynamic().min = when {
        min != null -> min
        computedMin != null -> toStorageBound(computedMin)
        else -> Int.MIN_VALUE
    }
    schema.asDynamic().max = when {
        max != null -> max
        computedMax != null -> toStorageBound(computedMax)
        else -> Int.MAX_VALUE
    }
    return schema
}
