package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun shortSchemaImpl(
    isNullable: Boolean,
    initialValue: Short?,
    computedInitialValue: InitialValue<Short?>?,
    computedValue: ComputedValue<Short?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Short>?,
    computedAllowedValues: AllowedValues<Short>?,
    min: Short?,
    computedMin: Bound<Short>?,
    max: Short?,
    computedMax: Bound<Short>?,
    validations: List<Validation<Short>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Short?> {
    val schema = createSchemaWithCommonProps(
        "number",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().isInteger = true
    schema.asDynamic().min = when {
        min != null -> min
        computedMin != null -> toStorageBound(computedMin)
        else -> Short.MIN_VALUE
    }
    schema.asDynamic().max = when {
        max != null -> max
        computedMax != null -> toStorageBound(computedMax)
        else -> Short.MAX_VALUE
    }
    return schema
}
