package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun stringSchemaImpl(
    isNullable: Boolean,
    initialValue: String?,
    computedInitialValue: InitialValue<String?>?,
    computedValue: ComputedValue<String?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<String>?,
    computedAllowedValues: AllowedValues<String>?,
    minLength: Int?,
    computedMinLength: Bound<Int>?,
    maxLength: Int?,
    computedMaxLength: Bound<Int>?,
    validations: List<Validation<String>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<String?> {
    val schema = createSchemaWithCommonProps(
        "string",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().minLength = when {
        minLength != null -> minLength
        computedMinLength != null -> toStorageBound(computedMinLength)
        else -> undefined
    }
    schema.asDynamic().maxLength = when {
        maxLength != null -> maxLength
        computedMaxLength != null -> toStorageBound(computedMaxLength)
        else -> undefined
    }
    return schema
}
