package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps

internal actual fun tupleSchemaImpl(
    elementsSchemas: List<Schema<Any?>>,
    isNullable: Boolean,
    initialValue: Array<Any?>?,
    computedInitialValue: InitialValue<Array<Any?>?>?,
    computedValue: ComputedValue<Array<Any?>?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Array<Any?>>?,
    computedAllowedValues: AllowedValues<Array<Any?>>?,
    validations: List<Validation<Array<Any?>>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Array<Any?>?> {
    val schema = createSchemaWithCommonProps(
        "tuple",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().elementsSchemas = elementsSchemas.toTypedArray()
    return schema
}
