package pt.lightweightform.lfkotlin

import pt.lightweightform.lfkotlin.internal.lastPathPartInfo

/**
 * Context available for use in validations, computed values, and state properties.
 */
public actual class Context(
    private val rootSchema: Schema<*>,
    private val rootValue: Any?,
    private val state: MutableMap<Path, MutableMap<String, Any?>>,
    public actual val currentPath: Path,
    public val externalContext: Any?
) {
    public actual fun relativeContext(relativePath: Path): Context =
        Context(
            rootSchema,
            rootValue,
            state,
            resolvePath(currentPath, relativePath),
            externalContext
        )

    @Suppress("UNCHECKED_CAST")
    public actual fun <T> get(relativePath: String): T =
        lastPathPartInfo(
            rootSchema,
            rootValue,
            resolvePath(currentPath, relativePath),
            true
        ).value as T

    @Suppress("UNCHECKED_CAST")
    public actual fun <T> getStateProperty(relativePath: Path, prop: String): T {
        val path = resolvePath(currentPath, relativePath)
        var pathState = state[path]
        if (pathState == null) {
            pathState = mutableMapOf()
            state[path] = pathState
        }

        if (!pathState.contains(prop)) {
            val schema = lastPathPartInfo(rootSchema, rootValue, path, false).schema
            pathState[prop] = if (schema.initialState?.contains(prop) == true)
                when (val initialStateProp = schema.initialState!![prop]) {
                    is SyncStateProperty<*> -> initialStateProp.run {
                        relativeContext(path).property()
                    }
                    else -> initialStateProp
                } else null
        }
        return pathState[prop] as T
    }
}
