@file:JvmName("IssuesMaps")

package pt.lightweightform.lfkotlin

/**
 * Mapping of paths to their issues.
 */
public typealias IssuesMap = Map<Path, List<Issue>>

/**
 * Whether a map of issues contains issues.
 */
public fun IssuesMap.hasIssues(): Boolean = isNotEmpty()

/**
 * Whether a map of issues contains no issues.
 */
public fun IssuesMap.hasNoIssues(): Boolean = isEmpty()

/**
 * Whether a map of issues contains errors.
 */
public fun IssuesMap.hasErrors(): Boolean = values.any { issues ->
    issues.any { issue -> !issue.isWarning }
}

/**
 * Whether a map of issues contains no errors.
 */
public fun IssuesMap.hasNoErrors(): Boolean = !hasErrors()

/**
 * Whether a map of issues contains warning.
 */
public fun IssuesMap.hasWarnings(): Boolean = values.any { issues ->
    issues.any { issue -> issue.isWarning }
}

/**
 * Whether a map of issues contains no errors.
 */
public fun IssuesMap.hasNoWarnings(): Boolean = !hasWarnings()
