@file:JvmName("DateSchemas")

package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.LfDate
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.toEpochMilliseconds

public class DateSchema(
    override val isNullable: Boolean,
    override val initialValue: LfDate?,
    override val computedInitialValue: InitialValue<LfDate?>?,
    override val computedValue: ComputedValue<LfDate?>?,
    override val isClientOnly: Boolean?,
    override val isRequired: Boolean?,
    override val computedIsRequired: IsRequired?,
    override val allowedValues: List<LfDate>?,
    override val computedAllowedValues: AllowedValues<LfDate>?,
    public val minDate: LfDate?,
    public val computedMinDate: Bound<LfDate>?,
    public val maxDate: LfDate?,
    public val computedMaxDate: Bound<LfDate>?,
    override val validations: List<Validation<LfDate>>?,
    override val initialState: Map<String, Any?>?,
    override val extra: Map<String, Any?>?
) : Schema<LfDate> {
    override fun valuesAreEqual(value1: LfDate?, value2: LfDate?): Boolean =
        value1?.toEpochMilliseconds() == value2?.toEpochMilliseconds()
}

@Suppress("UNCHECKED_CAST")
public actual fun dateSchemaImpl(
    isNullable: Boolean,
    initialValue: LfDate?,
    computedInitialValue: InitialValue<LfDate?>?,
    computedValue: ComputedValue<LfDate?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<LfDate>?,
    computedAllowedValues: AllowedValues<LfDate>?,
    minDate: LfDate?,
    computedMinDate: Bound<LfDate>?,
    maxDate: LfDate?,
    computedMaxDate: Bound<LfDate>?,
    validations: List<Validation<LfDate>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<LfDate?> = DateSchema(
    isNullable,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    minDate,
    computedMinDate,
    maxDate,
    computedMaxDate,
    validations,
    initialState,
    extra
) as Schema<LfDate?>
