@file:JvmName("IntSchemas")

package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

@Suppress("UNCHECKED_CAST")
public actual fun intSchemaImpl(
    isNullable: Boolean,
    initialValue: Int?,
    computedInitialValue: InitialValue<Int?>?,
    computedValue: ComputedValue<Int?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Int>?,
    computedAllowedValues: AllowedValues<Int>?,
    min: Int?,
    computedMin: Bound<Int>?,
    max: Int?,
    computedMax: Bound<Int>?,
    validations: List<Validation<Int>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Int?> = NumberSchema(
    isNullable,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    if (min == null && computedMin == null) Int.MIN_VALUE else min,
    computedMin,
    if (max == null && computedMax == null) Int.MAX_VALUE else max,
    computedMax,
    validations,
    initialState,
    extra
) as Schema<Int?>
