@file:JvmName("ShortSchemas")

package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

@Suppress("UNCHECKED_CAST")
public actual fun shortSchemaImpl(
    isNullable: Boolean,
    initialValue: Short?,
    computedInitialValue: InitialValue<Short?>?,
    computedValue: ComputedValue<Short?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Short>?,
    computedAllowedValues: AllowedValues<Short>?,
    min: Short?,
    computedMin: Bound<Short>?,
    max: Short?,
    computedMax: Bound<Short>?,
    validations: List<Validation<Short>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Short?> = NumberSchema(
    isNullable,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    if (min == null && computedMin == null) Short.MIN_VALUE else min,
    computedMin,
    if (max == null && computedMax == null) Short.MAX_VALUE else max,
    computedMax,
    validations,
    initialState,
    extra
) as Schema<Short?>
