/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.agent.core.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import pub.ihub.integration.core.Logger;

public class AgentPluginClassLoader
extends ClassLoader {
    private static AgentPluginClassLoader DEFAULT_LOADER;
    private static final String PLUGIN_FILE_PATH = "/tmp/ihub-agent-plugin.jar";
    private final List<File> classpath;
    private final List<Jar> allJars = new LinkedList<Jar>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initDefaultLoader() {
        if (DEFAULT_LOADER != null) return;
        Class<AgentPluginClassLoader> clazz = AgentPluginClassLoader.class;
        synchronized (AgentPluginClassLoader.class) {
            if (DEFAULT_LOADER != null) return;
            DEFAULT_LOADER = new AgentPluginClassLoader(AgentPluginClassLoader.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public AgentPluginClassLoader(ClassLoader parent) {
        super(parent);
        this.classpath = new LinkedList<File>();
        this.classpath.add(new File(PLUGIN_FILE_PATH));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.allJars.isEmpty()) {
            try {
                File file = new File(PLUGIN_FILE_PATH);
                Jar jar = new Jar(new JarFile(file), file);
                this.allJars.add(jar);
            }
            catch (IOException e) {
                Logger.error("failed to load the plugin file, msg = %s", e.getMessage());
            }
        }
        String path = name.replace('.', '/').concat(".class");
        for (Jar jar : this.allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(path);
            if (entry == null) continue;
            try {
                byte[] data;
                URL classFileUrl = new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + path);
                try (BufferedInputStream is = new BufferedInputStream(classFileUrl.openStream());
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int ch;
                    while ((ch = is.read()) != -1) {
                        baos.write(ch);
                    }
                    data = baos.toByteArray();
                }
                return this.defineClass(name, data, 0, data.length);
            }
            catch (IOException e) {
                Logger.error("find class fail, msg = %s", e.getMessage());
            }
        }
        throw new ClassNotFoundException("Can't find " + name);
    }

    private record Jar(JarFile jarFile, File sourceFile) {
    }
}

