/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.agent.core.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import pub.ihub.integration.agent.core.loader.AgentPluginClassLoader;

public class EnhancerInstanceLoader {
    private static final ConcurrentHashMap<String, Object> INSTANCE_CACHE = new ConcurrentHashMap();
    private static final ReentrantLock INSTANCE_LOAD_LOCK = new ReentrantLock();
    private static final Map<ClassLoader, ClassLoader> EXTEND_PLUGIN_CLASSLOADERS = new HashMap<ClassLoader, ClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(String className, ClassLoader targetClassLoader) {
        String instanceKey;
        Object inst;
        if (targetClassLoader == null) {
            targetClassLoader = EnhancerInstanceLoader.class.getClassLoader();
        }
        if ((inst = INSTANCE_CACHE.get(instanceKey = className + "_OF_" + targetClassLoader.getClass().getName() + "@" + Integer.toHexString(targetClassLoader.hashCode()))) == null) {
            ClassLoader pluginLoader;
            INSTANCE_LOAD_LOCK.lock();
            try {
                pluginLoader = EXTEND_PLUGIN_CLASSLOADERS.get(targetClassLoader);
                if (pluginLoader == null) {
                    pluginLoader = new AgentPluginClassLoader(targetClassLoader);
                    EXTEND_PLUGIN_CLASSLOADERS.put(targetClassLoader, pluginLoader);
                }
            }
            finally {
                INSTANCE_LOAD_LOCK.unlock();
            }
            inst = Class.forName(className, true, pluginLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            INSTANCE_CACHE.put(instanceKey, inst);
        }
        return (T)inst;
    }
}

