/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.agent.trace;

import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import pub.ihub.integration.agent.core.IHubEnhancer;
import pub.ihub.integration.agent.core.IHubTransformer;
import pub.ihub.integration.agent.trace.Listener;
import pub.ihub.integration.agent.trace.LoggingSpanExporter;
import pub.ihub.integration.agent.trace.context.IHubTraceContext;
import pub.ihub.integration.agent.trace.enhancer.TomcatEnhancer;
import pub.ihub.integration.core.Logger;

public class IHubTraceAgent {
    private static final String TRANSFORMER_V_1 = "v1";
    private static final String TRANSFORMER_V_2 = "v2";

    public static void premain(String agentArgs, Instrumentation inst) {
        Logger.info("The ihub agent start to load...", new Object[0]);
        ArrayList<SpanExporter> spanExporterList = new ArrayList<SpanExporter>();
        spanExporterList.add(new LoggingSpanExporter());
        IHubTraceContext.initTraceContext(spanExporterList);
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(false));
        AgentBuilder.Ignored agentBuilder = new AgentBuilder.Default(byteBuddy).ignore(ElementMatchers.nameStartsWith("net.bytebuddy.").or(ElementMatchers.nameStartsWith("org.slf4j.")).or(ElementMatchers.nameStartsWith("org.groovy.")).or(ElementMatchers.nameContains("javassist")).or(ElementMatchers.nameContains(".asm.")).or(ElementMatchers.nameContains(".reflectasm.")).or(ElementMatchers.nameStartsWith("sun.reflect")).or(ElementMatchers.isSynthetic()));
        Listener listener = new Listener();
        Properties systemProperties = System.getProperties();
        String transformerVer = systemProperties.getProperty("agent.transformer.version");
        if (transformerVer == null) {
            transformerVer = TRANSFORMER_V_1;
        }
        if (TRANSFORMER_V_1.equals(transformerVer)) {
            ArrayList<TomcatEnhancer> enhancerList = new ArrayList<TomcatEnhancer>();
            enhancerList.add(new TomcatEnhancer());
            Logger.info("load transformer v1.", new Object[0]);
            for (IHubEnhancer iHubEnhancer : enhancerList) {
                ElementMatcher.Junction<TypeDescription> matcher = iHubEnhancer.enhanceClass();
                agentBuilder.type(matcher).transform(IHubTransformer.build(iHubEnhancer)).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(listener).installOn(inst);
            }
        } else if (TRANSFORMER_V_2.equals(transformerVer)) {
            HashMap<String, String> aspectContexts = new HashMap<String, String>(1);
            aspectContexts.put("org.apache.catalina.core.StandardHostValve", "pub.ihub.integration.agent.trace.enhancer.TomcatEnhancer");
            Logger.info("load transformer v2.", new Object[0]);
            for (Map.Entry entry : aspectContexts.entrySet()) {
                String enhanceAspect = (String)entry.getKey();
                String enhanceClass = (String)entry.getValue();
                ElementMatcher.Junction matcher = ElementMatchers.named(enhanceAspect).and(ElementMatchers.not(ElementMatchers.isInterface()));
                agentBuilder.type(matcher).transform(IHubTransformer.build(enhanceClass)).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(listener).installOn(inst);
            }
        } else {
            HashMap<String, String> aspectContexts = new HashMap<String, String>(1);
            aspectContexts.put("org.apache.catalina.core.StandardHostValve", "pub.ihub.integration.agent.trace.enhancer.TomcatEnhancer");
            Logger.info("load transformer v3.", new Object[0]);
            for (Map.Entry entry : aspectContexts.entrySet()) {
                String enhanceClass = (String)entry.getKey();
                String enhanceAspect = (String)entry.getValue();
                ElementMatcher.Junction matcher = ElementMatchers.named(enhanceClass).and(ElementMatchers.not(ElementMatchers.isInterface()));
                agentBuilder.type(matcher).transform(IHubTransformer.buildWithEnhancerInstanceLoader(enhanceAspect)).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(listener).installOn(inst);
            }
        }
        Logger.info("The ihub agent has been loaded.", new Object[0]);
    }
}

