/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.agent.trace.enhancer;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.catalina.connector.Request;
import pub.ihub.integration.agent.core.IHubEnhancer;
import pub.ihub.integration.agent.trace.context.IHubTraceContext;
import pub.ihub.integration.core.Logger;

public class TomcatEnhancer
implements IHubEnhancer {
    private static final String ENHANCE_CLASS = "org.apache.catalina.core.StandardHostValve";
    private static final String ENHANCE_METHOD = "invoke";
    private static ThreadLocal<Span> spanThreadLocal = new ThreadLocal();

    public ElementMatcher.Junction enhanceClass() {
        return ElementMatchers.named(ENHANCE_CLASS).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<MethodDescription> getMethodsMatcher() {
        return ElementMatchers.named(ENHANCE_METHOD);
    }

    @Override
    public String getMethodsEnhancer() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object result) throws Throwable {
        Logger.info("[trace]beforeMethod(), method = %s.%s", method.getDeclaringClass().getName(), method.getName());
        Request request = (Request)allArguments[0];
        TextMapGetter<Request> getter = new TextMapGetter<Request>(){

            @Override
            public String get(Request carrier, String key) {
                return carrier.getHeader(key);
            }

            @Override
            public Iterable<String> keys(Request carrier) {
                ArrayList<String> keys = new ArrayList<String>();
                Enumeration<String> headers = carrier.getParameterNames();
                while (headers.hasMoreElements()) {
                    String name = headers.nextElement();
                    keys.add(name);
                }
                return keys;
            }
        };
        Context extractedContext = IHubTraceContext.textPropagator().extract(Context.current(), request, getter);
        extractedContext.makeCurrent();
        String operationName = String.format("%s %s", request.getMethod(), request.getRequestURI());
        Span span = IHubTraceContext.tracer().spanBuilder(operationName).setSpanKind(SpanKind.PRODUCER).startSpan().setAttribute("URL", request.getRequestURL().toString()).setAttribute("METHOD", request.getMethod()).setAttribute("URI", request.getRequestURI()).setAttribute("RemoteAddr", request.getRemoteAddr()).setAttribute("RemoteHost", request.getRemoteHost()).setAttribute("RemotePort", (long)request.getRemotePort()).setAttribute("RemoteUser", request.getRemoteUser()).setAttribute("Component", "Tomcat");
        span.makeCurrent();
        spanThreadLocal.set(span);
    }

    @Override
    public Object afterMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object result) throws Throwable {
        Logger.info("[trace]afterMethod(), method = %s.%s", method.getDeclaringClass().getName(), method.getName());
        this.endCurrenSpan();
        return null;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        Logger.info("[trace]handleMethodException(), method = %s.%s", method.getDeclaringClass().getName(), method.getName());
        this.endCurrenSpan();
    }

    private void endCurrenSpan() {
        Span span = spanThreadLocal.get();
        if (span != null) {
            span.end();
            spanThreadLocal.remove();
        }
    }
}

