/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import lombok.Generated;

public final class Logger {
    private static Level LEVEL = Level.INFO;

    public static void setLevel(Level level) {
        LEVEL = level;
    }

    public static void trace(String format, Object ... args) {
        Logger.logMessage(Level.TRACE, Level::isTraceEnabled, format, args);
    }

    public static void debug(String format, Object ... args) {
        Logger.logMessage(Level.DEBUG, Level::isDebugEnabled, format, args);
    }

    public static void info(String format, Object ... args) {
        Logger.logMessage(Level.INFO, Level::isInfoEnabled, format, args);
    }

    public static void warn(String format, Object ... args) {
        Logger.logMessage(Level.WARN, Level::isWarnEnabled, format, args);
    }

    public static void error(String format, Object ... args) {
        Logger.logMessage(Level.ERROR, Level::isErrorEnabled, format, args);
    }

    public static void error(String msg, Throwable throwable) {
        Logger.logMessage(Level.ERROR, Level::isErrorEnabled, msg + " error: [%s]", throwable.getMessage());
    }

    private static void logMessage(Level level, Predicate<Level> checkLevel, String format, Object ... args) {
        if (!checkLevel.test(LEVEL)) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        Date nowTime = new Date(System.currentTimeMillis());
        SimpleDateFormat sdFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String strTime = sdFormatter.format(nowTime);
        String msg = String.format(format, args);
        String info = String.format("[%s][%s][%s] %s", strTime, threadName, level.levelStr, msg);
        System.out.println(info);
    }

    public static enum Level {
        NONE(99, "NONE"),
        ERROR(40, "ERROR"),
        WARN(30, "WARN"),
        INFO(20, "INFO"),
        DEBUG(10, "DEBUG"),
        TRACE(0, "TRACE");

        private final int levelInt;
        private final String levelStr;

        boolean isTraceEnabled() {
            return this.levelInt <= Level.TRACE.levelInt;
        }

        boolean isDebugEnabled() {
            return this.levelInt <= Level.DEBUG.levelInt;
        }

        boolean isInfoEnabled() {
            return this.levelInt <= Level.INFO.levelInt;
        }

        boolean isWarnEnabled() {
            return this.levelInt <= Level.WARN.levelInt;
        }

        boolean isErrorEnabled() {
            return this.levelInt <= Level.ERROR.levelInt;
        }

        @Generated
        private Level(int levelInt, String levelStr) {
            this.levelInt = levelInt;
            this.levelStr = levelStr;
        }
    }
}

