/*
 * Decompiled with CFR 0.152.
 */
package pub.ihub.integration.agent.trace.context;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import pub.ihub.integration.core.Logger;

public class IHubTraceContext {
    private static Tracer TracerInst;
    private static OpenTelemetry TelemetryInst;

    public static void initTraceContext(List<SpanExporter> spanExporters) {
        Logger.info((String)"The IHub core context is initializing...", (Object[])new Object[0]);
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder();
        for (SpanExporter exporter : spanExporters) {
            builder.addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)exporter).build());
        }
        SdkTracerProvider tracerProvider = builder.build();
        TelemetryInst = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        Logger.info((String)"The IHub core context has been initialized", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tracer tracer() {
        if (TracerInst != null) return TracerInst;
        Class<IHubTraceContext> clazz = IHubTraceContext.class;
        synchronized (IHubTraceContext.class) {
            TracerInst = TelemetryInst.getTracer("demo", "1.0.0");
            // ** MonitorExit[var0] (shouldn't be in output)
            return TracerInst;
        }
    }

    public static TextMapPropagator textPropagator() {
        return TelemetryInst.getPropagators().getTextMapPropagator();
    }
}

