/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ren.crux.jadb.base.ActivityManagerBase;
import ren.crux.jadb.base.ShellBase;
import ren.crux.jadb.model.Intent;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.OutputUtil;

public class ActivityManager {
    private static final Logger log = LoggerFactory.getLogger(ActivityManager.class);
    protected final ActivityManagerBase base;

    public ActivityManager(ShellBase base) {
        this.base = new ActivityManagerBase(base);
    }

    public boolean forceStop(Target target, String packageName) throws Exception {
        String output = this.base.forceStop(target, packageName);
        return StringUtils.isBlank((CharSequence)output);
    }

    public boolean forceStop(String packageName) throws Exception {
        return this.forceStop(null, packageName);
    }

    public boolean kill(Target target, String packageName) throws Exception {
        String output = this.base.kill(target, packageName);
        return StringUtils.isBlank((CharSequence)output);
    }

    public boolean kill(String packageName) throws Exception {
        return this.kill(null, packageName);
    }

    public boolean killAll(Target target) throws Exception {
        String output = this.base.killAll(target);
        return StringUtils.isBlank((CharSequence)output);
    }

    public boolean killAll() throws Exception {
        return this.killAll(null);
    }

    public boolean startActivity(Target target, boolean debug, boolean wait, int repeat, boolean stop, Intent intent) throws Exception {
        String output = this.base.startActivity(target, debug, wait, repeat, stop, intent);
        List<String> lines = OutputUtil.readLines(output);
        if (!lines.isEmpty()) {
            if (stop) {
                if (!StringUtils.startsWith((CharSequence)lines.get(0), (CharSequence)"Stopping:")) {
                    return false;
                }
                lines.remove(0);
            }
            if (!lines.isEmpty()) {
                if (!StringUtils.startsWith((CharSequence)lines.get(0), (CharSequence)"Starting:")) {
                    return false;
                }
                lines.remove(0);
                if (wait && !lines.isEmpty() && !StringUtils.equals((CharSequence)lines.get(0), (CharSequence)"Status: ok")) {
                    return false;
                }
                if (repeat > 1) {
                    int startCount = 0;
                    int stopCount = 0;
                    for (String line : lines) {
                        if (StringUtils.startsWith((CharSequence)line, (CharSequence)"Starting:")) {
                            ++startCount;
                            continue;
                        }
                        if (!StringUtils.startsWith((CharSequence)line, (CharSequence)"Stopping:")) continue;
                        ++stopCount;
                    }
                    return startCount == repeat - 1 && (!stop || stopCount == repeat - 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean startActivity(boolean debug, boolean wait, int repeat, boolean stop, Intent intent) throws Exception {
        return this.startActivity(null, debug, wait, repeat, stop, intent);
    }

    public boolean startService(Target target, Intent intent) throws Exception {
        String output = this.base.startService(target, intent);
        return StringUtils.startsWith((CharSequence)output, (CharSequence)"Starting service:");
    }

    public boolean startService(Intent intent) throws Exception {
        return this.startService(null, intent);
    }

    public boolean broadcast(Target target, Intent intent) throws Exception {
        String output = this.base.broadcast(target, intent);
        return StringUtils.startsWith((CharSequence)output, (CharSequence)"Broadcasting:");
    }

    public boolean broadcast(Intent intent) throws Exception {
        return this.broadcast(null, intent);
    }

    public String toUri(Intent intent) throws Exception {
        return this.base.toUri(intent);
    }

    public String toIntentUri(Intent intent) throws Exception {
        return this.base.toIntentUri(intent);
    }
}

