/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ren.crux.jadb.base.PackageManagerBase;
import ren.crux.jadb.base.ShellBase;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.OutputUtil;

public class PackageManager {
    protected final PackageManagerBase base;

    public PackageManager(ShellBase base) {
        this.base = new PackageManagerBase(base);
    }

    public List<String> listPackages(Target target, Boolean system, String filter) throws Exception {
        String output = this.base.listPackages(target, system, filter);
        List<String> rows = OutputUtil.readLines(output);
        ArrayList<String> packages = new ArrayList<String>();
        for (String row : rows) {
            packages.add(row.replaceFirst("package:", ""));
        }
        return packages;
    }

    public List<String> listPackages(Boolean system, String filter) throws Exception {
        return this.listPackages(null, system, filter);
    }

    public List<String> listPermissionGroups(Target target) throws Exception {
        String output = this.base.listPermissionGroups(target);
        List<String> rows = OutputUtil.readLines(output);
        ArrayList<String> groups = new ArrayList<String>();
        for (String row : rows) {
            groups.add(row.replaceFirst("permission group:", ""));
        }
        return groups;
    }

    public List<String> listPermissionGroups() throws Exception {
        return this.listPermissionGroups(null);
    }

    public List<String> listPermissions(Target target, boolean dangerous) throws Exception {
        String output = this.base.listPermissions(target, dangerous);
        List<String> rows = OutputUtil.readLines(output);
        ArrayList<String> permissions = new ArrayList<String>();
        for (String row : rows) {
            if (StringUtils.equals((CharSequence)row, (CharSequence)"All Permissions:") || StringUtils.equals((CharSequence)row, (CharSequence)"Dangerous Permissions:")) continue;
            permissions.add(row.replaceFirst("permission:", ""));
        }
        return permissions;
    }

    public List<String> listPermissions(boolean dangerous) throws Exception {
        return this.listPermissions(null, dangerous);
    }

    public boolean grant(Target target, String packageName, String permission) throws Exception {
        String output = this.base.grant(target, packageName, permission);
        return StringUtils.isBlank((CharSequence)output);
    }

    public boolean grant(String packageName, String permission) throws Exception {
        return this.grant(null, packageName, permission);
    }

    public boolean revoke(Target target, String packageName, String permission) throws Exception {
        String output = this.base.revoke(target, packageName, permission);
        return StringUtils.isBlank((CharSequence)output);
    }

    public boolean revoke(String packageName, String permission) throws Exception {
        return this.revoke(null, packageName, permission);
    }

    public boolean clear(Target target, String packageName) throws Exception {
        String output = this.base.clear(target, packageName);
        return output.equals("Success");
    }

    public boolean clear(String packageName) throws Exception {
        return this.clear(null, packageName);
    }
}

