/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.base;

import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import ren.crux.jadb.base.ShellBase;
import ren.crux.jadb.model.Intent;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.CommandLineTools;

public class ActivityManagerBase {
    private final ShellBase base;

    public ActivityManagerBase(ShellBase base) {
        this.base = base;
    }

    private CommandLine create(Target target) {
        return this.base.create(target).addArgument("am");
    }

    public String forceStop(Target target, @NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("force-stop").addArgument(packageName);
        return CommandLineTools.exec(command);
    }

    public String forceStop(@NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        return this.forceStop(null, packageName);
    }

    public String kill(Target target, @NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("kill").addArgument(packageName);
        return CommandLineTools.exec(command);
    }

    public String kill(@NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        return this.kill(null, packageName);
    }

    public String killAll(Target target) throws Exception {
        CommandLine command = this.create(target).addArgument("kill-all");
        return CommandLineTools.exec(command);
    }

    public String killAll() throws Exception {
        return this.killAll(null);
    }

    public String startActivity(Target target, boolean debug, boolean wait, int repeat, boolean stop, @NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("start");
        if (debug) {
            command.addArgument("-D");
        }
        if (wait) {
            command.addArgument("-W");
        }
        if (repeat > 0) {
            command.addArgument("-R").addArgument(String.valueOf(repeat));
        }
        if (stop) {
            command.addArgument("-S");
        }
        return CommandLineTools.exec(intent.write(command));
    }

    public String startActivity(boolean debug, boolean wait, int repeat, boolean stop, @NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        return this.startActivity(null, debug, wait, repeat, stop, intent);
    }

    public String startService(Target target, @NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("startservice");
        return CommandLineTools.exec(intent.write(command));
    }

    public String startService(@NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        return this.startService(null, intent);
    }

    public String broadcast(Target target, @NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("broadcast");
        return CommandLineTools.exec(intent.write(command));
    }

    public String broadcast(@NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        return this.broadcast(null, intent);
    }

    public String toUri(@NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        CommandLine command = this.create(null).addArgument("to-uri");
        return CommandLineTools.exec(intent.write(command));
    }

    public String toIntentUri(@NonNull Intent intent) throws Exception {
        if (intent == null) {
            throw new NullPointerException("intent is marked @NonNull but is null");
        }
        CommandLine command = this.create(null).addArgument("to-intent-uri");
        return CommandLineTools.exec(intent.write(command));
    }
}

