/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.base;

import java.io.File;
import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.ArgumentHelper;
import ren.crux.jadb.util.CommandLineTools;

public class AndroidDebugBridgeBase {
    private String adbShellPath;

    public AndroidDebugBridgeBase() {
        this.adbShellPath = "adb";
    }

    public AndroidDebugBridgeBase(String adbShellPath) {
        this.adbShellPath = adbShellPath;
    }

    protected CommandLine create() {
        return this.create(null);
    }

    protected CommandLine create(Target target) {
        return ArgumentHelper.addTarget(new CommandLine(this.adbShellPath), target);
    }

    public String devices() throws Exception {
        CommandLine command = this.create().addArgument("devices").addArgument("-l");
        return CommandLineTools.exec(command);
    }

    public String connect(@NonNull String serialNumber) throws Exception {
        if (serialNumber == null) {
            throw new NullPointerException("serialNumber is marked @NonNull but is null");
        }
        CommandLine command = this.create().addArgument("connect").addArgument(serialNumber);
        return CommandLineTools.exec(command);
    }

    public String disconnect(@NonNull String serialNumber) throws Exception {
        if (serialNumber == null) {
            throw new NullPointerException("serialNumber is marked @NonNull but is null");
        }
        CommandLine command = this.create().addArgument("disconnect").addArgument(serialNumber);
        return CommandLineTools.exec(command);
    }

    public String install(Target target, @NonNull String path, boolean grantAllPermissions, boolean replace) throws Exception {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        if (!new File(path).exists()) {
            throw new IllegalArgumentException("Invalid path : " + path);
        }
        CommandLine command = this.create(target).addArgument("install");
        if (grantAllPermissions) {
            command.addArgument("-g");
        }
        if (replace) {
            command.addArgument("-r");
        }
        command.addArgument(path);
        return CommandLineTools.exec(command);
    }

    public String install(@NonNull String path, boolean grantAllPermissions, boolean replace) throws Exception {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return this.install(null, path, grantAllPermissions, replace);
    }

    public String uninstall(Target target, @NonNull String packageName, boolean keep) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("uninstall");
        if (keep) {
            command.addArgument("-k");
        }
        command.addArgument(packageName);
        return CommandLineTools.exec(command);
    }

    public String uninstall(@NonNull String packageName, boolean keep) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        return this.uninstall(null, packageName, keep);
    }

    public String tcpip(Target target, int port) throws Exception {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port : " + port);
        }
        CommandLine command = this.create(target).addArgument("tcpip").addArgument(String.valueOf(port));
        return CommandLineTools.exec(command);
    }

    public String tcpip(int port) throws Exception {
        return this.tcpip(null, port);
    }

    public String usb(Target target) throws Exception {
        CommandLine command = this.create(target).addArgument("usb");
        return CommandLineTools.exec(command);
    }

    public String usb() throws Exception {
        return this.usb(null);
    }
}

