/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.base;

import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import ren.crux.jadb.base.ShellBase;
import ren.crux.jadb.model.Target;
import ren.crux.jadb.util.CommandLineTools;

public class PackageManagerBase {
    protected final ShellBase base;

    public PackageManagerBase(ShellBase base) {
        this.base = base;
    }

    protected CommandLine create(Target target) {
        return this.base.create(target).addArgument("pm");
    }

    public String listPackages(Target target, Boolean system, String filter) throws Exception {
        CommandLine command = this.create(target).addArgument("list").addArgument("packages");
        if (system != null) {
            if (system.booleanValue()) {
                command.addArgument("-s");
            } else {
                command.addArgument("-3");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            command.addArgument(filter);
        }
        return CommandLineTools.exec(command);
    }

    public String listPackages(Boolean system, String filter) throws Exception {
        return this.listPackages(null, system, filter);
    }

    public String listPermissionGroups(Target target) throws Exception {
        CommandLine command = this.create(target).addArgument("list").addArgument("permission-groups");
        return CommandLineTools.exec(command);
    }

    public String listPermissionGroups() throws Exception {
        return this.listPermissionGroups(null);
    }

    public String listPermissions(Target target, boolean dangerous) throws Exception {
        CommandLine command = this.create(target).addArgument("list").addArgument("permissions");
        if (dangerous) {
            command.addArgument("-d");
        }
        return CommandLineTools.exec(command);
    }

    public String listPermissions(boolean dangerous) throws Exception {
        return this.listPermissions(null, dangerous);
    }

    public String grant(Target target, @NonNull String packageName, @NonNull String permission) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("grant").addArgument(packageName).addArgument(permission);
        return CommandLineTools.exec(command);
    }

    public String grant(@NonNull String packageName, @NonNull String permission) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked @NonNull but is null");
        }
        return this.grant(null, packageName, permission);
    }

    public String revoke(Target target, @NonNull String packageName, @NonNull String permission) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("revoke").addArgument(packageName).addArgument(permission);
        return CommandLineTools.exec(command);
    }

    public String revoke(@NonNull String packageName, @NonNull String permission) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked @NonNull but is null");
        }
        return this.revoke(null, packageName, permission);
    }

    public String clear(Target target, @NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        CommandLine command = this.create(target).addArgument("clear").addArgument(packageName);
        return CommandLineTools.exec(command);
    }

    public String clear(@NonNull String packageName) throws Exception {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked @NonNull but is null");
        }
        return this.clear(packageName);
    }
}

