/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.jadb.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTools {
    private static final Logger log = LoggerFactory.getLogger(CommandLineTools.class);
    public static long timeout = -1L;

    public static String exec(CommandLine command) throws Exception {
        return CommandLineTools.exec(command, timeout);
    }

    public static String exec(@NonNull CommandLine command, long timeout) throws Exception {
        if (command == null) {
            throw new NullPointerException("command is marked @NonNull but is null");
        }
        log.trace("Command : {} {}", (Object)command.getExecutable(), (Object)StringUtils.join((Object[])command.getArguments(), (String)" "));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, (OutputStream)baos));
        executor.execute(command);
        String output = baos.toString().trim();
        log.debug("Command : {} {}\nOutput :\n{}", new Object[]{command.getExecutable(), StringUtils.join((Object[])command.getArguments(), (String)" "), output});
        return output;
    }
}

