/*
 * Decompiled with CFR 0.152.
 */
package ro.andreimatei.querydsl;

import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.UUID;
import ro.andreimatei.querydsl.SearchCriteria;
import ro.andreimatei.querydsl.exceptions.QueryDSLPredicateBuildException;

public class QueryDSLPredicate<T> {
    private SearchCriteria criteria;

    public QueryDSLPredicate(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public BooleanExpression getPredicate(Class<T> entityClass) throws QueryDSLPredicateBuildException {
        Class typeByPath = this.getLastTypeByPath(entityClass, this.criteria.getKey());
        PathBuilder entityPath = new PathBuilder(entityClass, entityClass.getSimpleName());
        if (typeByPath.equals(String.class)) {
            StringPath path = entityPath.getString(this.criteria.getKey());
            switch (this.criteria.getOperation()) {
                case ":": {
                    if (this.criteria.getValue().toString().equalsIgnoreCase("null")) {
                        return path.isNull();
                    }
                    return path.equalsIgnoreCase(this.criteria.getValue().toString());
                }
                case ";": {
                    return path.containsIgnoreCase(this.criteria.getValue().toString());
                }
                case "!": {
                    return path.notEqualsIgnoreCase(this.criteria.getValue().toString());
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.equals(Long.TYPE)) {
            if (!QueryDSLPredicate.isLong(this.criteria.getValue().toString())) {
                throw new QueryDSLPredicateBuildException(this.criteria.getKey(), this.criteria.getValue().toString(), "Valid long value");
            }
            NumberPath path = entityPath.getNumber(this.criteria.getKey(), Long.class);
            long value = Long.parseLong(this.criteria.getValue().toString());
            switch (this.criteria.getOperation()) {
                case ":": {
                    return path.eq((Object)value);
                }
                case "!": {
                    return path.ne((Object)value);
                }
                case ">": {
                    return path.goe((Number)value);
                }
                case "<": {
                    return path.loe((Number)value);
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.equals(LocalDateTime.class)) {
            if (!QueryDSLPredicate.isLocalDateTime(this.criteria.getValue().toString())) {
                throw new QueryDSLPredicateBuildException(this.criteria.getKey(), this.criteria.getValue().toString(), "Valid LocalDateTime value");
            }
            DateTimePath path = entityPath.getDateTime(this.criteria.getKey(), LocalDateTime.class);
            LocalDateTime value = LocalDateTime.parse(this.criteria.getValue().toString());
            switch (this.criteria.getOperation()) {
                case ":": {
                    return path.eq((Object)value);
                }
                case "!": {
                    return path.ne((Object)value);
                }
                case ">": {
                    return path.after((Comparable)value);
                }
                case "<": {
                    return path.before((Comparable)value);
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.equals(UUID.class)) {
            if (!QueryDSLPredicate.isUUID(this.criteria.getValue().toString())) {
                throw new QueryDSLPredicateBuildException(this.criteria.getKey(), this.criteria.getValue().toString(), "Valid UUID");
            }
            ComparablePath path = entityPath.getComparable(this.criteria.getKey(), UUID.class);
            switch (this.criteria.getOperation()) {
                case ":": {
                    return path.eq((Object)UUID.fromString(this.criteria.getValue().toString()));
                }
                case "!": {
                    return path.ne((Object)UUID.fromString(this.criteria.getValue().toString()));
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.isEnum()) {
            EnumPath path = entityPath.getEnum(this.criteria.getKey(), typeByPath);
            switch (this.criteria.getOperation()) {
                case ":": {
                    return path.eq(Enum.valueOf(typeByPath, (String)this.criteria.getValue()));
                }
                case "!": {
                    return path.ne(Enum.valueOf(typeByPath, (String)this.criteria.getValue()));
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.equals(Boolean.TYPE) || typeByPath.equals(Boolean.class)) {
            BooleanPath path = entityPath.getBoolean(this.criteria.getKey());
            switch (this.criteria.getOperation()) {
                case ":": {
                    return path.eq(Boolean.valueOf(this.criteria.getValue().toString()));
                }
                case "!": {
                    return path.ne((Object)Boolean.valueOf(this.criteria.getValue().toString()));
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        if (typeByPath.getPackage().getName().equals("ro.smarty.data")) {
            switch (this.criteria.getOperation()) {
                case ":": {
                    if (!this.criteria.getValue().toString().equalsIgnoreCase("null")) break;
                    return entityPath.get(this.criteria.getKey(), typeByPath).isNull();
                }
            }
            throw new QueryDSLPredicateBuildException(this.criteria.getKey() + "'s search operator", this.criteria.getOperation(), "Valid Search Operator");
        }
        throw new QueryDSLPredicateBuildException("search field", this.criteria.getKey(), "Valid Search Field");
    }

    private Class getLastTypeByPath(Class<T> entityClass, String path) throws QueryDSLPredicateBuildException {
        String[] types = path.split("\\.");
        Class<Object> returnType = entityClass;
        for (String type : types) {
            try {
                returnType = returnType.getDeclaredField(type).getType();
            }
            catch (NoSuchFieldException e) {
                throw new QueryDSLPredicateBuildException("search field", this.criteria.getKey(), "Valid Search Field");
            }
        }
        return returnType;
    }

    private static boolean isLong(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isLocalDateTime(String str) {
        try {
            LocalDateTime.parse(str);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isUUID(String str) {
        try {
            UUID.fromString(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

