/*
 * Decompiled with CFR 0.152.
 */
package ro.andreimatei.querydsl;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.andreimatei.querydsl.QueryDSLPredicate;
import ro.andreimatei.querydsl.SearchCriteria;
import ro.andreimatei.querydsl.exceptions.QueryDSLPredicateBuildException;

public final class QueryDSLPredicatesBuilder<T> {
    private final List<SearchCriteria> searchCriteriaList = new ArrayList<SearchCriteria>();
    private final Class<T> entityClass;

    public QueryDSLPredicatesBuilder(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public QueryDSLPredicatesBuilder with(String key, String operation, Object value) {
        this.searchCriteriaList.add(new SearchCriteria(key, operation, value));
        return this;
    }

    public QueryDSLPredicatesBuilder with(String search) {
        Pattern pattern = Pattern.compile("([^,]+)([:;!<>])([^,]+)");
        Matcher matcher = pattern.matcher(search);
        while (matcher.find()) {
            this.with(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        return this;
    }

    public BooleanExpression build() throws QueryDSLPredicateBuildException {
        if (this.searchCriteriaList.size() == 0) {
            return null;
        }
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        for (SearchCriteria param : this.searchCriteriaList) {
            QueryDSLPredicate<T> predicate = new QueryDSLPredicate<T>(param);
            BooleanExpression exp = predicate.getPredicate(this.entityClass);
            if (exp == null) continue;
            predicates.add(exp);
        }
        BooleanExpression result = (BooleanExpression)predicates.get(0);
        for (int i = 1; i < predicates.size(); ++i) {
            result = result.and((Predicate)predicates.get(i));
        }
        return result;
    }

    public List<SearchCriteria> getSearchCriteriaList() {
        return this.searchCriteriaList;
    }
}

