/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import ro.pippo.session.DefaultSessionData;
import ro.pippo.session.SessionData;
import ro.pippo.session.SessionDataStorage;

public class HazelcastSessionDataStorage
implements SessionDataStorage {
    private static final String SESSION_NAME = "session";
    private final IMap<String, SessionData> sessions;

    public HazelcastSessionDataStorage(HazelcastInstance hazelcastInstance) {
        this(SESSION_NAME, hazelcastInstance);
    }

    public HazelcastSessionDataStorage(String name, HazelcastInstance hazelcastInstance) {
        this.sessions = hazelcastInstance.getMap(name);
    }

    public HazelcastSessionDataStorage(IMap<String, SessionData> sessions) {
        this.sessions = sessions;
    }

    public SessionData create() {
        return new DefaultSessionData();
    }

    public void save(SessionData sessionData) {
        this.sessions.put((Object)sessionData.getId(), (Object)sessionData);
    }

    public SessionData get(String sessionId) {
        return (SessionData)this.sessions.get((Object)sessionId);
    }

    public void delete(String sessionId) {
        this.sessions.remove((Object)sessionId);
    }
}

