/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.impl.LiteralLabel;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.providers.DatatypeProvider;
import org.semanticweb.owlapi.model.providers.EntityProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.owlapi.InternalizedEntities;
import ru.avicomp.ontapi.owlapi.OWLImportsDeclarationImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLAnnotationAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLAnnotationPropertyDomainAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLAnnotationPropertyRangeAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLAsymmetricObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLClassAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDataPropertyAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDataPropertyDomainAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDataPropertyRangeAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDatatypeDefinitionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDeclarationAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDifferentIndividualsAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDisjointClassesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDisjointDataPropertiesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDisjointObjectPropertiesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDisjointUnionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLEquivalentClassesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLEquivalentDataPropertiesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLEquivalentObjectPropertiesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLFunctionalDataPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLFunctionalObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLHasKeyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLInverseFunctionalObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLInverseObjectPropertiesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLIrreflexiveObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLNegativeDataPropertyAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLNegativeObjectPropertyAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLObjectPropertyAssertionAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLObjectPropertyDomainAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLObjectPropertyRangeAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLReflexiveObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSameIndividualAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubAnnotationPropertyOfAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubClassOfAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubDataPropertyOfAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubObjectPropertyOfAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubPropertyChainAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSymmetricObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLTransitiveObjectPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.SWRLRuleImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLAnnotationImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLAnnotationImplNotAnnotated;
import ru.avicomp.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLFacetRestrictionImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLLiteralImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLObjectInverseOfImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataAllValuesFromImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataExactCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataHasValueImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataMaxCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataMinCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLDataSomeValuesFromImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectAllValuesFromImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectComplementOfImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectExactCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectHasSelfImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectHasValueImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectIntersectionOfImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectMaxCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectMinCardinalityImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectOneOfImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectSomeValuesFromImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectUnionOfImpl;
import ru.avicomp.ontapi.owlapi.objects.dr.OWLDataComplementOfImpl;
import ru.avicomp.ontapi.owlapi.objects.dr.OWLDataIntersectionOfImpl;
import ru.avicomp.ontapi.owlapi.objects.dr.OWLDataOneOfImpl;
import ru.avicomp.ontapi.owlapi.objects.dr.OWLDataUnionOfImpl;
import ru.avicomp.ontapi.owlapi.objects.dr.OWLDatatypeRestrictionImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLAnnotationPropertyImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLClassImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLDataPropertyImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLDatatypeImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLNamedIndividualImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLObjectPropertyImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLBuiltInAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLClassAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLDataPropertyAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLDataRangeAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLDifferentIndividualsAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLIndividualArgumentImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLLiteralArgumentImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLObjectPropertyAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLSameIndividualAtomImpl;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLVariableImpl;

public class DataFactoryImpl
implements DataFactory {
    private static final String LEXICAL_VALUE_CANNOT_BE_NULL = "lexicalValue cannot be null";
    private static final String LITERAL_CANNOT_BE_NULL = "literal cannot be null";
    private static final String VAR_CANNOT_BE_NULL = "var cannot be null";
    private static final String BUILT_IN_IRI_CANNOT_BE_NULL = "builtInIRI cannot be null";
    private static final String ARGS_CANNOT_BE_NULL = "args cannot be null";
    private static final String ARG1_CANNOT_BE_NULL = "arg1 cannot be null";
    private static final String ARG0_CANNOT_BE_NULL = "arg0 cannot be null";
    private static final String ARG_CANNOT_BE_NULL = "arg cannot be null";
    private static final String PREDICATE_CANNOT_BE_NULL = "predicate cannot be null";
    private static final String HEAD_CANNOT_BE_NULL = "head cannot be null";
    private static final String BODY_CANNOT_BE_NULL = "body cannot be null";
    private static final String ANNOTATION_CANNOT_BE_NULL = "annotation cannot be null";
    private static final String OWL_CLASS_CANNOT_BE_NULL = "owlClass cannot be null";
    private static final String CHAIN_CANNOT_BE_NULL = "chain cannot be null";
    private static final String INVERSE_PROPERTY_CANNOT_BE_NULL = "inverseProperty cannot be null";
    private static final String FORWARD_PROPERTY_CANNOT_BE_NULL = "forwardProperty cannot be null";
    private static final String SUPERCLASS_CANNOT_BE_NULL = "superclass cannot be null";
    private static final String SUBCLASS_CANNOT_BE_NULL = "subclass cannot be null";
    private static final String RANGE_CANNOT_BE_NULL = "range cannot be null";
    private static final String SUBJECT_CANNOT_BE_NULL = "subject cannot be null";
    private static final String OBJECT_CANNOT_BE_NULL = "object cannot be null";
    private static final String IMPORTED_ONTOLOGY_IRI_CANNOT_BE_NULL = "importedOntologyIRI cannot be null";
    private static final String CLASS_EXPRESSIONS_CANNOT_BE_NULL = "classExpressions cannot be null";
    private static final String PROPERTIES_CANNOT_BE_NULL = "properties cannot be null";
    private static final String CLASS_EXPRESSIONS_CANNOT_BE_NULL_OR_CONTAIN_NULL = "classExpressions cannot be null or contain null";
    private static final String INDIVIDUALS_CANNOT_BE_NULL = "individuals cannot be null";
    private static final String OWL_ENTITY_CANNOT_BE_NULL = "owlEntity cannot be null";
    private static final String SUPER_PROPERTY_CANNOT_BE_NULL = "superProperty cannot be null";
    private static final String SUB_PROPERTY_CANNOT_BE_NULL = "subProperty cannot be null";
    private static final String OWL_DATA_RANGE_CANNOT_BE_NULL = "owlDataRange cannot be null";
    private static final String DOMAIN_CANNOT_BE_NULL = "domain cannot be null";
    private static final String INDIVIDUAL_CANNOT_BE_NULL = "individual cannot be null";
    private static final String CLASS_EXPRESSION_CANNOT_BE_NULL = "classExpression cannot be null";
    private static final String VALUE_CANNOT_BE_NULL = "value cannot be null";
    private static final String CARDINALITY_CANNOT_BE_NEGATIVE = "cardinality cannot be negative";
    private static final String FACET_VALUE_CANNOT_BE_NULL = "facetValue cannot be null";
    private static final String PROPERTY_CANNOT_BE_NULL = "property cannot be null";
    private static final String TYPED_CONSTANT_CANNOT_BE_NULL = "typedConstant cannot be null";
    private static final String FACET_CANNOT_BE_NULL = "facet cannot be null";
    private static final String DATATYPE_CANNOT_BE_NULL = "datatype cannot be null";
    private static final String DATA_RANGE_CANNOT_BE_NULL = "dataRange cannot be null";
    private static final String ID_CANNOT_BE_NULL = "id cannot be null";
    private static final String IRI_CANNOT_BE_NULL = "iri cannot be null";
    private static final String ENTITY_TYPE_CANNOT_BE_NULL = "entityType cannot be null";
    private static final String ANNOTATIONS_CANNOT_BE_NULL = "annotations cannot be null";

    private static void checkNotNegativeCardinality(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(CARDINALITY_CANNOT_BE_NEGATIVE);
        }
    }

    private static void checkAnnotations(Collection<OWLAnnotation> o) {
        Objects.requireNonNull(o, ANNOTATIONS_CANNOT_BE_NULL);
    }

    public void purge() {
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType, IRI iri) {
        Objects.requireNonNull(entityType, ENTITY_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return (E)entityType.buildEntity(iri, (EntityProvider)this);
    }

    public OWLClass getOWLClass(IRI iri) {
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return new OWLClassImpl(iri);
    }

    public OWLAnnotationProperty getRDFSLabel() {
        return InternalizedEntities.RDFS_LABEL;
    }

    public OWLAnnotationProperty getRDFSComment() {
        return InternalizedEntities.RDFS_COMMENT;
    }

    public OWLAnnotationProperty getRDFSSeeAlso() {
        return InternalizedEntities.RDFS_SEE_ALSO;
    }

    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return InternalizedEntities.RDFS_IS_DEFINED_BY;
    }

    public OWLAnnotationProperty getOWLVersionInfo() {
        return InternalizedEntities.OWL_VERSION_INFO;
    }

    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return InternalizedEntities.OWL_BACKWARD_COMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return InternalizedEntities.OWL_INCOMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLDeprecated() {
        return InternalizedEntities.OWL_DEPRECATED;
    }

    public OWLClass getOWLThing() {
        return InternalizedEntities.OWL_THING;
    }

    public OWLClass getOWLNothing() {
        return InternalizedEntities.OWL_NOTHING;
    }

    public OWLDataProperty getOWLBottomDataProperty() {
        return InternalizedEntities.OWL_BOTTOM_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLBottomObjectProperty() {
        return InternalizedEntities.OWL_BOTTOM_OBJECT_PROPERTY;
    }

    public OWLDataProperty getOWLTopDataProperty() {
        return InternalizedEntities.OWL_TOP_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLTopObjectProperty() {
        return InternalizedEntities.OWL_TOP_OBJECT_PROPERTY;
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return new OWLObjectPropertyImpl(iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return new OWLDataPropertyImpl(iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return new OWLNamedIndividualImpl(iri);
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        return this.getOWLAnonymousIndividual(BlankNodeId.create((String)nodeId));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return this.getOWLAnonymousIndividual(BlankNodeId.create());
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(BlankNodeId id) {
        return new OWLAnonymousIndividualImpl(Objects.requireNonNull(id, ID_CANNOT_BE_NULL));
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLDataOneOf getOWLDataOneOf(Stream<? extends OWLLiteral> values) {
        return new OWLDataOneOfImpl(values);
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange dataRange) {
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        return new OWLDataComplementOfImpl(dataRange);
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWL2Datatype dataRange) {
        return this.getOWLDataComplementOf((OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(Stream<? extends OWLDataRange> dataRanges) {
        return new OWLDataIntersectionOfImpl(dataRanges.map(x -> x));
    }

    public OWLDataUnionOf getOWLDataUnionOf(Stream<? extends OWLDataRange> dataRanges) {
        return new OWLDataUnionOfImpl(dataRanges.map(x -> x));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, Collection<OWLFacetRestriction> facetRestrictions) {
        Objects.requireNonNull(dataType, DATATYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(facetRestrictions, "facets");
        return new OWLDatatypeRestrictionImpl(dataType, facetRestrictions);
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacet facet, OWLLiteral typedLiteral) {
        Objects.requireNonNull(dataType, DATATYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(facet, FACET_CANNOT_BE_NULL);
        Objects.requireNonNull(typedLiteral, TYPED_CONSTANT_CANNOT_BE_NULL);
        return new OWLDatatypeRestrictionImpl(dataType, CollectionFactory.createSet((Object)this.getOWLFacetRestriction(facet, typedLiteral)));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        Objects.requireNonNull(facet, FACET_CANNOT_BE_NULL);
        Objects.requireNonNull(facetValue, FACET_VALUE_CANNOT_BE_NULL);
        return new OWLFacetRestrictionImpl(facet, facetValue);
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Stream<? extends OWLClassExpression> operands) {
        return new OWLObjectIntersectionOfImpl(operands.map(x -> x));
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectIntersectionOfImpl(operands);
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataAllValuesFromImpl(property, dataRange);
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataAllValuesFrom(property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataExactCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        return new OWLDataExactCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataExactCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMaxCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        return new OWLDataMaxCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataMaxCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMinCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMinCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataMinCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLDataSomeValuesFromImpl(property, dataRange);
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataSomeValuesFrom(property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(value, VALUE_CANNOT_BE_NULL);
        return new OWLDataHasValueImpl(property, value);
    }

    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        Objects.requireNonNull(operand, "operand");
        return new OWLObjectComplementOfImpl(operand);
    }

    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectAllValuesFromImpl(property, classExpression);
    }

    public OWLObjectOneOf getOWLObjectOneOf(Stream<? extends OWLIndividual> values) {
        return new OWLObjectOneOfImpl(values.map(x -> x));
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectExactCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        return new OWLObjectExactCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMinCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        return new OWLObjectMinCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMaxCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        DataFactoryImpl.checkNotNegativeCardinality(cardinality);
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMaxCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectHasSelfImpl(property);
    }

    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectSomeValuesFromImpl(property, classExpression);
    }

    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(individual, INDIVIDUAL_CANNOT_BE_NULL);
        return new OWLObjectHasValueImpl(property, individual);
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Stream<? extends OWLClassExpression> operands) {
        return new OWLObjectUnionOfImpl(operands.map(x -> x));
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectUnionOfImpl(operands);
    }

    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression properties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(properties, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLAsymmetricObjectPropertyAxiomImpl(properties, annotations);
    }

    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(domain, DOMAIN_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyDomainAxiomImpl(property, domain, annotations);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(owlDataRange, OWL_DATA_RANGE_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyRangeAxiomImpl(property, owlDataRange, annotations);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWL2Datatype owlDataRange, Collection<OWLAnnotation> annotations) {
        return this.getOWLDataPropertyRangeAxiom(property, (OWLDataRange)owlDataRange.getDatatype((DatatypeProvider)this), annotations);
    }

    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(subProperty, SUB_PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubDataPropertyOfAxiomImpl(subProperty, superProperty, annotations);
    }

    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(owlEntity, OWL_ENTITY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDeclarationAxiomImpl(owlEntity, annotations);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(individuals, INDIVIDUALS_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDifferentIndividualsAxiomImpl(individuals, annotations);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Collection<? extends OWLClassExpression> classes, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(classes, CLASS_EXPRESSIONS_CANNOT_BE_NULL_OR_CONTAIN_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        if (classes.size() == 1) {
            HashSet<Object> modifiedClassExpressions = new HashSet<Object>(2);
            OWLClassExpression clazz = classes.iterator().next();
            OWLClass addedClass = clazz.isOWLThing() ? InternalizedEntities.OWL_NOTHING : InternalizedEntities.OWL_THING;
            modifiedClassExpressions.add(addedClass);
            modifiedClassExpressions.add(clazz);
            return this.getOWLDisjointClassesAxiom(modifiedClassExpressions, this.makeSingletonDisjointClassWarningAnnotation(annotations, clazz, (OWLClassExpression)addedClass));
        }
        return new OWLDisjointClassesAxiomImpl(classes, annotations);
    }

    private Set<OWLAnnotation> makeSingletonDisjointClassWarningAnnotation(Collection<OWLAnnotation> annotations, OWLClassExpression classExpression, OWLClassExpression addedClass) {
        HashSet<OWLAnnotation> modifiedAnnotations = new HashSet<OWLAnnotation>(annotations.size() + 1);
        modifiedAnnotations.addAll(annotations);
        String provenanceComment = String.format("%s on %s", VersionInfo.getVersionInfo().getGeneratedByMessage(), Instant.now());
        OWLAnnotation provenanceAnnotation = this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(provenanceComment));
        Set<OWLAnnotation> metaAnnotations = Collections.singleton(provenanceAnnotation);
        String changeComment = String.format("DisjointClasses(%s) replaced by DisjointClasses(%s %s)", classExpression, classExpression, addedClass);
        modifiedAnnotations.add(this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(changeComment), metaAnnotations));
        return modifiedAnnotations;
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(properties, PROPERTIES_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointDataPropertiesAxiomImpl(properties, annotations);
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(properties, PROPERTIES_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointObjectPropertiesAxiomImpl(properties, annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Collection<? extends OWLClassExpression> classes, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(classes, CLASS_EXPRESSIONS_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentClassesAxiomImpl(classes, annotations);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(properties, PROPERTIES_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentDataPropertiesAxiomImpl(properties, annotations);
    }

    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalDataPropertyAxiomImpl(property, annotations);
    }

    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        Objects.requireNonNull(importedOntologyIRI, IMPORTED_ONTOLOGY_IRI_CANNOT_BE_NULL);
        return new OWLImportsDeclarationImpl(importedOntologyIRI);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(object, OBJECT_CANNOT_BE_NULL);
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(object, OBJECT_CANNOT_BE_NULL);
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(object, OBJECT_CANNOT_BE_NULL);
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(individual, INDIVIDUAL_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLClassAssertionAxiomImpl(individual, classExpression, annotations);
    }

    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLIrreflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyDomainAxiomImpl(property, classExpression, annotations);
    }

    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(range, RANGE_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyRangeAxiomImpl(property, range, annotations);
    }

    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(subProperty, SUB_PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubObjectPropertyOfAxiomImpl(subProperty, superProperty, annotations);
    }

    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLReflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(individuals, INDIVIDUALS_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSameIndividualAxiomImpl(individuals, annotations);
    }

    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(subClass, SUBCLASS_CANNOT_BE_NULL);
        Objects.requireNonNull(superClass, SUPERCLASS_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubClassOfAxiomImpl(subClass, superClass, annotations);
    }

    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSymmetricObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLTransitiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectProperty property) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectInverseOfImpl(property);
    }

    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(forwardProperty, FORWARD_PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(inverseProperty, INVERSE_PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseObjectPropertiesAxiomImpl(forwardProperty, inverseProperty, annotations);
    }

    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(chain, CHAIN_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubPropertyChainAxiomImpl(chain, superProperty, annotations);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, Collection<? extends OWLPropertyExpression> objectProperties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(ce, CLASS_EXPRESSION_CANNOT_BE_NULL);
        Objects.requireNonNull(objectProperties, PROPERTIES_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLHasKeyAxiomImpl(ce, objectProperties, annotations);
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, Stream<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(owlClass, OWL_CLASS_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointUnionAxiomImpl(owlClass, classExpressions.map(x -> x), annotations);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(properties, PROPERTIES_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentObjectPropertiesAxiomImpl(properties, annotations);
    }

    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(individual, INDIVIDUAL_CANNOT_BE_NULL);
        Objects.requireNonNull(object, OBJECT_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyAssertionAxiomImpl(individual, property, object, annotations);
    }

    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(sub, SUB_PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(sup, SUPER_PROPERTY_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubAnnotationPropertyOfAxiomImpl(sub, sup, annotations);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        Objects.requireNonNull(iri, IRI_CANNOT_BE_NULL);
        return new OWLAnnotationPropertyImpl(iri);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return new OWLAnnotationImplNotAnnotated(property, value);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> annotations) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(value, VALUE_CANNOT_BE_NULL);
        Objects.requireNonNull(annotations, ANNOTATIONS_CANNOT_BE_NULL);
        return new OWLAnnotationImpl(property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation) {
        Objects.requireNonNull(annotation, ANNOTATION_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotation.annotations().collect(Collectors.toList()));
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(annotation, ANNOTATION_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(value, VALUE_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationAssertionAxiomImpl(subject, property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), (OWLAnnotationSubject)subject, (OWLAnnotationValue)this.getOWLLiteral(true));
    }

    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(prop, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(domain, DOMAIN_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyDomainAxiomImpl(prop, domain, annotations);
    }

    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(prop, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(range, RANGE_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyRangeAxiomImpl(prop, range, annotations);
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(body, BODY_CANNOT_BE_NULL);
        Objects.requireNonNull(head, HEAD_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new SWRLRuleImpl(body, head, annotations);
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head) {
        Objects.requireNonNull(body, BODY_CANNOT_BE_NULL);
        Objects.requireNonNull(head, HEAD_CANNOT_BE_NULL);
        return new SWRLRuleImpl(body, head);
    }

    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        Objects.requireNonNull(predicate, PREDICATE_CANNOT_BE_NULL);
        Objects.requireNonNull(arg, ARG_CANNOT_BE_NULL);
        return new SWRLClassAtomImpl(predicate, arg);
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        Objects.requireNonNull(predicate, PREDICATE_CANNOT_BE_NULL);
        Objects.requireNonNull(arg, ARG_CANNOT_BE_NULL);
        return new SWRLDataRangeAtomImpl(predicate, arg);
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWL2Datatype predicate, SWRLDArgument arg) {
        return this.getSWRLDataRangeAtom((OWLDataRange)predicate.getDatatype((DatatypeProvider)this), arg);
    }

    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(arg0, ARG0_CANNOT_BE_NULL);
        Objects.requireNonNull(arg1, ARG1_CANNOT_BE_NULL);
        return new SWRLObjectPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        Objects.requireNonNull(property, PROPERTY_CANNOT_BE_NULL);
        Objects.requireNonNull(arg0, ARG0_CANNOT_BE_NULL);
        Objects.requireNonNull(arg1, ARG1_CANNOT_BE_NULL);
        return new SWRLDataPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        Objects.requireNonNull(builtInIRI, BUILT_IN_IRI_CANNOT_BE_NULL);
        Objects.requireNonNull(args, ARGS_CANNOT_BE_NULL);
        return new SWRLBuiltInAtomImpl(builtInIRI, args);
    }

    public SWRLVariable getSWRLVariable(IRI var) {
        return new SWRLVariableImpl(Objects.requireNonNull(var, VAR_CANNOT_BE_NULL));
    }

    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        Objects.requireNonNull(individual, INDIVIDUAL_CANNOT_BE_NULL);
        return new SWRLIndividualArgumentImpl(individual);
    }

    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        Objects.requireNonNull(literal, LITERAL_CANNOT_BE_NULL);
        return new SWRLLiteralArgumentImpl(literal);
    }

    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        Objects.requireNonNull(arg0, ARG0_CANNOT_BE_NULL);
        Objects.requireNonNull(arg1, ARG1_CANNOT_BE_NULL);
        return new SWRLDifferentIndividualsAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_DIFFERENT_FROM), arg0, arg1);
    }

    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        Objects.requireNonNull(arg0, ARG0_CANNOT_BE_NULL);
        Objects.requireNonNull(arg1, ARG1_CANNOT_BE_NULL);
        return new SWRLSameIndividualAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_SAME_AS), arg0, arg1);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange, Collection<OWLAnnotation> annotations) {
        Objects.requireNonNull(datatype, DATATYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(dataRange, DATA_RANGE_CANNOT_BE_NULL);
        DataFactoryImpl.checkAnnotations(annotations);
        return new OWLDatatypeDefinitionAxiomImpl(datatype, dataRange, annotations);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWL2Datatype dataRange, Collection<OWLAnnotation> annotations) {
        return this.getOWLDatatypeDefinitionAxiom(datatype, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this), annotations);
    }

    public OWLLiteral getOWLLiteral(boolean b) {
        return b ? InternalizedEntities.TRUE_LITERAL : InternalizedEntities.FALSE_LITERAL;
    }

    public OWLLiteral getOWLLiteral(int i) {
        return OWLLiteralImpl.createLiteral(i);
    }

    public OWLLiteral getOWLLiteral(double d) {
        return OWLLiteralImpl.createLiteral(d);
    }

    public OWLLiteral getOWLLiteral(float f) {
        return OWLLiteralImpl.createLiteral(f);
    }

    public OWLLiteral getOWLLiteral(String txt) {
        return OWLLiteralImpl.createLiteral(Objects.requireNonNull(txt, VALUE_CANNOT_BE_NULL));
    }

    public OWLLiteral getOWLLiteral(String txt, String lang) {
        return OWLLiteralImpl.createLiteral(Objects.requireNonNull(txt, LITERAL_CANNOT_BE_NULL), lang);
    }

    public OWLLiteral getOWLLiteral(String txt, OWLDatatype dt) {
        return OWLLiteralImpl.createLiteral(Objects.requireNonNull(txt, LEXICAL_VALUE_CANNOT_BE_NULL), Objects.requireNonNull(dt, DATATYPE_CANNOT_BE_NULL));
    }

    @Override
    public OWLLiteral getOWLLiteral(LiteralLabel label) {
        return OWLLiteralImpl.newLiteral(Objects.requireNonNull(label, VALUE_CANNOT_BE_NULL));
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return InternalizedEntities.XSD_BOOLEAN;
    }

    public OWLDatatype getStringOWLDatatype() {
        return InternalizedEntities.XSD_STRING;
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return InternalizedEntities.XSD_DOUBLE;
    }

    public OWLDatatype getFloatOWLDatatype() {
        return InternalizedEntities.XSD_FLOAT;
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return InternalizedEntities.XSD_INTEGER;
    }

    public OWLDatatype getTopDatatype() {
        return InternalizedEntities.RDFS_LITERAL;
    }

    public OWLDatatype getRDFPlainLiteral() {
        return InternalizedEntities.RDF_PLAIN_LITERAL;
    }
}

