/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import com.google.common.reflect.Reflection;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import ru.avicomp.ontapi.OntApiException;

public class OWLLangRegistry {
    private static Map<String, OWLLang> registry = LangKey.asMap();

    public static OWLLang register(OWLLang lang) {
        return OWLLangRegistry.register(lang.getType().getName(), lang);
    }

    public static OWLLang register(String key, OWLLang lang) {
        return registry.put(key, lang);
    }

    public static OWLLang unregister(String key) {
        return registry.remove(key);
    }

    public static Optional<OWLLang> getLang(String key) {
        return Optional.ofNullable(registry.get(key));
    }

    public static Stream<String> keys() {
        return registry.keySet().stream();
    }

    public static Stream<OWLStorerFactory> storerFactories() {
        return registry.values().stream().filter(Objects::nonNull).map(OWLLang::getStorerFactory).filter(Objects::nonNull);
    }

    public static Stream<OWLParserFactory> parserFactories() {
        return registry.values().stream().filter(Objects::nonNull).map(OWLLang::getParserFactory).filter(Objects::nonNull);
    }

    private static OWLLang create(Class<? extends OWLStorerFactory> storerFactoryClass, Class<? extends OWLParserFactory> parserFactoryClass, Supplier<OWLDocumentFormat> factory) throws LangException {
        OWLStorerFactory storer = null;
        OWLParserFactory parser = null;
        if (storerFactoryClass != null) {
            storer = OWLLangRegistry.newInstance(storerFactoryClass);
        }
        if (parserFactoryClass != null) {
            parser = OWLLangRegistry.newInstance(parserFactoryClass);
        }
        return OWLLangRegistry.create(storer, parser, factory);
    }

    private static OWLLang create(OWLStorerFactory storer, OWLParserFactory parser, Supplier<OWLDocumentFormat> factory) throws LangException {
        OWLDocumentFormat format = null;
        if (storer != null) {
            format = storer.getFormatFactory().createFormat();
        }
        if (parser != null) {
            OWLDocumentFormat parserFormat = parser.getSupportedFormat().createFormat();
            if (format == null) {
                format = parserFormat;
            } else if (!format.getClass().equals(parserFormat.getClass())) {
                throw new LangException(String.format("Storer/Parser formats do not match. Storer: %s. Parser: %s.", OWLLangRegistry.toClassName(storer), OWLLangRegistry.toClassName(parser)));
            }
        }
        if (format == null) {
            throw new LangException(String.format("Unable to determine format. Storer: %s. Parser: %s.", OWLLangRegistry.toClassName(storer), OWLLangRegistry.toClassName(parser)));
        }
        if (factory == null) {
            factory = OWLLangRegistry.makeFormatFactory(storer, parser);
        }
        return new OWLLang(format.getClass(), storer, parser, factory);
    }

    public static OWLLang create(OWLStorerFactory storer, OWLParserFactory parser) {
        return OWLLangRegistry.create(storer, parser, null);
    }

    private static Supplier<OWLDocumentFormat> makeFormatFactory(OWLStorerFactory storer, OWLParserFactory parser) {
        return storer != null ? () -> storer.getFormatFactory().createFormat() : (parser != null ? () -> parser.getSupportedFormat().createFormat() : null);
    }

    private static String toClassName(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    private static <T> Class<? extends T> findClass(Class<T> baseType, String className) throws LangException {
        Class<?> res = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (!baseType.isAssignableFrom(clazz)) {
                throw new LangException(className + " is not subtype of " + baseType.getName());
            }
            res = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return res;
    }

    private static <T> T newInstance(Class<T> type) throws LangException {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new LangException("Can't create instance of " + type.getName(), e);
        }
    }

    private static OWLDocumentFormat makeBinaryFormat(Class<? extends OWLDocumentFormat> implType, Class<? extends OWLDocumentFormat> interfaceType) {
        OWLDocumentFormat target = OWLLangRegistry.newInstance(implType);
        return (OWLDocumentFormat)Reflection.newProxy(interfaceType, (proxy, method, args) -> {
            if ("isTextual".equals(method.getName())) {
                return false;
            }
            return method.invoke((Object)target, args);
        });
    }

    public static class LangException
    extends OntApiException {
        public LangException() {
        }

        public LangException(String message) {
            super(message);
        }

        public LangException(String message, Throwable cause) {
            super(message, cause);
        }

        public LangException(Throwable cause) {
            super(cause);
        }
    }

    public static class OWLLang {
        private final Class<? extends OWLDocumentFormat> format;
        private final OWLStorerFactory storer;
        private final OWLParserFactory parser;
        private final Supplier<OWLDocumentFormat> factory;

        protected OWLLang(Class<? extends OWLDocumentFormat> type, OWLStorerFactory storer, OWLParserFactory parser, Supplier<OWLDocumentFormat> factory) {
            this.format = Objects.requireNonNull(type, "Format type can not be null.");
            this.storer = storer;
            this.parser = parser;
            this.factory = factory;
        }

        public String toString() {
            return this.format.getName() + "[" + (this.storer != null) + ", " + (this.parser != null) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OWLLang)) {
                return false;
            }
            OWLLang other = (OWLLang)o;
            return Objects.equals(this.format, other.format);
        }

        public int hashCode() {
            return this.format.hashCode();
        }

        public Class<? extends OWLDocumentFormat> getType() {
            return this.format;
        }

        public OWLStorerFactory getStorerFactory() {
            return this.storer;
        }

        public OWLParserFactory getParserFactory() {
            return this.parser;
        }

        public Supplier<OWLDocumentFormat> getFormatFactory() {
            return this.factory;
        }

        public boolean isWritable() {
            return this.storer != null;
        }

        public boolean isReadable() {
            return this.parser != null;
        }
    }

    public static enum LangKey {
        RIORDFXML("RioRDFXMLDocumentFormat", "rio.RioRDFXMLStorerFactory", "rio.RioRDFXMLParserFactory"),
        TRIX("TrixDocumentFormat", "rio.RioTrixStorerFactory", "rio.RioTrixParserFactory"),
        NQUADS("NQuadsDocumentFormat", "rio.RioNQuadsStorerFactory", "rio.RioNQuadsParserFactory"),
        NTRIPLES("NTriplesDocumentFormat", "rio.RioNTriplesStorerFactory", "rio.RioNTriplesParserFactory"),
        TRIG("TrigDocumentFormat", "rio.RioTrigStorerFactory", "rio.RioTrigParserFactory"),
        RDFJSON("RDFJsonDocumentFormat", "rio.RioJsonStorerFactory", "rio.RioJsonParserFactory"),
        BINARYRDF("BinaryRDFDocumentFormat", "rio.RioBinaryRdfStorerFactory", "rio.RioBinaryRdfParserFactory"){

            @Override
            protected Supplier<OWLDocumentFormat> getDefaultFormatFactory() {
                return () -> {
                    String name = "org.semanticweb.owlapi.formats.RioRDFDocumentFormat";
                    Class type = OWLLangRegistry.findClass(OWLDocumentFormat.class, name);
                    if (type == null) {
                        throw new LangException("Can't find " + name + " in class-path");
                    }
                    return OWLLangRegistry.makeBinaryFormat(this.getType(), type);
                };
            }
        }
        ,
        RIOTURTLE("RioTurtleDocumentFormat", "rio.RioTurtleStorerFactory", "rio.RioTurtleParserFactory"),
        RDFJSONLD("RDFJsonLDDocumentFormat", "rio.RioJsonLDStorerFactory", "rio.RioJsonLDParserFactory"),
        N3("N3DocumentFormat", "rio.RioN3StorerFactory", "rio.RioN3ParserFactory"),
        RDFXML("RDFXMLDocumentFormat", "rdf.rdfxml.renderer.RDFXMLStorerFactory", "rdf.rdfxml.parser.RDFXMLParserFactory"),
        DLSYNTAXHTML("DLSyntaxHTMLDocumentFormat", "dlsyntax.renderer.DLSyntaxHTMLStorerFactory", null),
        OWLXML("OWLXMLDocumentFormat", "owlxml.renderer.OWLXMLStorerFactory", "owlxml.parser.OWLXMLParserFactory"),
        MANCHESTERSYNTAX("ManchesterSyntaxDocumentFormat", "manchestersyntax.renderer.ManchesterSyntaxStorerFactory", "manchestersyntax.parser.ManchesterOWLSyntaxOntologyParserFactory"),
        FUNCTIONALSYNTAX("FunctionalSyntaxDocumentFormat", "functional.renderer.FunctionalSyntaxStorerFactory", "functional.parser.OWLFunctionalSyntaxOWLParserFactory"),
        DLSYNTAX("DLSyntaxDocumentFormat", "dlsyntax.renderer.DLSyntaxStorerFactory", "dlsyntax.parser.DLSyntaxOWLParserFactory"),
        TURTLE("TurtleDocumentFormat", "rdf.turtle.renderer.TurtleStorerFactory", "rdf.turtle.parser.TurtleOntologyParserFactory"),
        LATEX("LatexDocumentFormat", "latex.renderer.LatexStorerFactory", null),
        OBO("OBODocumentFormat", "oboformat.OBOFormatStorerFactory", "oboformat.OBOFormatOWLAPIParserFactory"),
        KRSS2("KRSS2DocumentFormat", "krss2.renderer.KRSS2OWLSyntaxStorerFactory", "krss2.parser.KRSS2OWLParserFactory"),
        KRSS("KRSSDocumentFormat", "krss2.renderer.KRSSSyntaxStorerFactory", "krss1.parser.KRSSOWLParserFactory"){

            @Override
            public boolean enabled() {
                return false;
            }
        }
        ,
        RDFA("RDFaDocumentFormat", null, "rio.RioRDFaParserFactory");

        private static final String OWL_API_PACKAGE_NAME = "org.semanticweb.owlapi";
        private static final String OWL_API_FORMATS_PACKAGE_NAME = "org.semanticweb.owlapi.formats";
        private final String format;
        private final String storer;
        private final String parser;

        private LangKey(String format, String storer, String parser) {
            this.format = format;
            this.storer = storer;
            this.parser = parser;
        }

        public static Map<String, OWLLang> asMap() {
            LinkedHashMap<String, OWLLang> res = new LinkedHashMap<String, OWLLang>();
            Arrays.stream(LangKey.values()).forEach(key -> res.put(key.getKey(), key.createLang()));
            return res;
        }

        public String getKey() {
            return "org.semanticweb.owlapi.formats." + this.format;
        }

        protected Class<? extends OWLDocumentFormat> getType() throws LangException {
            Class res = OWLLangRegistry.findClass(OWLDocumentFormat.class, this.getKey());
            if (res == null) {
                throw new LangException(this.getKey() + " not found in system.");
            }
            return res;
        }

        public String getStorerClassName() {
            return "org.semanticweb.owlapi." + this.storer;
        }

        public String getParserClassName() {
            return "org.semanticweb.owlapi." + this.parser;
        }

        public boolean enabled() {
            return true;
        }

        protected Supplier<OWLDocumentFormat> getDefaultFormatFactory() {
            return null;
        }

        private OWLLang createLang() throws LangException {
            if (!this.enabled()) {
                return null;
            }
            Class type = OWLLangRegistry.findClass(OWLDocumentFormat.class, this.getKey());
            if (type == null) {
                return null;
            }
            Class storerType = OWLLangRegistry.findClass(OWLStorerFactory.class, this.getStorerClassName());
            Class parserType = OWLLangRegistry.findClass(OWLParserFactory.class, this.getParserClassName());
            if (storerType == null && parserType == null) {
                return new OWLLang(type, null, null, () -> (OWLDocumentFormat)OWLLangRegistry.newInstance(type));
            }
            OWLLang res = OWLLangRegistry.create(storerType, parserType, (Supplier<OWLDocumentFormat>)this.getDefaultFormatFactory());
            if (!type.equals(res.getType())) {
                throw new LangException("Wrong format. Expected:" + type + ". Actual: " + res.getType() + ".");
            }
            return res;
        }
    }
}

