/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyFactoryImpl;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;

public class OWLLoaderImpl
implements OntologyFactory.Loader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLLoaderImpl.class);
    protected final OWLOntologyFactory factory;
    protected Set<IRI> sources = new HashSet<IRI>();

    public OWLLoaderImpl(OntologyFactory.Builder builder) {
        this(new FactoryImpl(Objects.requireNonNull(builder, "Null ONT Builder specified.")));
    }

    protected OWLLoaderImpl(OWLOntologyFactory factory) {
        this.factory = OntApiException.notNull(factory, "Null OWL Ontology Factory impl.");
    }

    @Override
    public OntologyModel load(OWLOntologyDocumentSource source, OntologyManager manager, OntLoaderConfiguration conf) throws OWLOntologyCreationException {
        IRI doc = source.getDocumentIRI();
        if (this.sources.contains(doc)) {
            throw new OntologyFactoryImpl.BadRecursionException("Cycle loading for source " + doc);
        }
        this.sources.add(doc);
        OntologyModel res = (OntologyModel)this.factory.loadOWLOntology((OWLOntologyManager)manager, source, (OWLOntologyFactory.OWLOntologyCreationHandler)manager, (OWLOntologyLoaderConfiguration)conf);
        this.sources.clear();
        if (LOGGER.isDebugEnabled()) {
            OntFormat format = OntFormat.get(manager.getOntologyFormat(res));
            LOGGER.debug("The ontology <{}> is loaded. Format: {}[{}]", new Object[]{res.getOntologyID(), format, source.getClass().getSimpleName()});
        }
        res.clearCache();
        return res;
    }

    public static class AcceptHeaderBuilder {
        public static String headersFromParsers(Iterable<OWLParserFactory> parsers) {
            HashMap map = new HashMap();
            parsers.forEach(p -> AcceptHeaderBuilder.addToMap(map, p.getMIMETypes()));
            return map.entrySet().stream().sorted(AcceptHeaderBuilder::compare).map(AcceptHeaderBuilder::asString).collect(Collectors.joining(", "));
        }

        private static void addToMap(Map<String, TreeSet<Integer>> map, List<String> mimes) {
            for (int i = 0; i < mimes.size(); ++i) {
                map.computeIfAbsent(mimes.get(i), k -> new TreeSet()).add(i + 1);
            }
        }

        private static String asString(Map.Entry<String, TreeSet<Integer>> e) {
            return String.format("%s; q=%.1f", e.getKey(), 1.0 / (double)e.getValue().first().intValue());
        }

        private static int compare(Map.Entry<String, TreeSet<Integer>> a, Map.Entry<String, TreeSet<Integer>> b) {
            return a.getValue().first().compareTo(b.getValue().first());
        }
    }

    public static class FactoryImpl
    implements OWLOntologyFactory {
        private final OWLOntologyBuilder builder;

        public FactoryImpl(OWLOntologyBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
        }

        public boolean canCreateFromDocumentIRI(IRI documentIRI) {
            return true;
        }

        public boolean canAttemptLoading(OWLOntologyDocumentSource source) {
            return !source.hasAlredyFailedOnStreams() || !source.hasAlredyFailedOnIRIResolution() && OntConfig.DefaultScheme.all().anyMatch(s -> s.same(source.getDocumentIRI()));
        }

        public OWLOntology createOWLOntology(OWLOntologyManager manager, OWLOntologyID ontologyID, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) {
            OWLOntology ont = this.builder.createOWLOntology(manager, ontologyID);
            handler.ontologyCreated(ont);
            handler.setOntologyFormat(ont, (OWLDocumentFormat)new RDFXMLDocumentFormat());
            return ont;
        }

        public OWLOntology loadOWLOntology(OWLOntologyManager manager, OWLOntologyDocumentSource source, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration config) throws OWLOntologyCreationException {
            LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
            OWLOntology existingOntology = null;
            IRI iri = source.getDocumentIRI();
            if (manager.contains(iri)) {
                existingOntology = manager.getOntology(iri);
            }
            OWLOntologyID id = new OWLOntologyID();
            OWLOntology ont = this.createOWLOntology(manager, id, source.getDocumentIRI(), handler);
            Set bannedParsers = Arrays.stream(config.getBannedParsers().split(" ")).collect(Collectors.toSet());
            Iterable<OWLParserFactory> parsers = FactoryImpl.select(source, (PriorityCollection<OWLParserFactory>)manager.getOntologyParsers());
            if (source.getAcceptHeaders().isPresent()) {
                source.setAcceptHeaders(AcceptHeaderBuilder.headersFromParsers(parsers));
            }
            for (OWLParserFactory parserFactory : parsers) {
                if (bannedParsers.contains(parserFactory.getClass().getName())) continue;
                OWLParser parser = parserFactory.createParser();
                try {
                    if (existingOntology == null && !ont.isEmpty()) {
                        manager.removeOntology(ont);
                        ont = this.createOWLOntology(manager, id, source.getDocumentIRI(), handler);
                    }
                    OWLDocumentFormat format = parser.parse(source, ont, config);
                    handler.setOntologyFormat(ont, format);
                    return ont;
                }
                catch (UnloadableImportException e) {
                    manager.removeOntology(ont);
                    throw e;
                }
                catch (OWLParserException e) {
                    if (e.getCause() instanceof IOException || e.getCause() instanceof OWLOntologyInputSourceException) {
                        manager.removeOntology(ont);
                        throw new OWLOntologyCreationIOException(e.getCause());
                    }
                    exceptions.put(parser, e);
                }
                catch (RuntimeException e) {
                    exceptions.put(parser, new OWLParserException((Throwable)e));
                    manager.removeOntology(ont);
                    throw e;
                }
            }
            if (existingOntology == null) {
                manager.removeOntology(ont);
            }
            throw new UnparsableOntologyException(source.getDocumentIRI(), exceptions, config);
        }

        public static Iterable<OWLParserFactory> select(OWLOntologyDocumentSource source, PriorityCollection<OWLParserFactory> parsers) {
            if (parsers.isEmpty()) {
                return parsers;
            }
            Optional format = source.getFormat();
            Optional mimeType = source.getMIMEType();
            if (!format.isPresent() && !mimeType.isPresent()) {
                return parsers;
            }
            PriorityCollection res = parsers;
            if (format.isPresent()) {
                res = new PriorityCollection(PriorityCollectionSorting.NEVER);
                for (OWLParserFactory p : parsers) {
                    if (!format.map(OWLDocumentFormat::getKey).filter(s -> s.equals(p.getSupportedFormat().getKey())).isPresent()) continue;
                    res.add((Serializable)p);
                }
            }
            if (mimeType.isPresent() && res.isEmpty()) {
                res = parsers.getByMIMEType((String)mimeType.get());
            }
            if (res.isEmpty()) {
                return parsers;
            }
            return res;
        }
    }
}

