/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jena.graph.Graph;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import ru.avicomp.ontapi.InternalModelHolder;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.OwlObjects;
import ru.avicomp.ontapi.internal.InternalModel;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntID;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.owlapi.OWLObjectImpl;

public abstract class OntBaseModelImpl
implements OWLOntology,
InternalModelHolder {
    protected static final OntFormat DEFAULT_SERIALIZATION_FORMAT = OntFormat.RDF_THRIFT;
    private static final long serialVersionUID = 7605836729147058594L;
    protected transient InternalModel base;
    protected transient OntologyManagerImpl managerBackCopy;
    protected OWLOntologyID ontologyID;
    protected int hashCode;

    protected OntBaseModelImpl(Graph graph, OntologyManagerImpl.ModelConfig conf) {
        this.base = InternalModelHolder.createInternalModel(graph, conf);
    }

    @Override
    public InternalModel getBase() {
        return this.base;
    }

    @Override
    public void setBase(InternalModel m) {
        this.base = Objects.requireNonNull(m);
    }

    public OntologyManagerImpl.ModelConfig getConfig() {
        return (OntologyManagerImpl.ModelConfig)this.base.getConfig();
    }

    public OntologyManager getOWLOntologyManager() {
        return this.getConfig().getManager();
    }

    public void setOWLOntologyManager(OWLOntologyManager manager) {
        OntologyManagerImpl m;
        if (Objects.equals(this.getOWLOntologyManager(), manager)) {
            return;
        }
        try {
            m = (OntologyManagerImpl)manager;
        }
        catch (ClassCastException ce) {
            if (this.managerBackCopy != null) {
                this.managerBackCopy.rollBackMoving(this, manager);
                this.getConfig().setManager(this.managerBackCopy);
                this.managerBackCopy = null;
            }
            throw new OntApiException("Trying to move? Don't do it!", ce);
        }
        this.managerBackCopy = this.getConfig().setManager(m);
    }

    public OWLOntologyID getOntologyID() {
        OntID id = this.base.getID();
        if (id.isAnon()) {
            return this.ontologyID == null || !this.ontologyID.isAnonymous() ? this.assignID(new OWLOntologyID()) : this.ontologyID;
        }
        Optional<IRI> iri = Optional.of(id.getURI()).map(IRI::create);
        Optional<IRI> version = Optional.ofNullable(id.getVersionIRI()).map(IRI::create);
        return this.assignID(new OWLOntologyID(iri, version));
    }

    protected void setOntologyID(OWLOntologyID id) {
        try {
            if (id.isAnonymous()) {
                this.base.setID(null).setVersionIRI(null);
                return;
            }
            this.base.setID(id.getOntologyIRI().map(IRI::getIRIString).orElse(null)).setVersionIRI(id.getVersionIRI().map(IRI::getIRIString).orElse(null));
        }
        finally {
            this.assignID(id);
        }
    }

    protected OWLOntologyID assignID(OWLOntologyID id) {
        this.ontologyID = id;
        this.hashCode = 0;
        return id;
    }

    public boolean isAnonymous() {
        return this.base.getID().isAnon();
    }

    public boolean isEmpty() {
        return this.base.isOntologyEmpty();
    }

    public Stream<OWLAnnotation> annotations() {
        return this.base.listOWLAnnotations();
    }

    public Stream<OWLOntology> imports() {
        return this.getOWLOntologyManager().imports(this);
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.base.listOWLImportDeclarations();
    }

    public Stream<IRI> directImportsDocuments() {
        return this.importsDeclarations().map(OWLImportsDeclaration::getIRI);
    }

    public Stream<OWLOntology> directImports() {
        return this.getOWLOntologyManager().directImports(this);
    }

    public Stream<OWLOntology> importsClosure() {
        return this.getOWLOntologyManager().importsClosure(this);
    }

    public Stream<OWLClass> classesInSignature() {
        return this.base.listOWLClasses();
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return ((Collection)this.accept((OWLObjectVisitorEx)new OWLClassExpressionCollector())).stream();
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.base.listOWLAnonymousIndividuals();
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.anonymousIndividuals();
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.base.listOWLNamedIndividuals();
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.base.listOWLDataProperties();
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.base.listOWLObjectProperties();
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.base.listOWLAnnotationProperties();
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.base.listOWLDatatypes();
    }

    public Stream<OWLEntity> signature() {
        return Stream.of(this.classesInSignature(), this.objectPropertiesInSignature(), this.dataPropertiesInSignature(), this.individualsInSignature(), this.datatypesInSignature(), this.annotationPropertiesInSignature()).flatMap(Function.identity());
    }

    public boolean containsEntityInSignature(OWLEntity entity) {
        return this.signature().anyMatch(o -> Objects.equals(o, entity));
    }

    public Stream<OWLEntity> entitiesInSignature(@Nullable IRI entityIRI) {
        return this.base.listOWLEntities(entityIRI);
    }

    public Set<IRI> getPunnedIRIs(@Nonnull Imports imports) {
        return this.base.ambiguousEntities(Imports.INCLUDED.equals((Object)imports)).map(Resource::getURI).map(IRI::create).collect(Collectors.toSet());
    }

    public boolean isDeclared(@Nullable OWLEntity owlEntity) {
        return this.base.listOWLAxioms(OWLDeclarationAxiom.class).map(OWLDeclarationAxiom::getEntity).anyMatch(obj -> obj.equals(owlEntity));
    }

    public boolean containsReference(@Nonnull OWLEntity entity) {
        return this.signature().anyMatch(entity::equals);
    }

    public boolean containsClassInSignature(@Nonnull IRI iri) {
        return this.classesInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsClassInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri) {
        return this.objectPropertiesInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(@Nonnull IRI iri) {
        return this.dataPropertiesInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsDataPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri) {
        return this.annotationPropertiesInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsDatatypeInSignature(@Nonnull IRI iri) {
        return this.datatypesInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsDatatypeInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDatatypeInSignature(iri));
    }

    public boolean containsIndividualInSignature(@Nonnull IRI iri) {
        return this.individualsInSignature().map(HasIRI::getIRI).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
    }

    public boolean containsIndividualInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsIndividualInSignature(iri));
    }

    public Stream<OWLAxiom> axioms() {
        return this.base.listOWLAxioms();
    }

    public <T extends OWLAxiom> Stream<T> axioms(@Nonnull AxiomType<T> axiomType) {
        return this.base.listOWLAxioms(axiomType);
    }

    public Stream<OWLClassAxiom> classAxioms() {
        return Stream.of(OWLDisjointClassesAxiom.class, OWLDisjointUnionAxiom.class, OWLEquivalentClassesAxiom.class, OWLSubClassOfAxiom.class).flatMap(c -> this.base.listOWLAxioms(c));
    }

    public Stream<OWLObjectPropertyAxiom> objectPropertyAxioms() {
        return Stream.of(OWLSubObjectPropertyOfAxiom.class, OWLObjectPropertyDomainAxiom.class, OWLObjectPropertyRangeAxiom.class, OWLDisjointObjectPropertiesAxiom.class, OWLSubPropertyChainOfAxiom.class, OWLEquivalentObjectPropertiesAxiom.class, OWLInverseObjectPropertiesAxiom.class, OWLTransitiveObjectPropertyAxiom.class, OWLIrreflexiveObjectPropertyAxiom.class, OWLReflexiveObjectPropertyAxiom.class, OWLSymmetricObjectPropertyAxiom.class, OWLFunctionalObjectPropertyAxiom.class, OWLInverseFunctionalObjectPropertyAxiom.class, OWLAsymmetricObjectPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c));
    }

    public Stream<OWLDataPropertyAxiom> dataPropertyAxioms() {
        return Stream.of(OWLDataPropertyDomainAxiom.class, OWLDataPropertyRangeAxiom.class, OWLDisjointDataPropertiesAxiom.class, OWLSubDataPropertyOfAxiom.class, OWLEquivalentDataPropertiesAxiom.class, OWLFunctionalDataPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c));
    }

    public Stream<OWLIndividualAxiom> individualAxioms() {
        return Stream.of(OWLClassAssertionAxiom.class, OWLObjectPropertyAssertionAxiom.class, OWLDataPropertyAssertionAxiom.class, OWLNegativeObjectPropertyAssertionAxiom.class, OWLNegativeDataPropertyAssertionAxiom.class, OWLSameIndividualAxiom.class, OWLDifferentIndividualsAxiom.class).flatMap(c -> this.base.listOWLAxioms(c));
    }

    public Stream<OWLNaryAxiom> naryAxioms() {
        return Stream.of(OWLEquivalentClassesAxiom.class, OWLEquivalentDataPropertiesAxiom.class, OWLEquivalentObjectPropertiesAxiom.class, OWLSameIndividualAxiom.class, OWLDisjointClassesAxiom.class, OWLDisjointDataPropertiesAxiom.class, OWLDisjointObjectPropertiesAxiom.class, OWLDifferentIndividualsAxiom.class).flatMap(c -> this.base.listOWLAxioms(c));
    }

    public Stream<OWLClassAxiom> axioms(@Nonnull OWLClass clazz) {
        Stream<OWLSubClassOfAxiom> subClassOf = this.base.listOWLSubClassOfAxioms(clazz);
        Stream<OWLDisjointUnionAxiom> disjointUnion = this.base.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(a -> Objects.equals(a.getOWLClass(), clazz));
        Stream<OWLDisjointClassesAxiom> disjoint = this.base.listOWLAxioms(OWLDisjointClassesAxiom.class).filter(a -> a.operands().anyMatch(clazz::equals));
        Stream<OWLEquivalentClassesAxiom> equivalent = this.base.listOWLEquivalentClassesAxioms(clazz);
        return Stream.of(subClassOf, disjointUnion, disjoint, equivalent).flatMap(Function.identity());
    }

    public Stream<OWLObjectPropertyAxiom> axioms(@Nonnull OWLObjectPropertyExpression property) {
        Stream<OWLSubObjectPropertyOfAxiom> subPropertyOf = this.base.listOWLAxioms(OWLSubObjectPropertyOfAxiom.class).filter(a -> Objects.equals(a.getSubProperty(), property));
        Stream<OWLObjectPropertyAxiom> nary = Stream.of(OWLEquivalentObjectPropertiesAxiom.class, OWLDisjointObjectPropertiesAxiom.class, OWLInverseObjectPropertiesAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$17(OWLNaryPropertyAxiom.class, arg_0)).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, property))).map(OWLObjectPropertyAxiom.class::cast);
        Stream<OWLObjectPropertyAxiom> unary = Stream.of(OWLObjectPropertyDomainAxiom.class, OWLObjectPropertyRangeAxiom.class, OWLTransitiveObjectPropertyAxiom.class, OWLIrreflexiveObjectPropertyAxiom.class, OWLReflexiveObjectPropertyAxiom.class, OWLSymmetricObjectPropertyAxiom.class, OWLFunctionalObjectPropertyAxiom.class, OWLInverseFunctionalObjectPropertyAxiom.class, OWLAsymmetricObjectPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$21(OWLUnaryPropertyAxiom.class, arg_0)).filter(a -> Objects.equals(a.getProperty(), property)).map(OWLObjectPropertyAxiom.class::cast);
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLDataPropertyAxiom> axioms(@Nonnull OWLDataProperty property) {
        Stream<OWLSubDataPropertyOfAxiom> subPropertyOf = this.base.listOWLAxioms(OWLSubDataPropertyOfAxiom.class).filter(a -> Objects.equals(a.getSubProperty(), property));
        Stream<OWLDataPropertyAxiom> nary = Stream.of(OWLEquivalentDataPropertiesAxiom.class, OWLDisjointDataPropertiesAxiom.class, OWLInverseObjectPropertiesAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLNaryPropertyAxiom.class::cast).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, property))).map(OWLDataPropertyAxiom.class::cast);
        Stream<OWLDataPropertyAxiom> unary = Stream.of(OWLDataPropertyDomainAxiom.class, OWLDataPropertyRangeAxiom.class, OWLFunctionalDataPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$28(OWLUnaryPropertyAxiom.class, arg_0)).filter(a -> Objects.equals(a.getProperty(), property)).map(OWLDataPropertyAxiom.class::cast);
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLIndividualAxiom> axioms(@Nonnull OWLIndividual individual) {
        Stream<OWLClassAssertionAxiom> classAssertion = this.base.listOWLAxioms(OWLClassAssertionAxiom.class).filter(a -> Objects.equals(a.getIndividual(), individual));
        Stream<OWLNaryIndividualAxiom> nary = Stream.of(OWLSameIndividualAxiom.class, OWLDifferentIndividualsAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLNaryIndividualAxiom.class::cast).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, individual)));
        Stream<OWLPropertyAssertionAxiom> propertyAssertion = Stream.of(OWLObjectPropertyAssertionAxiom.class, OWLDataPropertyAssertionAxiom.class, OWLNegativeObjectPropertyAssertionAxiom.class, OWLNegativeDataPropertyAssertionAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLPropertyAssertionAxiom.class::cast).filter(a -> Objects.equals(a.getSubject(), individual));
        return Stream.of(classAssertion, nary, propertyAssertion).flatMap(Function.identity());
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(@Nonnull OWLDatatype datatype) {
        return this.base.listOWLAxioms(OWLDatatypeDefinitionAxiom.class).filter(a -> datatype.equals(a.getDatatype()));
    }

    public <T extends OWLAxiom> Stream<T> axioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key) {
        return this.base.listOWLAxioms(StreamSupport.stream(filter.getAxiomTypes().spliterator(), false).map(type -> type).collect(Collectors.toSet())).filter(a -> filter.pass(a, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axioms(filter, key));
    }

    public <A extends OWLAxiom> Stream<A> axioms(@Nonnull Class<A> type, @Nullable Class<? extends OWLObject> view, @Nonnull OWLObject object, @Nullable Navigation position) {
        if (OWLDeclarationAxiom.class.equals(type) && object instanceof OWLEntity && Navigation.IN_SUB_POSITION.equals((Object)position)) {
            return this.base.listOWLDeclarationAxioms((OWLEntity)object);
        }
        if (OWLSubObjectPropertyOfAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubObjectPropertyOfAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getSuperProperty() : a.getSubProperty()));
        }
        if (OWLSubDataPropertyOfAxiom.class.equals(type) && object instanceof OWLDataPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubDataPropertyOfAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getSuperProperty() : a.getSubProperty()));
        }
        if (OWLSubAnnotationPropertyOfAxiom.class.equals(type) && object instanceof OWLAnnotationProperty) {
            return this.base.listOWLAxioms(OWLSubAnnotationPropertyOfAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getSuperProperty() : a.getSubProperty()));
        }
        if (OWLSubClassOfAxiom.class.equals(type) && object instanceof OWLClassExpression) {
            OWLClassExpression c = (OWLClassExpression)object;
            if (c.isOWLClass() && Navigation.IN_SUB_POSITION.equals((Object)position)) {
                return this.base.listOWLSubClassOfAxioms(c.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> c.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getSuperClass() : a.getSubClass()));
        }
        if (OWLEquivalentClassesAxiom.class.equals(type) && Navigation.IN_SUB_POSITION.equals((Object)position) && object instanceof OWLClassExpression) {
            OWLClassExpression c = (OWLClassExpression)object;
            if (c.isOWLClass()) {
                return this.base.listOWLEquivalentClassesAxioms(c.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLEquivalentClassesAxiom.class).filter(a -> a.contains(c));
        }
        if (OWLInverseObjectPropertiesAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLInverseObjectPropertiesAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getSecondProperty() : a.getFirstProperty()));
        }
        if (OWLObjectPropertyAssertionAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.base.listOWLAxioms(OWLObjectPropertyAssertionAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getObject() : a.getSubject()));
        }
        if (OWLNegativeObjectPropertyAssertionAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.base.listOWLAxioms(OWLNegativeObjectPropertyAssertionAxiom.class).filter(a -> object.equals(Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getObject() : a.getSubject()));
        }
        if (OWLAnnotationAssertionAxiom.class.equals(type)) {
            if (Navigation.IN_SUPER_POSITION.equals((Object)position) && object instanceof OWLAnnotationObject) {
                return this.base.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> object.equals(a.getValue()));
            }
            if (Navigation.IN_SUB_POSITION.equals((Object)position) && object instanceof OWLAnnotationSubject) {
                return this.base.listOWLAnnotationAssertionAxioms((OWLAnnotationSubject)object);
            }
        }
        if (OWLDisjointUnionAxiom.class.equals(type) && object instanceof OWLClassExpression) {
            return this.base.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(a -> Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.classExpressions().anyMatch(object::equals) : object.equals(a.getOWLClass()));
        }
        if (OWLSubPropertyChainOfAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubPropertyChainOfAxiom.class).filter(a -> Navigation.IN_SUPER_POSITION.equals((Object)position) ? a.getPropertyChain().stream().anyMatch(object::equals) : object.equals(a.getSuperProperty()));
        }
        if (OWLClassAxiom.class.equals(type) && object instanceof OWLClass) {
            return this.axioms((OWLClass)object);
        }
        if (OWLObjectPropertyAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.axioms((OWLObjectPropertyExpression)object);
        }
        if (OWLDataPropertyAxiom.class.equals(type) && object instanceof OWLDataProperty) {
            return this.axioms((OWLDataProperty)object);
        }
        if (OWLIndividualAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.axioms((OWLIndividual)object);
        }
        if (OWLNaryAxiom.class.isAssignableFrom(type)) {
            return this.base.listOWLAxioms(type).filter(a -> ((OWLNaryAxiom)a).operands().anyMatch(o -> Objects.equals(o, object)));
        }
        return this.base.listOWLAxioms(type).filter(a -> OwlObjects.objects(object.getClass(), a).anyMatch(object::equals));
    }

    public Stream<OWLAxiom> tboxAxioms(@Nonnull Imports imports) {
        return AxiomType.TBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> aboxAxioms(@Nonnull Imports imports) {
        return AxiomType.ABoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> rboxAxioms(@Nonnull Imports imports) {
        return AxiomType.RBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.base.listOWLAxioms(InternalModel.AXIOM_TYPES.stream().filter(AxiomType::isLogical).collect(Collectors.toList())).map(OWLLogicalAxiom.class::cast);
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        Stream<OWLSubClassOfAxiom> subClassOfAxioms = this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> a.getSubClass().isAnonymous());
        Stream<OWLNaryClassAxiom> naryClassAxioms = Stream.of(OWLEquivalentClassesAxiom.class, OWLDisjointClassesAxiom.class).flatMap(this.base::listOWLAxioms).filter(a -> a.classExpressions().allMatch(IsAnonymous::isAnonymous));
        return Stream.concat(subClassOfAxioms, naryClassAxioms);
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        return this.axioms(axiom.getAxiomType()).map(OWLAxiom.class::cast).filter(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axiomsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> referencingAxioms(@Nonnull OWLPrimitive primitive) {
        if (primitive instanceof IRI) {
            return this.axioms().filter(a -> OwlObjects.iris(a).anyMatch(primitive::equals));
        }
        if (primitive instanceof OWLDatatype) {
            return this.axioms().filter(a -> OwlObjects.objects(OWLDatatype.class, a).anyMatch(primitive::equals));
        }
        return this.axioms().filter(a -> OwlObjects.objects(OWLPrimitive.class, a).anyMatch(primitive::equals));
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(@Nonnull OWLAnnotationProperty property) {
        return this.axioms(Filters.subAnnotationWithSub, property);
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(@Nonnull OWLAnnotationProperty property) {
        return this.axioms(Filters.apDomainFilter, property);
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(@Nonnull OWLAnnotationProperty property) {
        return this.axioms(Filters.apRangeFilter, property);
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(@Nonnull OWLDatatype datatype) {
        return this.axioms(Filters.datatypeDefFilter, datatype);
    }

    public int getAxiomCount() {
        return (int)this.axioms().count();
    }

    public int getAxiomCount(@Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getAxiomCount).sum();
    }

    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType) {
        return (int)this.axioms(axiomType).count();
    }

    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(o -> o.getAxiomCount(axiomType)).sum();
    }

    public int getLogicalAxiomCount() {
        return (int)this.logicalAxioms().count();
    }

    public int getLogicalAxiomCount(@Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getLogicalAxiomCount).sum();
    }

    public boolean containsAxiom(@Nonnull OWLAxiom axiom) {
        return this.base.contains(axiom);
    }

    public boolean containsAxiom(@Nonnull OWLAxiom axiom, @Nonnull Imports imports, @Nonnull AxiomAnnotations ignoreAnnotations) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> ignoreAnnotations.contains(o, axiom));
    }

    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        return this.containsAxiom(axiom) || this.axioms(axiom.getAxiomType()).anyMatch(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public boolean contains(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key) {
        return this.base.listOWLAxioms(StreamSupport.stream(filter.getAxiomTypes().spliterator(), false).map(type -> type).collect(Collectors.toList())).anyMatch(a -> filter.pass(a, key));
    }

    public boolean contains(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, @Nonnull Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.contains(filter, key));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        GraphMem base = new GraphMem();
        RDFDataMgr.read((Graph)base, (InputStream)in, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
        this.setBase(InternalModelHolder.createInternalModel((Graph)base));
    }

    private void writeObject(ObjectOutputStream out) throws IOException, OntApiException {
        Graph g = Graphs.getBase(this.base.getBaseGraph());
        if (!(g instanceof GraphMem)) {
            throw new OntApiException(this.ontologyID + ":: Serialization is not supported for non-memory graphs.");
        }
        out.defaultWriteObject();
        RDFDataMgr.write((OutputStream)out, (Graph)g, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
    }

    public String toString() {
        return String.format("Ontology(%s)", this.ontologyID);
    }

    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = this.initHashCode()) : this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        return OWLObjectImpl.DEFAULT_COMPARATOR.compare((OWLObject)this, Objects.requireNonNull(o));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OntologyModel)) {
            return false;
        }
        OntGraphModel right = ((OntologyModel)obj).asGraphModel();
        InternalModel left = this.getBase();
        return left.getID().sameAs(right.getID());
    }

    private static /* synthetic */ OWLUnaryPropertyAxiom lambda$axioms$28(Class rec$, Object x$0) {
        return (OWLUnaryPropertyAxiom)rec$.cast(x$0);
    }

    private static /* synthetic */ OWLUnaryPropertyAxiom lambda$axioms$21(Class rec$, Object x$0) {
        return (OWLUnaryPropertyAxiom)rec$.cast(x$0);
    }

    private static /* synthetic */ OWLNaryPropertyAxiom lambda$axioms$17(Class rec$, Object x$0) {
        return (OWLNaryPropertyAxiom)rec$.cast(x$0);
    }
}

