/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.PrefixManager;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.jena.utils.Graphs;

public abstract class OntGraphDocumentSource
implements OWLOntologyDocumentSource {
    protected AtomicReference<IOException> exception = new AtomicReference();

    public abstract Graph getGraph();

    public IRI getDocumentIRI() {
        return OntGraphDocumentSource.identifier().apply(this.getGraph());
    }

    public static Function<Graph, IRI> identifier() {
        return g -> IRI.create((String)("graph:" + g.getClass().getName() + "@" + Integer.toHexString(g.hashCode())));
    }

    public Optional<Reader> getReader() {
        return this.getInputStream().map(is -> new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
    }

    public Optional<InputStream> getInputStream() {
        return this.format().map(OntFormat::getLang).map(lang -> OntGraphDocumentSource.toInputStream(this.getGraph(), lang, this.exception));
    }

    public static InputStream toInputStream(final Graph graph, final Lang lang, final AtomicReference<IOException> holder) {
        PipedInputStream in = new PipedInputStream();
        FilterInputStream res = new FilterInputStream(in){
            private volatile boolean closed;

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    IOException e = (IOException)holder.get();
                    if (e != null) {
                        throw new IOException(String.format("Convert output->input. Graph: %s, %s.", Graphs.getName(graph), lang), e);
                    }
                }
                finally {
                    super.close();
                    this.closed = true;
                }
            }
        };
        CountDownLatch complete = new CountDownLatch(1);
        new Thread(() -> {
            try (PipedOutputStream out = new PipedOutputStream(in);){
                complete.countDown();
                RDFDataMgr.write((OutputStream)out, (Graph)graph, (Lang)lang);
            }
            catch (IOException e) {
                holder.set(e);
            }
        }).start();
        try {
            complete.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return res;
    }

    public Optional<OWLDocumentFormat> getFormat() {
        PrefixMapping pm = this.getGraph().getPrefixMapping();
        return this.format().map(OntFormat::createOwlFormat).map(f -> {
            if (f.isPrefixOWLDocumentFormat()) {
                PrefixDocumentFormat res = f.asPrefixOWLDocumentFormat();
                pm.getNsPrefixMap().forEach((arg_0, arg_1) -> ((PrefixManager)res).setPrefix(arg_0, arg_1));
            }
            return f;
        });
    }

    public OntFormat getOntFormat() {
        return OntFormat.TURTLE;
    }

    private Optional<OntFormat> format() {
        return Optional.of(this.getOntFormat());
    }

    public Optional<String> getMIMEType() {
        return this.format().map(OntFormat::getLang).map(Lang::getContentType).map(ContentType::getContentType);
    }

    public boolean hasAlredyFailedOnStreams() {
        return this.exception.get() != null;
    }

    public boolean hasAlredyFailedOnIRIResolution() {
        return false;
    }

    public void setIRIResolutionFailed(boolean value) {
        throw new OntApiException.Unsupported("#setIRIResolutionFailed is not supported.");
    }

    public static OntGraphDocumentSource wrap(final Graph graph) {
        Objects.requireNonNull(graph, "Null graph");
        return new OntGraphDocumentSource(){

            @Override
            public Graph getGraph() {
                return graph;
            }
        };
    }
}

