/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntologyFactoryImpl;
import ru.avicomp.ontapi.OntologyMetaData;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.jena.impl.OntIDImpl;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.transforms.GraphTransformers;

public class OntGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntGraphModel.class);
    public static final String TEXT_PLAIN_REQUEST_TYPE = ", text/plain; q=0.1";
    public static final String LAST_REQUEST_TYPE = ", */*; q=0.09";
    public static final String DEFAULT_REQUEST = "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09";

    public static OWLOntologyID getOntologyID(@Nonnull Graph graph) throws OntApiException {
        Graph base = Graphs.getBase(graph);
        Optional<Node> node = Graphs.ontologyNode(base);
        if (!node.isPresent()) {
            return new OWLOntologyID();
        }
        OntIDImpl id = new OntIDImpl(node.get(), (EnhGraph)new ModelCom(base));
        Optional<IRI> iri = Optional.ofNullable(id.getURI()).map(IRI::create);
        Optional<IRI> ver = Optional.ofNullable(id.getVersionIRI()).map(IRI::create);
        if (!iri.isPresent() && ver.isPresent()) {
            throw new OntApiException("Anonymous graph with version iri");
        }
        return new OWLOntologyID(iri, ver);
    }

    public static Map<OWLOntologyID, Graph> toGraphMap(@Nonnull Graph graph) throws OntApiException {
        Graph base = Graphs.getBase(graph);
        return Graphs.flat(graph).collect(Collectors.toMap(g -> {
            OWLOntologyID id = OntGraphUtils.getOntologyID(g);
            if (id.isAnonymous() && base != g) {
                throw new OntApiException("Anonymous sub graph found: " + id + ". Only top-level graph is allowed to be anonymous");
            }
            return id;
        }, Function.identity(), (a, b) -> {
            if (a.isIsomorphicWith(b)) {
                return a;
            }
            throw new OntApiException("Duplicate sub graphs " + Graphs.getName(a));
        }, LinkedHashMap::new));
    }

    public static RDFTriple triple(Triple triple) {
        Object subject = triple.getSubject().isURI() ? OntGraphUtils.uri(triple.getSubject()) : OntGraphUtils.blank(triple.getSubject());
        RDFResourceIRI predicate = OntGraphUtils.uri(triple.getPredicate());
        Object object = triple.getObject().isURI() ? OntGraphUtils.uri(triple.getObject()) : (triple.getObject().isLiteral() ? OntGraphUtils.literal(triple.getObject()) : OntGraphUtils.blank(triple.getObject()));
        return new RDFTriple((RDFResource)subject, predicate, (RDFNode)object);
    }

    public static RDFResourceBlankNode blank(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isBlank()) {
            throw new IllegalArgumentException("Not a blank node: " + node);
        }
        return new RDFResourceBlankNode(IRI.create((String)node.getBlankNodeId().getLabelString()), false, false, false);
    }

    public static RDFResourceIRI uri(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isURI()) {
            throw new IllegalArgumentException("Not an uri node: " + node);
        }
        return new RDFResourceIRI(IRI.create((String)node.getURI()));
    }

    public static RDFLiteral literal(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isLiteral()) {
            throw new IllegalArgumentException("Not a literal node: " + node);
        }
        return new RDFLiteral(node.getLiteralLexicalForm(), node.getLiteralLanguage(), IRI.create((String)node.getLiteralDatatypeURI()));
    }

    protected static OWLOntologyLoaderMetaData makeParserMetaData(Graph graph, GraphTransformers.Stats stats) {
        if (stats == null) {
            return OntologyMetaData.createParserMetaData(graph);
        }
        if (Graphs.getBase(graph) != stats.getGraph()) {
            throw new IllegalArgumentException("Incompatible graphs: " + Graphs.getName(graph) + " != " + Graphs.getName(stats.getGraph()));
        }
        return OntologyMetaData.createParserMetaData(stats);
    }

    public static OntFormat readGraph(Graph graph, OWLOntologyDocumentSource source, OntLoaderConfiguration conf) throws OWLOntologyCreationException {
        IRI iri = OntApiException.notNull(source, "Null document source.").getDocumentIRI();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read graph from <{}>.", (Object)iri);
        }
        Supplier<OWLOntologyInputSourceException> orElse = () -> new OWLOntologyInputSourceException("Can't get input-stream/reader from " + iri);
        if (source.getInputStream().isPresent()) {
            return OntGraphUtils.read(graph, source, s -> (InputStream)s.getInputStream().orElseThrow(orElse));
        }
        if (source.getReader().isPresent()) {
            return OntGraphUtils.read(graph, source, s -> OntGraphUtils.buffer(OntGraphUtils.asInputStream((Reader)s.getReader().orElseThrow(orElse))));
        }
        if (conf.getSupportedSchemes().stream().noneMatch(s -> s.same(iri))) {
            throw new OntologyFactoryImpl.ConfigMismatchException("Not allowed scheme: " + iri);
        }
        String header = source.getAcceptHeaders().orElse(DEFAULT_REQUEST);
        return OntGraphUtils.read(graph, source, s -> (InputStream)DocumentSources.getInputStream((IRI)iri, (OWLOntologyLoaderConfiguration)conf, (String)header).orElseThrow(orElse));
    }

    public static OntFormat guessFormat(OWLOntologyDocumentSource source) {
        Optional mime = OntApiException.notNull(source, "Null document source.").getMIMEType();
        Lang lang = mime.isPresent() ? RDFLanguages.contentTypeToLang((String)((String)mime.get())) : RDFLanguages.filenameToLang((String)source.getDocumentIRI().getIRIString());
        return lang == null ? null : OntFormat.get(lang);
    }

    public static Set<OntFormat> getSupportedFormats(OWLOntologyDocumentSource source) throws OntologyFactoryImpl.UnsupportedFormatException {
        LinkedHashSet<OntFormat> res = new LinkedHashSet<OntFormat>();
        if (source.getFormat().isPresent()) {
            OntFormat f = OntFormat.get((OWLDocumentFormat)source.getFormat().get());
            if (f == null || !f.isReadSupported()) {
                throw new OntologyFactoryImpl.UnsupportedFormatException("Format " + source.getFormat().get() + " is not supported.");
            }
            res.add(f);
            return res;
        }
        OntFormat first = OntGraphUtils.guessFormat(source);
        if (first != null) {
            res.add(first);
        }
        OntFormat.formats().filter(OntFormat::isReadSupported).forEach(res::add);
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static OntFormat read(Graph graph, OWLOntologyDocumentSource source, OntInputSupplier supplier) throws OWLOntologyCreationException {
        IRI iri = source.getDocumentIRI();
        OntologyFactoryImpl.UnsupportedFormatException cause = new OntologyFactoryImpl.UnsupportedFormatException(String.format("Can't read %s %s.", source.getClass().getSimpleName(), iri));
        Iterator<OntFormat> iterator = OntGraphUtils.getSupportedFormats(source).iterator();
        while (iterator.hasNext()) {
            OntFormat format = iterator.next();
            if (format.isOWLOnly()) {
                cause.addSuppressed((Throwable)((Object)new OntologyFactoryImpl.UnsupportedFormatException("Not supported by jena.").putFormat(format).putSource(iri)));
                continue;
            }
            Lang lang = format.getLang();
            try (InputStream is = supplier.open(source);){
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("try <{}>", (Object)lang);
                }
                RDFDataMgr.read((Graph)graph, (InputStream)is, (String)iri.toString(), (Lang)lang);
                OntFormat ontFormat = format;
                return ontFormat;
            }
            catch (IOException | OWLOntologyInputSourceException e) {
                throw new OWLOntologyCreationException(source.getClass().getSimpleName() + ": can't open or close input stream from " + iri, e);
            }
            catch (RuntimeException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("<{}> failed: '{}'", (Object)lang, (Object)e.getMessage());
                }
                cause.addSuppressed((Throwable)((Object)new OntologyFactoryImpl.UnsupportedFormatException(e).putSource(iri).putFormat(format)));
            }
        }
        throw cause;
    }

    protected static InputStream asInputStream(Reader reader) {
        Charset charset = reader instanceof InputStreamReader ? Charset.forName(((InputStreamReader)reader).getEncoding()) : StandardCharsets.UTF_8;
        return new ReaderInputStream(reader, charset);
    }

    protected static InputStream buffer(InputStream is) {
        return new BufferedInputStream(is);
    }

    @FunctionalInterface
    protected static interface OntInputSupplier {
        public InputStream open(OWLOntologyDocumentSource var1) throws OWLOntologyInputSourceException;
    }
}

