/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.reflect.Reflection;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.DataFactoryImpl;
import ru.avicomp.ontapi.NoOpReadWriteLock;
import ru.avicomp.ontapi.OWLLangRegistry;
import ru.avicomp.ontapi.OWLLoaderImpl;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntologyBuilderImpl;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyFactoryImpl;
import ru.avicomp.ontapi.OntologyLoaderImpl;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.jena.OntModelFactory;

public class OntManagers
implements OWLOntologyManagerFactory {
    public static final ONTManagerProfile DEFAULT_PROFILE;
    private static OWLOntologyManagerFactory delegate;

    public static DataFactory getDataFactory() {
        return DEFAULT_PROFILE.dataFactory();
    }

    public static OntologyManager createONT() {
        return DEFAULT_PROFILE.create(false);
    }

    public static OntologyManager createConcurrentONT() {
        return DEFAULT_PROFILE.create(true);
    }

    public static OWLOntologyManager createOWL() {
        return OntManagers.createOWLProfile().create(false);
    }

    public static OWLOntologyManager createConcurrentOWL() {
        return OntManagers.createOWLProfile().create(true);
    }

    public static OWLOntologyManagerFactory getFactory() {
        return delegate;
    }

    public static void setFactory(OWLOntologyManagerFactory p) {
        delegate = OntApiException.notNull(p, "Null manager profile specified.");
    }

    public OWLOntologyManager get() {
        return delegate.get();
    }

    private static Class<?> findClass(String name) throws OntApiException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new OntApiException("No " + name + " in class-path found. Please include corresponding library to maven dependencies.", e);
        }
    }

    public static Profile createOWLProfile() throws OntApiException {
        try {
            return new OWLAPIBindingProfile();
        }
        catch (OntApiException i) {
            try {
                return new OWLAPIImplProfile();
            }
            catch (OntApiException j) {
                i.addSuppressed((Throwable)((Object)j));
                throw i;
            }
        }
    }

    static {
        OntModelFactory.init();
        DEFAULT_PROFILE = new ONTManagerProfile();
        delegate = (OWLOntologyManagerFactory & Serializable)() -> DEFAULT_PROFILE.create(false);
    }

    public static class OWLAPIImplProfile
    implements Profile {
        private final Class<?> managerClass = OntManagers.access$000("uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl");

        public OWLOntologyBuilder createOWLOntologyBuilder(ReadWriteLock lock) throws IllegalStateException {
            Class owlOntologyImplementationFactoryType = OntManagers.findClass("uk.ac.manchester.cs.owl.owlapi.OWLOntologyImplementationFactory");
            Object owlOntologyImplementationFactoryInstance = Reflection.newProxy((Class)owlOntologyImplementationFactoryType, (proxy, method, args) -> {
                if ("createOWLOntology".equals(method.getName()) && args != null && args.length == 2) {
                    OWLOntologyManager m = (OWLOntologyManager)args[0];
                    OWLOntologyID id = (OWLOntologyID)args[1];
                    return this.createOWLOntologyImpl(m, id);
                }
                String name = "Instance of " + owlOntologyImplementationFactoryType.getName();
                if ("toString".equals(method.getName()) && args == null) {
                    return name;
                }
                throw new OntApiException("[" + name + "] unsupported method call: " + method);
            });
            LinkedListMultimap nonConcurrentParams = LinkedListMultimap.create();
            nonConcurrentParams.put((Object)owlOntologyImplementationFactoryType, owlOntologyImplementationFactoryInstance);
            OWLOntologyBuilder res = (OWLOntologyBuilder)OWLAPIImplProfile.newInstance("uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentOWLOntologyBuilder", nonConcurrentParams);
            if (lock == null || NoOpReadWriteLock.NO_OP_RW_LOCK.equals(lock)) {
                return res;
            }
            LinkedListMultimap concurrentParams = LinkedListMultimap.create();
            concurrentParams.put(OWLOntologyBuilder.class, (Object)res);
            concurrentParams.put(ReadWriteLock.class, (Object)lock);
            return (OWLOntologyBuilder)OWLAPIImplProfile.newInstance("uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyBuilder", concurrentParams);
        }

        public OWLOntology createOWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID id) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyManager.class, (Object)manager);
            params.put(OWLOntologyID.class, (Object)id);
            return (OWLOntology)OWLAPIImplProfile.newInstance("uk.ac.manchester.cs.owl.owlapi.OWLOntologyImpl", params);
        }

        @Override
        public OWLOntologyManager create(boolean concurrent) {
            ReadWriteLock lock = concurrent ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK;
            OWLDataFactory dataFactory = this.createDataFactory(false);
            OWLOntologyFactory loadFactory = this.createLoadFactory(this.createOWLOntologyBuilder(lock));
            OWLOntologyManager res = this.create(dataFactory, lock);
            Set storers = OWLLangRegistry.storerFactories().collect(Collectors.toSet());
            Set parsers = OWLLangRegistry.parserFactories().collect(Collectors.toSet());
            res.getOntologyStorers().set(storers);
            res.getOntologyParsers().set(parsers);
            res.getOntologyFactories().add((Serializable)loadFactory);
            return res;
        }

        public OWLOntologyManager create(OWLDataFactory dataFactory, ReadWriteLock lock) {
            Constructor<?> constructor;
            try {
                constructor = this.managerClass.getConstructor(OWLDataFactory.class, ReadWriteLock.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(this.managerClass.getName() + ": can't find constructor", e);
            }
            try {
                return (OWLOntologyManager)constructor.newInstance(dataFactory, lock);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(this.managerClass.getName() + ": can't create new instance", e);
            }
        }

        @Override
        public OWLDataFactory dataFactory() {
            return this.createDataFactory(false);
        }

        public OWLDataFactory createDataFactory(boolean withCompression) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(Boolean.TYPE, (Object)withCompression);
            return (OWLDataFactory)OWLAPIImplProfile.newInstance("uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl", params);
        }

        public OWLOntologyFactory createLoadFactory(OWLOntologyBuilder builder) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyBuilder.class, (Object)builder);
            return (OWLOntologyFactory)OWLAPIImplProfile.newInstance("uk.ac.manchester.cs.owl.owlapi.OWLOntologyFactoryImpl", params);
        }

        private static Object newInstance(String classPath, LinkedListMultimap<Class<?>, Object> params) {
            Constructor constructor;
            Class clazz = OntManagers.findClass(classPath);
            String name = MessageFormat.format("{0}({1})", clazz.getName(), params.keys().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
            try {
                constructor = clazz.getConstructor((Class[])params.keys().toArray((Object[])new Class[params.size()]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unable to find constructor " + name, e);
            }
            try {
                return constructor.newInstance(params.values().toArray());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Can't init " + name);
            }
        }
    }

    public static class OWLAPIBindingProfile
    implements Profile {
        private final Class<?> provider = OntManagers.access$000("org.semanticweb.owlapi.apibinding.OWLManager");

        private static Method findStaticMethod(Class<?> provider, String name) throws IllegalStateException {
            try {
                return provider.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Can't find method '" + name + "' in " + provider, e);
            }
        }

        @Override
        public OWLOntologyManager create(boolean concurrent) throws IllegalStateException {
            Method manager = OWLAPIBindingProfile.findStaticMethod(this.provider, concurrent ? "createConcurrentOWLOntologyManager" : "createOWLOntologyManager");
            try {
                return (OWLOntologyManager)manager.invoke(null, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Can't create manager using " + manager, e);
            }
        }

        @Override
        public OWLDataFactory dataFactory() {
            Method factory = OWLAPIBindingProfile.findStaticMethod(this.provider, "getOWLDataFactory");
            try {
                return (OWLDataFactory)factory.invoke(null, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Can't create data factory using " + factory, e);
            }
        }
    }

    public static class ONTManagerProfile
    implements Profile {
        public static final DataFactory DEFAULT_DATA_FACTORY = new DataFactoryImpl();

        @Override
        public OntologyManager create(boolean concurrent) {
            ReadWriteLock lock = concurrent ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK;
            Set storers = OWLLangRegistry.storerFactories().collect(Collectors.toSet());
            Set parsers = OWLLangRegistry.parserFactories().collect(Collectors.toSet());
            OntologyManager res = this.create(this.dataFactory(), lock);
            res.getOntologyStorers().set(storers);
            res.getOntologyParsers().set(parsers);
            return res;
        }

        public OntologyManager create(DataFactory dataFactory, ReadWriteLock lock) {
            OntologyFactory factory = this.createOntologyFactory(this.createOntologyBuilder());
            return this.create(dataFactory, factory, lock);
        }

        public OntologyManager create(DataFactory dataFactory, OntologyFactory factory, ReadWriteLock lock) {
            return new OntologyManagerImpl(dataFactory, factory, lock);
        }

        @Override
        public DataFactory dataFactory() {
            return DEFAULT_DATA_FACTORY;
        }

        public OntologyFactory.Builder createOntologyBuilder() {
            return new OntologyBuilderImpl();
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder) {
            OntologyLoaderImpl loader = new OntologyLoaderImpl(builder, new OWLLoaderImpl(builder));
            return this.createOntologyFactory(builder, loader);
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder, OntologyFactory.Loader loader) {
            return new OntologyFactoryImpl(builder, loader);
        }
    }

    public static interface Profile {
        public OWLOntologyManager create(boolean var1);

        public OWLDataFactory dataFactory();
    }
}

