/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OWLAdapter;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntGraphDocumentSource;
import ru.avicomp.ontapi.OntGraphUtils;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyFactoryImpl;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.RWLockedCollection;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.transforms.GraphTransformers;
import ru.avicomp.ontapi.transforms.TransformException;

public class OntologyLoaderImpl
implements OntologyFactory.Loader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyLoaderImpl.class);
    protected final OntologyFactory.Builder builder;
    protected final OntologyFactory.Loader alternative;
    protected Map<String, GraphInfo> graphs = new LinkedHashMap<String, GraphInfo>();
    protected Map<IRI, Optional<IRI>> sourceMap = new HashMap<IRI, Optional<IRI>>();
    protected Map<IRI, GraphInfo> loaded = new HashMap<IRI, GraphInfo>();

    public OntologyLoaderImpl(OntologyFactory.Builder builder, OntologyFactory.Loader alternative) {
        this.builder = Objects.requireNonNull(builder, "Null builder");
        this.alternative = alternative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyModel load(OWLOntologyDocumentSource source, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (config.isUseOWLParsersToLoad()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Load ontology using OWL-API methods. Source [{}]{}", (Object)source.getClass().getSimpleName(), (Object)source.getDocumentIRI());
            }
            return OntApiException.notNull(this.alternative, "No OWL loader found.").load(source, manager, config);
        }
        try {
            GraphInfo primary = this.loadGraph(source, manager, config);
            this.graphs.put(primary.getURI(), primary);
            OntologyModel res = OntApiException.notNull(this.createModel(primary, manager, config), "Should never happen");
            List graphs = this.graphs.keySet().stream().filter(u -> !Objects.equals(u, primary.getURI())).map(k -> this.graphs.get(k)).collect(Collectors.toList());
            for (GraphInfo g : graphs) {
                this.createModel(g, manager, config);
            }
            OntologyModel ontologyModel = res;
            return ontologyModel;
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.graphs.clear();
        this.sourceMap.clear();
        this.loaded.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OntologyModel createModel(GraphInfo info, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (!info.isFresh()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The ontology {} is already configured.", (Object)info.name());
            }
            return null;
        }
        try {
            UnionGraph graph;
            OntologyModel res;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Set up ontology model {}.", (Object)info.name());
            }
            if (manager.contains(res = this.builder.createOntology((Graph)(graph = this.makeUnionGraph(info, manager, config)), manager, config))) {
                throw new OWLOntologyAlreadyExistsException(res.getOntologyID());
            }
            if (!info.isAnonymous()) {
                Models.insert(manager::models, res.asGraphModel(), false);
            }
            OWLAdapter.get().asIMPL(manager).ontologyCreated(res);
            OWLDocumentFormat format = info.getFormat().createOwlFormat();
            if (format.isPrefixOWLDocumentFormat()) {
                PrefixDocumentFormat pm = format.asPrefixOWLDocumentFormat();
                graph.getPrefixMapping().getNsPrefixMap().forEach((arg_0, arg_1) -> ((PrefixManager)pm).setPrefix(arg_0, arg_1));
                OntologyManagerImpl.setDefaultPrefix((PrefixManager)pm, res);
            }
            format.setOntologyLoaderMetaData(OntGraphUtils.makeParserMetaData((Graph)graph, info.getStats()));
            manager.setOntologyFormat(res, format);
            if (info.getSource() != null) {
                manager.setOntologyDocumentIRI(res, info.getSource());
            }
            OntologyModel ontologyModel = res;
            return ontologyModel;
        }
        finally {
            info.setProcessed();
        }
    }

    protected UnionGraph makeUnionGraph(GraphInfo info, OntologyManager manager, OntLoaderConfiguration config) throws OntologyFactoryImpl.OWLTransformException {
        GraphTransformers.Stats stats;
        boolean isPrimary = this.graphs.size() == 1;
        UnionGraph graph = this.makeUnionGraph(info, new HashSet<String>(), manager, config);
        if (!isPrimary || info.noTransforms() || !config.isPerformTransformation()) {
            return graph;
        }
        Set<Graph> transformed = this.graphs.values().stream().filter(g -> !g.isFresh() || g.noTransforms()).map(GraphInfo::getGraph).collect(Collectors.toSet());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Perform graph transformations on <{}>.", (Object)info.name());
        }
        try {
            stats = config.getGraphTransformers().transform((Graph)graph, transformed);
        }
        catch (TransformException t) {
            throw new OntologyFactoryImpl.OWLTransformException(t);
        }
        info.setStats(stats);
        stats.listStats(true).filter(GraphTransformers.Stats::isNotEmpty).forEach(s -> {
            String uri = Graphs.getURI(s.getGraph());
            if (uri == null) {
                LOGGER.warn("Not a named graph {}", (Object)Graphs.getName(s.getGraph()));
                return;
            }
            GraphInfo g = this.graphs.get(uri);
            if (g == null) {
                LOGGER.warn("Unable to find a graph for {}", (Object)Graphs.getName(s.getGraph()));
                return;
            }
            g.setStats((GraphTransformers.Stats)s);
        });
        return graph;
    }

    protected UnionGraph makeUnionGraph(GraphInfo node, Collection<String> seen, OntologyManager manager, OntLoaderConfiguration config) {
        LinkedHashSet<GraphInfo> children = new LinkedHashSet<GraphInfo>();
        Graph main = node.getGraph();
        String name = node.name();
        seen.add(node.getURI());
        List imports = node.getImports().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < imports.size(); ++i) {
            String uri = (String)imports.get(i);
            if (seen.contains(uri)) continue;
            OWLImportsDeclaration declaration = manager.getOWLDataFactory().getOWLImportsDeclaration(IRI.create((String)uri));
            if (config.isIgnoredImport(declaration.getIRI())) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("{}: {} is ignored.", (Object)name, (Object)declaration);
                continue;
            }
            GraphInfo info = this.graphs.get(uri);
            try {
                if (info == null) {
                    info = this.fetchGraph(uri, manager, config);
                }
                this.graphs.put(uri, info);
                if (info.isAnonymous() && MissingOntologyHeaderStrategy.INCLUDE_GRAPH.equals((Object)config.getMissingOntologyHeaderStrategy())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{}: remove import declaration <{}>.", (Object)name, (Object)uri);
                    }
                    main.remove(Node.ANY, OWL.imports.asNode(), NodeFactory.createURI((String)uri));
                    GraphUtil.addInto((Graph)main, (Graph)info.getGraph());
                    info.setProcessed();
                    imports.addAll(i + 1, info.getImports());
                    continue;
                }
                children.add(info);
                continue;
            }
            catch (OWLOntologyCreationException e) {
                if (MissingImportHandlingStrategy.THROW_EXCEPTION.equals((Object)config.getMissingImportHandlingStrategy())) {
                    throw new UnloadableImportException(e, declaration);
                }
                LOGGER.warn("Ontology {}: can't read sub graph with {}. Exception: {}", new Object[]{name, declaration, e.getMessage()});
            }
        }
        UnionGraph res = new UnionGraph(main);
        children.forEach(ch -> res.addGraph((Graph)this.makeUnionGraph((GraphInfo)ch, (Collection<String>)new HashSet<String>(seen), manager, config)));
        return res;
    }

    protected GraphInfo fetchGraph(String uri, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        IRI ontologyIRI = IRI.create((String)uri);
        OntologyModel res = this.findModel(manager, ontologyIRI);
        if (res != null) {
            return this.toGraphInfo(res, null);
        }
        IRI documentIRI = this.documentIRI(manager, ontologyIRI).orElse(ontologyIRI);
        res = this.findModel(manager, documentIRI);
        if (res != null) {
            return this.toGraphInfo(res, null);
        }
        OWLOntologyID id = new OWLOntologyID(ontologyIRI);
        OWLOntologyDocumentSource source = manager.getDocumentSourceMappers().stream().map(f -> f.map(id)).filter(Objects::nonNull).findFirst().orElse((OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI));
        return this.loadGraph(source, manager, config);
    }

    protected OntologyModel findModel(OntologyManager m, IRI iri) {
        OntologyModel res = m.getOntology(new OWLOntologyID(Optional.of(iri), Optional.empty()));
        if (res != null) {
            return res;
        }
        if (iri.toString().startsWith("file://")) {
            iri = IRI.create((String)iri.toString().replaceAll("/+", "/"));
            return m.getOntology(new OWLOntologyID(Optional.of(iri), Optional.empty()));
        }
        return null;
    }

    private Optional<IRI> documentIRI(OntologyManager manager, IRI source) {
        Optional<IRI> res = this.sourceMap.get(source);
        if (res != null) {
            this.sourceMap.remove(source);
        } else {
            res = OWLAdapter.get().asIMPL(manager).mapIRI(source);
            this.sourceMap.put(source, res);
        }
        return res;
    }

    protected GraphInfo toGraphInfo(OntologyModel model, IRI src) {
        OWLDocumentFormat owlFormat = model.getOWLOntologyManager().getOntologyFormat(model);
        OntFormat format = OntFormat.get(owlFormat);
        Graph graph = model.asGraphModel().getBaseGraph();
        if (owlFormat instanceof PrefixManager) {
            PrefixManager pm = (PrefixManager)owlFormat;
            Models.setNsPrefixes(graph.getPrefixMapping(), pm.getPrefixName2PrefixMap());
        }
        return new GraphInfo(graph, format, src, false);
    }

    protected GraphInfo toGraphInfo(Graph graph, OntFormat format, IRI src) {
        return new GraphInfo(graph, format, src, true);
    }

    public GraphInfo loadGraph(OWLOntologyDocumentSource source, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (source instanceof OntGraphDocumentSource) {
            OntGraphDocumentSource src = (OntGraphDocumentSource)source;
            Graph graph = src.getGraph();
            OntFormat format = src.getOntFormat();
            return this.toGraphInfo(graph, format, source.getDocumentIRI());
        }
        if (this.loaded.containsKey(source.getDocumentIRI())) {
            return this.loaded.get(source.getDocumentIRI());
        }
        IRI doc = source.getDocumentIRI();
        OWLOntologyDocumentSource src = this.documentIRI(manager, doc).map(IRIDocumentSource::new).map(OWLOntologyDocumentSource.class::cast).orElse(source);
        try {
            Graph graph = this.builder.createGraph();
            OntFormat format = OntGraphUtils.readGraph(graph, src, config);
            GraphInfo res = this.toGraphInfo(graph, format, doc);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Graph <{}> is loaded by jena. Source: {}[{}]. Format: {}", new Object[]{res.name(), source.getClass().getSimpleName(), res.getSource(), res.getFormat()});
            }
            return res;
        }
        catch (OntologyFactoryImpl.UnsupportedFormatException jenaEx) {
            if (this.alternative == null) {
                throw jenaEx;
            }
            if (source.getFormat().map(OntFormat::get).filter(OntFormat::isJena).isPresent()) {
                if (jenaEx.getSuppressed().length == 1) {
                    LOGGER.warn("Jena loading fail: {}", (Object)jenaEx.getSuppressed()[0].getMessage());
                } else {
                    LOGGER.warn("Jena loading fail!", (Throwable)((Object)jenaEx));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                String msg = jenaEx.getMessage();
                if (jenaEx.getCause() != null) {
                    msg = msg + " => " + jenaEx.getCause().getMessage();
                }
                LOGGER.debug("Can't load using jena: {}. Try OWL-API mechanisms.", (Object)msg);
            }
            OntologyManagerImpl copy = this.createLoadCopy(manager, config);
            try {
                OntologyModel ont = this.alternative.load(src, copy, config);
                ont.imports().forEach(o -> copy.documentIRIByOntology((OWLOntology)o).ifPresent(iri -> this.loaded.put((IRI)iri, this.toGraphInfo((OntologyModel)o, (IRI)iri))));
                GraphInfo res = this.toGraphInfo(ont, doc);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Graph <{}> is loaded by owl-api. Source: {}[{}]. Format: {}", new Object[]{res.name(), source.getClass().getSimpleName(), res.getSource(), res.getFormat()});
                }
                return res;
            }
            catch (OWLOntologyCreationException owlEx) {
                owlEx.addSuppressed((Throwable)((Object)jenaEx));
                throw owlEx;
            }
        }
    }

    protected OntologyManagerImpl createLoadCopy(OntologyManager from, final OntLoaderConfiguration defaultConfig) {
        final OntologyManagerImpl delegate = OWLAdapter.get().asIMPL(from);
        OntologyFactory factory = this.findFactory(delegate);
        return new OntologyManagerImpl(delegate.getOWLDataFactory(), factory, null){

            @Override
            protected Optional<OntologyModel> ontology(OWLOntologyID id) {
                Optional<OntologyModel> res = delegate.ontology(id);
                return res.isPresent() ? res : super.ontology(id);
            }

            @Override
            protected Optional<OntologyModel> importedOntology(OWLImportsDeclaration declaration) {
                Optional<OntologyModel> res = delegate.importedOntology(declaration);
                return res.isPresent() ? res : super.importedOntology(declaration);
            }

            @Override
            protected OntologyModel loadImports(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
                return super.loadImports(declaration, this.makeImportConfig(conf));
            }

            private OntLoaderConfiguration makeImportConfig(OWLOntologyLoaderConfiguration conf) {
                return conf instanceof OntLoaderConfiguration ? (OntLoaderConfiguration)conf : (defaultConfig == null ? delegate.getOntologyConfigurator().buildLoaderConfiguration() : defaultConfig);
            }

            @Override
            public boolean has(OWLOntology ontology) {
                return delegate.has(ontology) || super.has(ontology);
            }

            @Override
            protected Optional<IRI> documentIRIByOntology(OWLOntology ontology) {
                Optional<IRI> res = delegate.documentIRIByOntology(ontology);
                return res.isPresent() ? res : super.documentIRIByOntology(ontology);
            }

            @Override
            protected Optional<OntologyModel> ontologyByDocumentIRI(IRI iri) {
                Optional<OntologyModel> res = delegate.ontologyByDocumentIRI(iri);
                return res.isPresent() ? res : super.ontologyByDocumentIRI(iri);
            }

            @Override
            protected Optional<IRI> mapIRI(IRI iri) {
                return OntologyLoaderImpl.this.documentIRI(delegate, iri);
            }

            @Override
            public RWLockedCollection<OWLParserFactory> getOntologyParsers() {
                return delegate.getOntologyParsers();
            }

            @Override
            public OntConfig getOntologyConfigurator() {
                return delegate.getOntologyConfigurator();
            }

            @Override
            public OntLoaderConfiguration getOntologyLoaderConfiguration() {
                return delegate.getOntologyLoaderConfiguration();
            }

            public String toString() {
                return "CopyOf-" + delegate.toString();
            }
        };
    }

    protected OntologyFactory findFactory(OntologyManager m) throws IllegalStateException {
        return m.getOntologyFactories().stream().filter(OntologyFactoryImpl.class::isInstance).map(OntologyFactoryImpl.class::cast).filter(f -> Objects.equals(f.loader, this)).findFirst().orElseThrow(IllegalStateException::new);
    }

    public class GraphInfo {
        private final OntFormat format;
        private final Graph graph;
        private final IRI source;
        private boolean fresh;
        private boolean transforms;
        private Node ontology;
        private Set<String> imports;
        private GraphTransformers.Stats stats;

        protected GraphInfo(Graph graph, OntFormat format, IRI source, boolean withTransforms) {
            this.graph = graph;
            this.format = format;
            this.source = source;
            this.fresh = source != null;
            this.transforms = withTransforms;
        }

        protected Node ontology() {
            return this.ontology == null ? (this.ontology = Graphs.ontologyNode(Graphs.getBase(this.graph)).orElse(NodeFactory.createVariable((String)"NullOntology"))) : this.ontology;
        }

        public String getURI() {
            return this.ontology().isURI() ? this.ontology().getURI() : null;
        }

        public boolean isAnonymous() {
            return this.getURI() == null;
        }

        protected String name() {
            return this.ontology().toString();
        }

        protected Set<String> getImports() {
            return this.imports == null ? (this.imports = Graphs.getImports(this.graph)) : this.imports;
        }

        protected boolean isFresh() {
            return this.fresh;
        }

        protected boolean noTransforms() {
            return !this.transforms;
        }

        protected void setProcessed() {
            this.fresh = false;
        }

        protected OntFormat getFormat() {
            return this.format;
        }

        public Graph getGraph() {
            return this.graph;
        }

        protected IRI getSource() {
            return this.source;
        }

        public GraphTransformers.Stats getStats() {
            return this.stats;
        }

        protected void setStats(GraphTransformers.Stats stats) {
            this.stats = Objects.requireNonNull(stats, "Null transform stats");
        }
    }
}

