/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.RWLockedCollection;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.config.OntWriterConfiguration;
import ru.avicomp.ontapi.jena.model.OntGraphModel;

public interface OntologyManager
extends OWLOntologyManager {
    public DataFactory getOWLDataFactory();

    public OntConfig getOntologyConfigurator();

    public void setOntologyConfigurator(@Nullable OntologyConfigurator var1);

    public OntLoaderConfiguration getOntologyLoaderConfiguration();

    public void setOntologyLoaderConfiguration(@Nullable OWLOntologyLoaderConfiguration var1);

    public OntWriterConfiguration getOntologyWriterConfiguration();

    public void setOntologyWriterConfiguration(@Nullable OWLOntologyWriterConfiguration var1);

    public RWLockedCollection<OWLOntologyFactory> getOntologyFactories();

    public RWLockedCollection<OWLOntologyIRIMapper> getIRIMappers();

    public RWLockedCollection<DocumentSourceMapping> getDocumentSourceMappers();

    public RWLockedCollection<OWLParserFactory> getOntologyParsers();

    public RWLockedCollection<OWLStorerFactory> getOntologyStorers();

    public OntologyModel getOntology(@Nonnull IRI var1);

    public OntologyModel getOntology(@Nonnull OWLOntologyID var1);

    public boolean contains(@Nonnull IRI var1);

    public boolean contains(@Nonnull OWLOntologyID var1);

    @Nullable
    public OntologyModel getImportedOntology(@Nonnull OWLImportsDeclaration var1);

    public Stream<OWLOntology> ontologies();

    public OntologyModel createOntology(@Nonnull OWLOntologyID var1);

    public OntologyModel addOntology(@Nonnull Graph var1, @Nonnull OntLoaderConfiguration var2);

    public OntologyModel copyOntology(@Nonnull OWLOntology var1, @Nonnull OntologyCopy var2) throws OWLOntologyCreationException;

    public OntologyModel loadOntology(@Nonnull IRI var1) throws OWLOntologyCreationException;

    public OntologyModel loadOntologyFromOntologyDocument(@Nonnull OWLOntologyDocumentSource var1, @Nonnull OWLOntologyLoaderConfiguration var2) throws OWLOntologyCreationException;

    @Deprecated
    default public void setOntologyFactories(@Nonnull Set<OWLOntologyFactory> factories) throws OntApiException {
        this.getOntologyFactories().set(factories);
    }

    @Deprecated
    default public void setIRIMappers(@Nonnull Set<OWLOntologyIRIMapper> mappers) {
        this.getIRIMappers().set(mappers);
    }

    @Deprecated
    default public void addIRIMapper(@Nonnull OWLOntologyIRIMapper mapper) {
        this.getIRIMappers().add(mapper);
    }

    @Deprecated
    default public void removeIRIMapper(@Nonnull OWLOntologyIRIMapper mapper) {
        this.getIRIMappers().remove(mapper);
    }

    @Deprecated
    default public void clearIRIMappers() {
        this.getIRIMappers().clear();
    }

    @Deprecated
    default public Stream<DocumentSourceMapping> documentSourceMappers() {
        return this.getDocumentSourceMappers().stream();
    }

    @Deprecated
    default public void addDocumentSourceMapper(DocumentSourceMapping mapper) {
        this.getDocumentSourceMappers().add(mapper);
    }

    @Deprecated
    default public void removeDocumentSourceMapper(DocumentSourceMapping mapper) {
        this.getDocumentSourceMappers().remove(mapper);
    }

    @Deprecated
    default public void setOntologyParsers(@Nonnull Set<OWLParserFactory> parsers) {
        this.getOntologyParsers().set(parsers);
    }

    @Deprecated
    default public void setOntologyStorers(@Nonnull Set<OWLStorerFactory> storers) {
        this.getOntologyStorers().set(storers);
    }

    @Deprecated
    default public void addOntologyStorer(@Nonnull OWLStorerFactory storer) {
        this.getOntologyStorers().add(storer);
    }

    @Deprecated
    default public void removeOntologyStorer(@Nonnull OWLStorerFactory storer) {
        this.getOntologyStorers().remove(storer);
    }

    @Deprecated
    default public void clearOntologyStorers() {
        this.getOntologyStorers().clear();
    }

    default public OntologyModel addOntology(@Nonnull Graph graph) {
        return this.addOntology(graph, this.getOntologyLoaderConfiguration().setPerformTransformation(false));
    }

    default public OntologyModel createOntology() {
        return this.createOntology(new OWLOntologyID());
    }

    default public OntologyModel createOntology(@Nullable IRI iri) {
        return this.createOntology(new OWLOntologyID(Optional.ofNullable(iri), Optional.empty()));
    }

    default public OntologyModel loadOntologyFromOntologyDocument(@Nonnull OWLOntologyDocumentSource source) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(source, this.getOntologyLoaderConfiguration());
    }

    default public OntologyModel loadOntologyFromOntologyDocument(@Nonnull IRI iri) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new IRIDocumentSource(iri));
    }

    default public OntologyModel loadOntologyFromOntologyDocument(@Nonnull File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new FileDocumentSource(file));
    }

    default public OntologyModel loadOntologyFromOntologyDocument(@Nonnull InputStream input) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StreamDocumentSource(input));
    }

    default public OntGraphModel getGraphModel(@Nullable String iri, @Nullable String version) {
        OWLOntologyID id = new OWLOntologyID(Optional.ofNullable(iri).map(IRI::create), Optional.ofNullable(version).map(IRI::create));
        OntologyModel res = this.getOntology(id);
        return res == null ? null : res.asGraphModel();
    }

    default public OntGraphModel getGraphModel(@Nullable String iri) {
        return this.getGraphModel(iri, null);
    }

    default public OntGraphModel createGraphModel(@Nullable String iri, @Nullable String version) {
        OWLOntologyID id = new OWLOntologyID(Optional.ofNullable(iri).map(IRI::create), Optional.ofNullable(version).map(IRI::create));
        return this.createOntology(id).asGraphModel();
    }

    default public OntGraphModel createGraphModel(@Nullable String iri) {
        return this.createGraphModel(iri, null);
    }

    default public Stream<OntGraphModel> models() {
        return this.ontologies().map(OntologyModel.class::cast).map(OntologyModel::asGraphModel);
    }

    @FunctionalInterface
    public static interface DocumentSourceMapping
    extends Serializable {
        public OWLOntologyDocumentSource map(OWLOntologyID var1);
    }
}

