/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.ImportChange;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OWLStorerNotFoundException;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.InternalModelHolder;
import ru.avicomp.ontapi.NoOpReadWriteLock;
import ru.avicomp.ontapi.OWLAdapter;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntGraphDocumentSource;
import ru.avicomp.ontapi.OntGraphUtils;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.RWLockedCollection;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.config.OntWriterConfiguration;
import ru.avicomp.ontapi.internal.CacheDataFactory;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.InternalModel;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.impl.UnionModel;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.transforms.GraphTransformers;

public class OntologyManagerImpl
implements OntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyManagerImpl.class);
    private static final long serialVersionUID = -4764329329583952286L;
    protected final ListenersHolder listeners = new ListenersHolder();
    protected OntConfig configProvider;
    protected transient OntLoaderConfiguration loaderConfig;
    protected transient OntWriterConfiguration writerConfig;
    private static final int IRI_CACHE_SIZE = 2048;
    protected transient LoadingCache<String, IRI> iris = CacheDataFactory.build(2048L, IRI::create);
    protected final RWLockedCollection<OWLOntologyFactory> ontologyFactories;
    protected final RWLockedCollection<OWLOntologyIRIMapper> documentIRIMappers;
    protected final RWLockedCollection<OntologyManager.DocumentSourceMapping> documentSourceMappers;
    protected final RWLockedCollection<OWLParserFactory> parserFactories;
    protected final RWLockedCollection<OWLStorerFactory> ontologyStorers;
    protected final ReadWriteLock lock;
    protected final DataFactory dataFactory;
    protected final OntologyCollection content;

    public OntologyManagerImpl(DataFactory dataFactory, OntologyFactory ontologyFactory, ReadWriteLock readWriteLock) {
        this(dataFactory, readWriteLock, PriorityCollectionSorting.ON_SET_INJECTION_ONLY);
        this.ontologyFactories.add((OWLOntologyFactory)((Serializable)((Object)Objects.requireNonNull(ontologyFactory, "Null Ontology Factory"))));
    }

    protected OntologyManagerImpl(DataFactory dataFactory, ReadWriteLock lock, PriorityCollectionSorting sorting) {
        this.dataFactory = Objects.requireNonNull(dataFactory, "Null Data Factory");
        this.lock = lock == null ? NoOpReadWriteLock.NO_OP_RW_LOCK : lock;
        PriorityCollectionSorting _sorting = sorting == null ? PriorityCollectionSorting.NEVER : sorting;
        this.documentIRIMappers = new RWLockedCollection(this.lock, _sorting);
        this.documentSourceMappers = new RWLockedCollection(this.lock);
        this.ontologyFactories = new RWLockedCollection<OWLOntologyFactory>(this.lock, _sorting){

            @Override
            protected void onAdd(OWLOntologyFactory f) {
                if (f instanceof OntologyFactory) {
                    return;
                }
                throw new OntApiException("Wrong argument: " + f + ". Only " + OntologyFactory.class.getSimpleName() + " can be accepted.");
            }
        };
        this.parserFactories = new RWLockedCollection(this.lock, _sorting);
        this.ontologyStorers = new RWLockedCollection(this.lock, _sorting);
        this.configProvider = new ConcurrentConfig(this.lock);
        this.content = new OntologyCollection(this.isConcurrent() ? CollectionFactory.createSyncSet() : CollectionFactory.createSet());
    }

    public boolean isConcurrent() {
        return NoOpReadWriteLock.NO_OP_RW_LOCK != this.lock;
    }

    @Nonnull
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public OntConfig getOntologyConfigurator() {
        this.getLock().readLock().lock();
        try {
            OntConfig ontConfig = this.configProvider;
            return ontConfig;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public void setOntologyConfigurator(OntologyConfigurator conf) {
        this.getLock().writeLock().lock();
        try {
            this.configProvider = OWLAdapter.get().asONT(conf);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOntologyLoaderConfiguration(@Nullable OWLOntologyLoaderConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            OntLoaderConfiguration config = OWLAdapter.get().asONT(conf);
            OntLoaderConfiguration was = this.loaderConfig;
            if (Objects.equals((Object)was, (Object)config)) {
                return;
            }
            boolean hasChanges = ModelConfig.hasChanges(was, config);
            this.content.values().filter(i -> i.getModelConfig().hasLoaderConfig() ? i.getModelConfig().hasChanges(config) : hasChanges).map(OntInfo::get).forEach(OntologyModel::clearCache);
            this.loaderConfig = config;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public OntLoaderConfiguration getOntologyLoaderConfiguration() {
        this.getLock().readLock().lock();
        try {
            OntLoaderConfiguration ontLoaderConfiguration = this.loaderConfig == null ? (this.loaderConfig = this.configProvider.buildLoaderConfiguration()) : this.loaderConfig;
            return ontLoaderConfiguration;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public void setOntologyWriterConfiguration(@Nullable OWLOntologyWriterConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            if (Objects.equals((Object)this.writerConfig, conf)) {
                return;
            }
            this.writerConfig = OWLAdapter.get().asONT(conf);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public OntWriterConfiguration getOntologyWriterConfiguration() {
        this.getLock().readLock().lock();
        try {
            OntWriterConfiguration ontWriterConfiguration = this.writerConfig == null ? (this.writerConfig = this.configProvider.buildWriterConfiguration()) : this.writerConfig;
            return ontWriterConfiguration;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public RWLockedCollection<OWLOntologyFactory> getOntologyFactories() {
        return this.ontologyFactories;
    }

    @Override
    public RWLockedCollection<OWLStorerFactory> getOntologyStorers() {
        return this.ontologyStorers;
    }

    @Override
    public RWLockedCollection<OWLParserFactory> getOntologyParsers() {
        return this.parserFactories;
    }

    @Override
    public RWLockedCollection<OWLOntologyIRIMapper> getIRIMappers() {
        return this.documentIRIMappers;
    }

    @Override
    public RWLockedCollection<OntologyManager.DocumentSourceMapping> getDocumentSourceMappers() {
        return this.documentSourceMappers;
    }

    public void setDefaultChangeBroadcastStrategy(@Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.setDefaultChangeBroadcastStrategy(strategy);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener, @Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeListener(listener, strategy);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addImpendingOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeImpendingOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangesVetoedListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangesVetoedListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addMissingImportListener(@Nonnull MissingImportListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addMissingImportListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeMissingImportListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyLoaderListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyLoaderListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeProgessListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangeProgessListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public OntologyModel createOntology(@Nonnull OWLOntologyID id) {
        this.getLock().writeLock().lock();
        try {
            OntologyModel ontologyModel = this.create(id).get();
            return ontologyModel;
        }
        catch (OWLOntologyCreationException e) {
            throw new OntApiException("Unable to create ontology " + id, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected OntInfo create(OWLOntologyID id) throws OWLOntologyCreationException, OWLOntologyFactoryNotFoundException {
        Optional<OntInfo> ont = this.content.get(id);
        if (ont.isPresent()) {
            throw new OWLOntologyAlreadyExistsException(id);
        }
        IRI doc = this.computeDocumentIRI(id);
        if (doc == null) {
            throw new OWLOntologyCreationException("Can't compute document iri from id " + id);
        }
        if (this.content.values().anyMatch(o -> Objects.equals(o.getDocumentIRI(), doc))) {
            throw new OWLOntologyDocumentAlreadyExistsException(doc);
        }
        for (OWLOntologyFactory factory : this.getOntologyFactories()) {
            if (!factory.canCreateFromDocumentIRI(doc)) continue;
            factory.createOWLOntology((OWLOntologyManager)this, id, doc, (OWLOntologyFactory.OWLOntologyCreationHandler)this);
            return this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id)).addDocumentIRI(doc);
        }
        throw new OWLOntologyFactoryNotFoundException(doc);
    }

    public OntologyModel createOntology(@Nonnull IRI iri, @Nonnull Stream<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = new OWLOntologyID(Optional.of(iri), Optional.empty());
            if (this.contains(iri)) {
                throw new OWLOntologyAlreadyExistsException(id);
            }
            OntologyModel res = this.createOntology(iri);
            this.addAxioms(res, ontologies.flatMap(o -> copyLogicalAxiomsOnly ? o.logicalAxioms() : o.axioms()));
            OntologyModel ontologyModel = res;
            return ontologyModel;
        }
        catch (OWLOntologyAlreadyExistsException e) {
            throw new OntApiException("Unable to create ontology " + iri, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public OntologyModel createOntology(@Nonnull Stream<OWLAxiom> axioms, @Nonnull IRI iri) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = new OWLOntologyID(Optional.of(iri), Optional.empty());
            if (this.contains(iri)) {
                throw new OWLOntologyAlreadyExistsException(id);
            }
            OntologyModel ont = this.createOntology(iri);
            this.addAxioms(ont, axioms);
            OntologyModel ontologyModel = ont;
            return ontologyModel;
        }
        catch (OWLOntologyAlreadyExistsException e) {
            throw new OntApiException("Unable to create ontology " + iri, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyModel addOntology(@Nonnull Graph graph, @Nonnull OntLoaderConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = OntGraphUtils.getOntologyID(graph);
            Map<OWLOntologyID, Graph> graphs = OntGraphUtils.toGraphMap(graph);
            OntologyManager.DocumentSourceMapping mapping = _id -> graphs.entrySet().stream().filter(e -> ((OWLOntologyID)e.getKey()).match(_id)).map(e -> OntGraphDocumentSource.wrap((Graph)e.getValue())).findFirst().orElse(null);
            RWLockedCollection<OntologyManager.DocumentSourceMapping> store = this.getDocumentSourceMappers();
            try {
                store.add(mapping);
                OntologyModel ontologyModel = this.loadOntologyFromOntologyDocument(mapping.map(id), conf);
                store.remove(mapping);
                return ontologyModel;
            }
            catch (Throwable throwable) {
                try {
                    store.remove(mapping);
                    throw throwable;
                }
                catch (OWLOntologyCreationException e) {
                    throw new OntApiException("Unable put graph into the manager", e);
                }
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Nullable
    protected IRI computeDocumentIRI(OWLOntologyID id) {
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI == null) {
            documentIRI = !id.isAnonymous() ? (IRI)id.getDefaultDocumentIRI().orElse(null) : IRI.generateDocumentIRI();
        }
        return documentIRI;
    }

    @Nullable
    protected IRI getDocumentIRIFromMappers(OWLOntologyID id) {
        IRI defaultIRI = id.getDefaultDocumentIRI().orElse(null);
        if (defaultIRI == null) {
            return null;
        }
        return this.mapIRI(defaultIRI).orElse(defaultIRI);
    }

    protected Optional<IRI> mapIRI(IRI iri) {
        return Iter.asStream(this.getIRIMappers().iterator()).map(m -> m.getDocumentIRI(iri)).filter(Objects::nonNull).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OntologyModel getOntology(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            OWLOntologyID id = new OWLOntologyID(Optional.of(iri), Optional.empty());
            Optional<OntInfo> res = this.content.get(id);
            if (!res.isPresent()) {
                res = this.content.values().filter(e -> e.id().match(iri)).findFirst();
            }
            OntologyModel ontologyModel = res.map(OntInfo::get).orElse(null);
            return ontologyModel;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public OntologyModel getOntology(@Nonnull OWLOntologyID id) {
        this.getLock().readLock().lock();
        try {
            OntologyModel ontologyModel = this.ontology(id).orElse(null);
            return ontologyModel;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<OntologyModel> ontology(OWLOntologyID id) {
        Optional<OntInfo> res = this.content.get(id);
        if (!res.isPresent() && !id.isAnonymous()) {
            IRI iri = (IRI)id.getOntologyIRI().orElseThrow(() -> new IllegalStateException("Should never happen."));
            res = this.content.values().filter(e -> e.id().matchOntology(iri)).findFirst();
        }
        return res.map(OntInfo::get);
    }

    protected Optional<OntologyModel> ontology(Graph graph) {
        return this.content.values().map(OntInfo::get).filter(m -> Graphs.isSameBase(graph, m.asGraphModel().getGraph())).findFirst();
    }

    @Override
    public boolean contains(@Nonnull IRI iri) {
        OntApiException.notNull(iri, "Ontology IRI cannot be null");
        this.getLock().readLock().lock();
        try {
            boolean bl = this.content.keys().anyMatch(o -> o.match(iri));
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean contains(@Nonnull OWLOntologyID id) {
        this.getLock().readLock().lock();
        try {
            if (id.isAnonymous()) ** GOTO lbl-1000
            if (this.content.contains(id)) ** GOTO lbl-1000
            if (this.content.keys().anyMatch((Predicate<OWLOntologyID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, match(org.semanticweb.owlapi.model.OWLOntologyID ), (Lorg/semanticweb/owlapi/model/OWLOntologyID;)Z)((OWLOntologyID)id))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var2_2 = v0;
            return var2_2;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public boolean contains(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            boolean bl = this.has(ontology);
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected boolean has(OWLOntology ontology) {
        return this.content.values().map(OntInfo::get).anyMatch(o -> Objects.equals(o, ontology));
    }

    public boolean containsVersion(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            boolean bl = this.content.keys().anyMatch(o -> o.matchVersion(iri));
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void removeOntology(OWLOntology ontology) {
        this.getLock().writeLock().lock();
        try {
            this.removeOntology(ontology.getOntologyID());
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntology(@Nonnull OWLOntologyID id) {
        this.getLock().writeLock().lock();
        try {
            this.content.remove(id).map(OntInfo::get).ifPresent(m -> m.setOWLOntologyManager(null));
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void clearOntologies() {
        this.getLock().writeLock().lock();
        try {
            this.listeners.clear();
            this.content.values().map(OntInfo::get).forEach(o -> o.setOWLOntologyManager(null));
            this.content.clear();
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public OntologyModel getImportedOntology(@Nonnull OWLImportsDeclaration declaration) {
        this.getLock().readLock().lock();
        try {
            OntologyModel ontologyModel = this.importedOntology(declaration).orElse(null);
            return ontologyModel;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<OntologyModel> importedOntology(OWLImportsDeclaration declaration) {
        Optional<OntInfo> res = this.content.values().filter(e -> Objects.equals(e.getImportDeclaration(), declaration)).findFirst();
        if (!res.isPresent()) {
            res = this.content.values().filter(e -> Objects.equals(e.getDocumentIRI(), declaration.getIRI())).findFirst();
        }
        return res.map(OntInfo::get);
    }

    protected Optional<OntologyModel> ontologyByDocumentIRI(IRI iri) {
        return this.content.values().filter(o -> Objects.equals(iri, o.getDocumentIRI())).map(OntInfo::get).findFirst();
    }

    @Nonnull
    public IRI getOntologyDocumentIRI(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            if (!this.has(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            IRI iRI = this.documentIRIByOntology(ontology).orElseThrow(() -> new OntApiException("Null document iri, ontology id=" + ontology.getOntologyID()));
            return iRI;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<IRI> documentIRIByOntology(OWLOntology ontology) {
        return this.content.get(ontology.getOntologyID()).flatMap(i -> Optional.ofNullable(i.getDocumentIRI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyDocumentIRI(@Nonnull OWLOntology ontology, @Nonnull IRI documentIRI) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            OntInfo info = this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id));
            info.addDocumentIRI(documentIRI);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyFormat(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat format) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id)).addFormat(format);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLDocumentFormat getOntologyFormat(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            OWLDocumentFormat oWLDocumentFormat = this.content.get(id).map(OntInfo::getFormat).orElse(null);
            return oWLDocumentFormat;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void ontologyCreated(@Nonnull OWLOntology ont) {
        this.getLock().writeLock().lock();
        try {
            this.content.add((OntologyModel)ont);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public Stream<OWLOntology> directImports(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            Stream<OWLOntology> stream = ontology.importsDeclarations().map(this::getImportedOntology).map(OWLOntology.class::cast).filter(Objects::nonNull);
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public Stream<OWLOntology> imports(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntology> stream = this.getImports(ontology, new LinkedHashSet<OWLOntology>()).stream();
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Set<OWLOntology> getImports(OWLOntology ont, Set<OWLOntology> result) {
        this.directImports(ont).filter(result::add).forEach(o -> this.getImports((OWLOntology)o, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLOntology> importsClosure(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            Set res = this.isConcurrent() ? CollectionFactory.createSyncSet() : CollectionFactory.createSet();
            this.collectImportsClosure(ontology, res);
            Stream<OWLOntology> stream = res.stream();
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected void collectImportsClosure(OWLOntology ontology, Set<OWLOntology> res) {
        res.add(ontology);
        this.directImports(ontology).filter(o -> !res.contains(o)).forEach(o -> this.collectImportsClosure((OWLOntology)o, res));
    }

    public List<OWLOntology> getSortedImportsClosure(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            List<OWLOntology> list = ontology.importsClosure().sorted().collect(Collectors.toList());
            return list;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public Stream<OWLOntology> ontologies() {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntology> stream = this.content.values().map(OntInfo::get);
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public Stream<OWLOntologyID> ontologyIDsByVersion(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntologyID> stream = this.content.keys().filter(o -> o.matchVersion(iri));
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public ChangeApplied addAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        return this.applyChanges(Collections.singletonList(new AddAxiom(ont, axiom)));
    }

    public ChangeApplied addAxioms(@Nonnull OWLOntology ont, @Nonnull Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(axioms.map(ax -> new AddAxiom(ont, ax)).collect(Collectors.toList()));
    }

    public ChangeApplied removeAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        return this.applyChanges(Collections.singletonList(new RemoveAxiom(ont, axiom)));
    }

    public ChangeApplied removeAxioms(@Nonnull OWLOntology ont, @Nonnull Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(axioms.map(ax -> new RemoveAxiom(ont, ax)).collect(Collectors.toList()));
    }

    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        return this.applyChanges(Collections.singletonList(change));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetails applyChangesAndGetDetails(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.broadcastImpendingChanges(changes);
            AtomicBoolean rollbackRequested = new AtomicBoolean(false);
            AtomicBoolean allNoOps = new AtomicBoolean(true);
            ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
            this.listeners.fireBeginChanges(changes.size());
            this.actuallyApply(changes, rollbackRequested, allNoOps, appliedChanges);
            if (rollbackRequested.get()) {
                this.rollBack(appliedChanges);
                appliedChanges.clear();
            }
            this.listeners.fireEndChanges();
            this.listeners.broadcastChanges(appliedChanges);
            if (rollbackRequested.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, appliedChanges);
                return changeDetails;
            }
            if (allNoOps.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.NO_OPERATION, appliedChanges);
                return changeDetails;
            }
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.SUCCESSFULLY, appliedChanges);
            return changeDetails;
        }
        catch (OWLOntologyChangeVetoException e) {
            this.listeners.broadcastOntologyChangesVetoed(changes, e);
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, Collections.emptyList());
            return changeDetails;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void actuallyApply(List<? extends OWLOntologyChange> changes, AtomicBoolean rollbackRequested, AtomicBoolean allNoOps, List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (rollbackRequested.get()) continue;
            assert (oWLOntologyChange != null);
            ChangeApplied enactChangeApplication = this.enactChangeApplication(oWLOntologyChange);
            if (enactChangeApplication == ChangeApplied.UNSUCCESSFULLY) {
                rollbackRequested.set(true);
            }
            if (enactChangeApplication == ChangeApplied.SUCCESSFULLY) {
                allNoOps.set(false);
                appliedChanges.add(oWLOntologyChange);
            }
            this.listeners.fireChangeApplied(oWLOntologyChange);
        }
    }

    protected void rollBack(List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange c : appliedChanges) {
            if (this.enactChangeApplication(c.reverseChange()) != ChangeApplied.UNSUCCESSFULLY) continue;
            throw new OWLRuntimeException("Rollback of changes unsuccessful: Change " + c + " could not be rolled back");
        }
    }

    protected ChangeApplied enactChangeApplication(OWLOntologyChange change) {
        if (!this.isChangeApplicable(change)) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change.getChangeData(), ont.toString());
        }
        this.checkForOntologyIDChange(change);
        ChangeApplied appliedChange = ont.applyDirectChange(change);
        this.checkForImportsChange(change);
        return appliedChange;
    }

    protected boolean isChangeApplicable(OWLOntologyChange change) {
        OWLOntologyID id = change.getOntology().getOntologyID();
        Optional<ModelConfig> conf = this.content.get(id).map(OntInfo::getModelConfig);
        return !conf.isPresent() || conf.get().isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    protected void checkForOntologyIDChange(OWLOntologyChange change) {
        if (!(change instanceof SetOntologyID)) {
            return;
        }
        SetOntologyID setID = (SetOntologyID)change;
        Optional<OntologyModel> existingOntology = this.content.get(setID.getNewOntologyID()).map(OntInfo::get);
        OWLOntology o = setID.getOntology();
        if (existingOntology.isPresent() && !o.equals(existingOntology.get()) && !o.equalAxioms((HasAxiomsByType)existingOntology.get())) {
            LOGGER.warn("uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl#checkForOntologyIDChange:: existing:{}, new:{}", existingOntology, (Object)o);
            throw new OWLOntologyRenameException((OWLOntologyChangeData)setID.getChangeData(), setID.getNewOntologyID());
        }
    }

    protected void checkForImportsChange(OWLOntologyChange change) {
        if (!change.isImportChange()) {
            return;
        }
        OWLImportsDeclaration declaration = ((ImportChange)change).getImportDeclaration();
        OntologyModel ontology = (OntologyModel)change.getOntology();
        OWLOntologyID id = ontology.getOntologyID();
        Optional<OntWriterConfiguration> conf = this.content.get(id).map(OntInfo::getModelConfig).map(ModelConfig::getWriterConfig);
        if (!conf.isPresent() || !conf.get().isControlImports()) {
            return;
        }
        OntologyModel importedOntology = this.getImportedOntology(declaration);
        if (importedOntology == null) {
            return;
        }
        List<Object> relatedChanges = change instanceof AddImport ? importedOntology.axioms(AxiomType.DECLARATION, Imports.INCLUDED).filter(arg_0 -> ((OntologyModel)ontology).containsAxiom(arg_0)).map(a -> new RemoveAxiom((OWLOntology)ontology, (OWLAxiom)a)).collect(Collectors.toList()) : importedOntology.signature(Imports.INCLUDED).filter(arg_0 -> ((OntologyModel)ontology).containsReference(arg_0)).map(e -> this.getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)e)).map(a -> new AddAxiom((OWLOntology)ontology, (OWLAxiom)a)).collect(Collectors.toList());
        relatedChanges.forEach(arg_0 -> ((OntologyModel)ontology).applyDirectChange(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyModel copyOntology(@Nonnull OWLOntology source, @Nonnull OntologyCopy settings) throws OWLOntologyCreationException {
        this.getLock().writeLock().lock();
        try {
            OntologyModel res;
            OntApiException.notNull(source, "Null ontology.");
            OntApiException.notNull(settings, "Null settings.");
            OWLOntologyManager m = source.getOWLOntologyManager();
            switch (settings) {
                case MOVE: {
                    if (!(source instanceof OntologyModel)) {
                        throw new OWLOntologyCreationException(String.format("Can't move %s: not an %s. Use %s or %s parameter.", source.getOntologyID(), OntologyModel.class.getSimpleName(), OntologyCopy.DEEP, OntologyCopy.SHALLOW));
                    }
                    res = (OntologyModel)source;
                    this.ontologyCreated(res);
                    break;
                }
                case SHALLOW: 
                case DEEP: {
                    OntInfo info = this.create(source.getOntologyID());
                    OntologyModel o = info.get();
                    AxiomType.AXIOM_TYPES.forEach(t -> this.addAxioms(o, source.axioms(t)));
                    source.annotations().forEach(a -> this.applyChange((OWLOntologyChange)new AddOntologyAnnotation((OWLOntology)o, a)));
                    source.importsDeclarations().forEach(a -> this.applyChange((OWLOntologyChange)new AddImport((OWLOntology)o, a)));
                    res = o;
                    break;
                }
                default: {
                    throw new OWLRuntimeException("settings value not understood: " + settings);
                }
            }
            if (settings == OntologyCopy.MOVE || settings == OntologyCopy.DEEP) {
                this.setOntologyDocumentIRI(res, m.getOntologyDocumentIRI(source));
                OWLDocumentFormat ontologyFormat = m.getOntologyFormat(source);
                if (ontologyFormat != null) {
                    this.setOntologyFormat(res, ontologyFormat);
                }
            }
            if (settings == OntologyCopy.MOVE) {
                m.removeOntology(source);
                res.setOWLOntologyManager(this);
            }
            OntologyModel ontologyModel = res;
            return ontologyModel;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void rollBackMoving(OWLOntology o, OWLOntologyManager owlManager) {
        IRI doc;
        this.ontologyCreated(o);
        OWLDocumentFormat f = owlManager.getOntologyFormat(o);
        if (f != null) {
            this.setOntologyFormat(o, f);
        }
        try {
            doc = owlManager.getOntologyDocumentIRI(o);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Document IRI is not expected to be null!", (Throwable)e);
            return;
        }
        this.setOntologyDocumentIRI(o, doc);
    }

    @Override
    public OntologyModel loadOntology(@Nonnull IRI source) throws OWLOntologyCreationException {
        this.getLock().writeLock().lock();
        try {
            OntologyModel ontologyModel = this.load(source, false, (OWLOntologyLoaderConfiguration)this.getOntologyLoaderConfiguration());
            return ontologyModel;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyModel loadOntologyFromOntologyDocument(@Nonnull OWLOntologyDocumentSource source, @Nonnull OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.getLock().writeLock().lock();
        try {
            OntologyModel ontologyModel = this.load(null, source, conf);
            return ontologyModel;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected OntologyModel load(IRI iri, boolean allowExists, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        OWLOntologyID id = new OWLOntologyID(Optional.of(iri), Optional.empty());
        OntologyModel ontByID = this.getOntology(id);
        if (ontByID != null) {
            return ontByID;
        }
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI != null) {
            Optional<OntologyModel> op = this.ontologyByDocumentIRI(documentIRI);
            if (op.isPresent() && !allowExists) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            if (op.isPresent()) {
                return op.get();
            }
        } else {
            throw new OntologyIRIMappingNotFoundException(iri);
        }
        return this.load(iri, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), conf);
    }

    protected OntologyModel load(@Nullable IRI iri, OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.listeners.fireStartedLoadingEvent(new OWLOntologyID(Optional.ofNullable(iri), Optional.empty()), source.getDocumentIRI());
        Throwable ex = null;
        OWLOntologyID id = new OWLOntologyID();
        try {
            OntologyModel res = this.load(source, conf);
            id = res.getOntologyID();
            OntologyModel ontologyModel = res;
            return ontologyModel;
        }
        catch (OWLOntologyCreationException | UnloadableImportException e) {
            ex = e;
            throw e;
        }
        catch (OWLRuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OWLOntologyCreationException) {
                ex = (OWLOntologyCreationException)cause;
                throw (OWLOntologyCreationException)cause;
            }
            throw e;
        }
        finally {
            this.listeners.fireFinishedLoadingEvent(id, source.getDocumentIRI(), (Exception)ex);
        }
    }

    protected OntologyModel load(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException, OWLOntologyFactoryNotFoundException {
        for (OWLOntologyFactory factory : this.getOntologyFactories()) {
            if (!factory.canAttemptLoading(source)) continue;
            try {
                OntologyModel res = (OntologyModel)factory.loadOWLOntology((OWLOntologyManager)this, source, (OWLOntologyFactory.OWLOntologyCreationHandler)this, conf);
                OWLOntologyID id = res.getOntologyID();
                this.fixIllegalPunnings(res);
                return this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id)).addDocumentIRI(source.getDocumentIRI()).get();
            }
            catch (OWLOntologyRenameException e) {
                throw new OWLOntologyAlreadyExistsException(e.getOntologyID(), (Throwable)e);
            }
        }
        throw new OWLOntologyFactoryNotFoundException(source.getDocumentIRI());
    }

    protected void fixIllegalPunnings(OWLOntology o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OntologyModel loadImports(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.listeners.incrementImportsLoadCount();
        try {
            OntologyModel ontologyModel = this.load(declaration.getIRI(), true, conf);
            return ontologyModel;
        }
        catch (OWLOntologyCreationException e) {
            if (MissingImportHandlingStrategy.THROW_EXCEPTION.equals((Object)conf.getMissingImportHandlingStrategy())) {
                throw e;
            }
            MissingImportEvent evt = new MissingImportEvent(declaration.getIRI(), e);
            this.listeners.fireMissingImportEvent(evt);
        }
        finally {
            this.listeners.decrementImportsLoadCount();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeLoadImportRequest(@Nonnull OWLImportsDeclaration declaration, @Nonnull OWLOntologyLoaderConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            if (conf.isIgnoredImport(declaration.getIRI())) {
                return;
            }
            if (this.getImportedOntology(declaration) != null) {
                return;
            }
            try {
                OntologyModel m = this.loadImports(declaration, conf);
                if (m != null) {
                    this.content.get(m.getOntologyID()).ifPresent(ontInfo -> ontInfo.addImportDeclaration(declaration));
                }
            }
            catch (OWLOntologyCreationException e) {
                throw new UnloadableImportException(e, declaration);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void saveOntology(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat ontologyFormat, final @Nonnull IRI documentIRI) throws OWLOntologyStorageException {
        if (!documentIRI.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
        }
        this.saveOntology(ontology, ontologyFormat, new OWLOntologyDocumentTarget(){

            public Optional<IRI> getDocumentIRI() {
                return Optional.of(documentIRI);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOntology(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat ontologyFormat, @Nonnull OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getLock().readLock().lock();
        try {
            this.write(ontology, ontologyFormat, documentTarget);
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void write(OWLOntology ontology, OWLDocumentFormat doc, OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        if (!(ontology instanceof OntologyModel)) {
            throw new OntApiException.Unsupported("Unsupported OWLOntology instance: " + this);
        }
        OntFormat format = OntApiException.notNull(OntFormat.get(doc), "Can't determine format: " + doc);
        OntologyModel ont = (OntologyModel)ontology;
        if (!format.isJena()) {
            ((InternalModelHolder)((Object)ont)).getBase().clearCacheIfNeeded();
            try {
                for (OWLStorerFactory storer : this.getOntologyStorers()) {
                    OWLStorer writer = storer.createStorer();
                    if (!writer.canStoreOntology(doc)) continue;
                    writer.storeOntology((OWLOntology)ont, target, doc);
                    return;
                }
                throw new OWLStorerNotFoundException(doc);
            }
            catch (IOException e) {
                throw new OWLOntologyStorageIOException(e);
            }
        }
        OutputStream os = null;
        if (target.getOutputStream().isPresent()) {
            os = (OutputStream)target.getOutputStream().get();
        } else if (target.getDocumentIRI().isPresent()) {
            IRI iri = (IRI)target.getDocumentIRI().get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Save {} to {}", (Object)ont.getOntologyID(), (Object)iri);
            }
            try {
                os = OntologyManagerImpl.openStream(iri);
            }
            catch (IOException e) {
                throw new OWLOntologyStorageIOException(e);
            }
        } else if (target.getWriter().isPresent()) {
            os = new WriterOutputStream((Writer)target.getWriter().get(), StandardCharsets.UTF_8);
        }
        if (os == null) {
            throw new OWLOntologyStorageException("Null output stream, format = " + doc);
        }
        Model model = ont.asGraphModel().getBaseModel();
        PrefixDocumentFormat pm = doc.isPrefixOWLDocumentFormat() ? doc.asPrefixOWLDocumentFormat() : null;
        OntologyManagerImpl.setDefaultPrefix((PrefixManager)pm, ont);
        Map newPrefixes = pm != null ? pm.getPrefixName2PrefixMap() : Collections.emptyMap();
        Map initPrefixes = model.getNsPrefixMap();
        try {
            Models.setNsPrefixes((PrefixMapping)model, newPrefixes);
            RDFDataMgr.write((OutputStream)os, (Model)model, (Lang)format.getLang());
        }
        catch (JenaException e) {
            throw new OWLOntologyStorageException("Can't save " + ont.getOntologyID() + ". Format=" + (Object)((Object)format), (Throwable)e);
        }
        finally {
            Models.setNsPrefixes((PrefixMapping)model, initPrefixes);
        }
    }

    public static void setDefaultPrefix(PrefixManager pm, OWLOntology owl) {
        if (pm == null || owl == null) {
            return;
        }
        if (!(pm instanceof TurtleDocumentFormat)) {
            return;
        }
        if (pm.getDefaultPrefix() != null) {
            return;
        }
        if (!owl.getOntologyID().getOntologyIRI().isPresent()) {
            return;
        }
        String uri = ((IRI)owl.getOntologyID().getOntologyIRI().get()).getIRIString();
        if (!uri.endsWith("/")) {
            uri = uri + "#";
        }
        pm.setDefaultPrefix(uri);
    }

    private static OutputStream openStream(IRI iri) throws IOException {
        if (OntConfig.DefaultScheme.FILE.same(iri)) {
            File file = new File(iri.toURI());
            file.getParentFile().mkdirs();
            return new FileOutputStream(file);
        }
        URL url = iri.toURI().toURL();
        URLConnection conn = url.openConnection();
        return conn.getOutputStream();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.loaderConfig = (OntLoaderConfiguration)((Object)in.readObject());
        this.writerConfig = (OntWriterConfiguration)((Object)in.readObject());
        this.iris = CacheDataFactory.build(2048L, IRI::create);
        this.content.values().forEach(info -> {
            ModelConfig conf = info.getModelConfig();
            InternalModelHolder m = (InternalModelHolder)((Object)info.get());
            UnionGraph baseGraph = m.getBase().getGraph();
            Stream<UnionGraph> imports = Graphs.getImports((Graph)baseGraph).stream().map(s -> this.content.values().map(OntInfo::get).map(InternalModelHolder.class::cast).map(InternalModelHolder::getBase).map(UnionModel::getGraph).filter(g -> Objects.equals(s, Graphs.getURI((Graph)g))).findFirst().orElse(null)).filter(Objects::nonNull);
            imports.forEach(baseGraph::addGraph);
            InternalModel baseModel = InternalModelHolder.createInternalModel((Graph)baseGraph, conf);
            m.setBase(baseModel);
        });
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject((Object)this.getOntologyLoaderConfiguration());
        out.writeObject((Object)this.getOntologyWriterConfiguration());
    }

    public ModelConfig createModelConfig() {
        return new ModelConfig(this);
    }

    public static class ConcurrentConfig
    extends OntConfig {
        private static final long serialVersionUID = 5910609264963651991L;
        protected final ReadWriteLock lock;

        public ConcurrentConfig(ReadWriteLock lock) {
            this.lock = lock == null ? NoOpReadWriteLock.NO_OP_RW_LOCK : lock;
        }

        @Override
        protected Object get(OntConfig.OptionSetting key) {
            this.lock.readLock().lock();
            try {
                Object object = super.get(key);
                return object;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ConcurrentConfig put(OntConfig.OptionSetting key, Object value) {
            this.lock.writeLock().lock();
            try {
                super.put(key, value);
                ConcurrentConfig concurrentConfig = this;
                return concurrentConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public ConcurrentConfig setPersonality(OntPersonality p) {
            this.lock.writeLock().lock();
            try {
                super.setPersonality(p);
                ConcurrentConfig concurrentConfig = this;
                return concurrentConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public OntPersonality getPersonality() {
            this.lock.readLock().lock();
            try {
                OntPersonality ontPersonality = super.getPersonality();
                return ontPersonality;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public ConcurrentConfig setGraphTransformers(GraphTransformers.Store t) {
            this.lock.writeLock().lock();
            try {
                super.setGraphTransformers(t);
                ConcurrentConfig concurrentConfig = this;
                return concurrentConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public GraphTransformers.Store getGraphTransformers() {
            this.lock.readLock().lock();
            try {
                GraphTransformers.Store store = super.getGraphTransformers();
                return store;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntLoaderConfiguration buildLoaderConfiguration() {
            this.lock.readLock().lock();
            try {
                OntLoaderConfiguration ontLoaderConfiguration = super.buildLoaderConfiguration();
                return ontLoaderConfiguration;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntWriterConfiguration buildWriterConfiguration() {
            this.lock.readLock().lock();
            try {
                OntWriterConfiguration ontWriterConfiguration = super.buildWriterConfiguration();
                return ontWriterConfiguration;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public boolean equals(Object o) {
            this.lock.readLock().lock();
            try {
                boolean bl = super.equals(o);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public int hashCode() {
            this.lock.readLock().lock();
            try {
                int n = super.hashCode();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public static class ModelConfig
    implements InternalConfig,
    Serializable {
        private static final long serialVersionUID = 3681978037818003272L;
        protected OntLoaderConfiguration modelLoaderConf;
        protected OntWriterConfiguration modelWriterConf;
        protected OntologyManagerImpl manager;

        public ModelConfig(OntologyManagerImpl m) {
            this.manager = Objects.requireNonNull(m);
        }

        public OntologyManagerImpl getManager() {
            return this.manager;
        }

        public OntologyManagerImpl setManager(OntologyManagerImpl other) {
            OntologyManagerImpl res = this.manager;
            this.manager = other;
            return res;
        }

        public boolean hasLoaderConfig() {
            return this.modelLoaderConf != null;
        }

        public void setLoaderConf(OntLoaderConfiguration conf) {
            if (Objects.equals((Object)this.getLoaderConfig(), (Object)conf)) {
                return;
            }
            this.modelLoaderConf = conf;
        }

        public OntLoaderConfiguration getLoaderConfig() {
            return this.modelLoaderConf == null ? this.manager.getOntologyLoaderConfiguration() : this.modelLoaderConf;
        }

        public OntWriterConfiguration getWriterConfig() {
            return this.modelWriterConf == null ? this.manager.getOntologyWriterConfiguration() : this.modelWriterConf;
        }

        public InternalDataFactory getDataFactory() {
            return new CacheDataFactory(this.manager.getOWLDataFactory(), this.manager.iris, 2048);
        }

        public OntPersonality getPersonality() {
            return this.getLoaderConfig().getPersonality();
        }

        @Override
        public boolean isLoadAnnotationAxioms() {
            return this.getLoaderConfig().isLoadAnnotationAxioms();
        }

        @Override
        public boolean isAllowBulkAnnotationAssertions() {
            return this.getLoaderConfig().isAllowBulkAnnotationAssertions();
        }

        @Override
        public boolean isIgnoreAnnotationAxiomOverlaps() {
            return this.getLoaderConfig().isIgnoreAnnotationAxiomOverlaps();
        }

        @Override
        public boolean isAllowReadDeclarations() {
            return this.getLoaderConfig().isAllowReadDeclarations();
        }

        @Override
        public boolean isSplitAxiomAnnotations() {
            return this.getLoaderConfig().isSplitAxiomAnnotations();
        }

        @Override
        public boolean isIgnoreAxiomsReadErrors() {
            return this.getLoaderConfig().isIgnoreAxiomsReadErrors();
        }

        @Override
        public boolean parallel() {
            return this.manager.isConcurrent();
        }

        public boolean hasChanges(OntLoaderConfiguration other) {
            return ModelConfig.hasChanges(this.getLoaderConfig(), other);
        }

        public static boolean hasChanges(OntLoaderConfiguration left, OntLoaderConfiguration right) {
            if (left == null && right != null) {
                return true;
            }
            if (left != null && right == null) {
                return true;
            }
            if (left == right) {
                return false;
            }
            if (left.isLoadAnnotationAxioms() != right.isLoadAnnotationAxioms()) {
                return true;
            }
            if (left.isAllowBulkAnnotationAssertions() != right.isAllowBulkAnnotationAssertions()) {
                return true;
            }
            if (left.isIgnoreAnnotationAxiomOverlaps() != right.isIgnoreAnnotationAxiomOverlaps()) {
                return true;
            }
            if (left.isAllowReadDeclarations() != right.isAllowReadDeclarations()) {
                return true;
            }
            if (left.isSplitAxiomAnnotations() != right.isSplitAxiomAnnotations()) {
                return true;
            }
            return left.isIgnoreAxiomsReadErrors() != right.isIgnoreAxiomsReadErrors();
        }
    }

    public class OntInfo
    implements Serializable {
        private static final long serialVersionUID = 5894845199098931128L;
        protected final OntologyModel ont;
        protected final ModelConfig conf;
        protected IRI documentIRI;
        protected OWLImportsDeclaration declaration;
        protected OWLDocumentFormat format;

        public OntInfo(OntologyModel ont) throws ClassCastException {
            this.ont = ont;
            this.conf = (ModelConfig)((InternalModelHolder)((Object)ont)).getBase().getConfig();
        }

        @Nonnull
        public OWLOntologyID id() {
            return this.ont.getOntologyID();
        }

        public OntologyModel get() {
            return this.ont;
        }

        public OntInfo addFormat(OWLDocumentFormat format) {
            this.format = Objects.requireNonNull(format);
            return this;
        }

        public OntInfo addDocumentIRI(IRI iri) {
            this.documentIRI = Objects.requireNonNull(iri);
            return this;
        }

        public OntInfo addImportDeclaration(OWLImportsDeclaration declaration) {
            this.declaration = Objects.requireNonNull(declaration);
            return this;
        }

        @Nullable
        public IRI getDocumentIRI() {
            return this.documentIRI;
        }

        @Nullable
        public OWLDocumentFormat getFormat() {
            return this.format;
        }

        @Nonnull
        public ModelConfig getModelConfig() {
            return this.conf;
        }

        @Nullable
        public OWLImportsDeclaration getImportDeclaration() {
            return this.declaration != null ? this.declaration : (OWLImportsDeclaration)this.id().getOntologyIRI().map(arg_0 -> ((DataFactory)OntologyManagerImpl.this.dataFactory).getOWLImportsDeclaration(arg_0)).orElse(null);
        }
    }

    public class OntologyCollection
    implements Serializable {
        private static final long serialVersionUID = 3693502109998760296L;
        protected final Collection<OntInfo> map;

        public OntologyCollection(Collection<OntInfo> c) {
            this.map = c;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public void clear() {
            this.map.clear();
        }

        public Stream<OntInfo> values() {
            return this.map.stream();
        }

        public Stream<OWLOntologyID> keys() {
            return this.values().map(OntInfo::id);
        }

        public Optional<OntInfo> get(@Nonnull OWLOntologyID key) {
            return this.values().filter(o -> o.id().hashCode() == key.hashCode()).filter(o -> key.equals((Object)o.id())).findFirst();
        }

        public boolean contains(@Nonnull OWLOntologyID key) {
            return this.values().filter(o -> o.id().hashCode() == key.hashCode()).anyMatch(o -> key.equals((Object)o.id()));
        }

        public OntInfo add(OntologyModel o) {
            OntInfo res = new OntInfo(o);
            this.map.add(res);
            return res;
        }

        public Optional<OntInfo> remove(@Nonnull OWLOntologyID id) {
            Optional<OntInfo> res = this.get(id);
            res.ifPresent(this.map::remove);
            return res;
        }
    }

    protected static class ListenersHolder
    implements Serializable {
        private static final String BAD_LISTENER = "BADLY BEHAVING LISTENER: {} has been removed";
        private static final long serialVersionUID = 6728609023804778746L;
        protected final List<MissingImportListener> missingImportsListeners = new ArrayList<MissingImportListener>();
        protected final List<OWLOntologyLoaderListener> loaderListeners = new ArrayList<OWLOntologyLoaderListener>();
        protected final List<OWLOntologyChangeProgressListener> progressListeners = new ArrayList<OWLOntologyChangeProgressListener>();
        protected transient List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
        protected transient Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = new HashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
        protected transient Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = new HashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
        protected ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
        protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
        protected final AtomicInteger loadCount = new AtomicInteger();
        protected final AtomicInteger importsLoadCount = new AtomicInteger();
        protected final AtomicBoolean broadcastChanges = new AtomicBoolean(true);

        protected ListenersHolder() {
        }

        public void addMissingImportListener(@Nonnull MissingImportListener listener) {
            this.missingImportsListeners.add(listener);
        }

        public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
            this.missingImportsListeners.remove(listener);
        }

        public void addOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
            this.loaderListeners.add(listener);
        }

        public void removeOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
            this.loaderListeners.remove(listener);
        }

        public void addOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
            this.progressListeners.add(listener);
        }

        public void removeOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
            this.progressListeners.remove(listener);
        }

        public void addOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
            this.vetoListeners.add(listener);
        }

        public void removeOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
            this.vetoListeners.remove(listener);
        }

        public void setDefaultChangeBroadcastStrategy(@Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
            this.defaultChangeBroadcastStrategy = strategy;
        }

        public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
            this.addOntologyChangeListener(listener, this.defaultChangeBroadcastStrategy);
        }

        public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener, @Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
            this.listenerMap.put(listener, strategy);
        }

        public void removeOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
            this.listenerMap.remove(listener);
        }

        public void addImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
            this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
        }

        public void removeImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
            this.impendingChangeListenerMap.remove(listener);
        }

        protected int incrementImportsLoadCount() {
            return this.importsLoadCount.incrementAndGet();
        }

        protected int decrementImportsLoadCount() {
            return this.importsLoadCount.decrementAndGet();
        }

        protected void fireMissingImportEvent(MissingImportEvent evt) {
            this.missingImportsListeners.forEach(l -> l.importMissing(evt));
        }

        protected void fireStartedLoadingEvent(OWLOntologyID id, IRI doc, boolean imported) {
            for (OWLOntologyLoaderListener listener : this.loaderListeners) {
                listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(id, doc, imported));
            }
        }

        protected void fireStartedLoadingEvent(OWLOntologyID id, IRI doc) {
            if (this.loadCount.get() != this.importsLoadCount.get()) {
                LOGGER.debug("[{} => {}] Runtime Warning: Parsers should load imported ontologies using the makeImportLoadRequest method.", (Object)doc, (Object)id);
            }
            this.fireStartedLoadingEvent(id, doc, this.loadCount.get() > 0);
            this.loadCount.incrementAndGet();
            this.broadcastChanges.set(false);
        }

        protected void fireFinishedLoadingEvent(OWLOntologyID id, IRI doc, boolean imported, @Nullable Exception ex) {
            for (OWLOntologyLoaderListener listener : this.loaderListeners) {
                listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(id, doc, imported, ex));
            }
        }

        protected void fireFinishedLoadingEvent(OWLOntologyID id, IRI doc, @Nullable Exception ex) {
            if (this.loadCount.decrementAndGet() == 0) {
                this.broadcastChanges.set(true);
            }
            this.fireFinishedLoadingEvent(id, doc, this.loadCount.get() > 0, ex);
        }

        protected void fireBeginChanges(int size) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.begin(size);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void fireEndChanges() {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.end();
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void fireChangeApplied(OWLOntologyChange change) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            if (this.progressListeners.isEmpty()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.appliedChange(change);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void broadcastOntologyChangesVetoed(List<? extends OWLOntologyChange> changes, OWLOntologyChangeVetoException veto) {
            this.vetoListeners.forEach(l -> l.ontologyChangesVetoed(changes, veto));
        }

        protected void broadcastChanges(List<? extends OWLOntologyChange> changes) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
                OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
                if (strategy == null) continue;
                try {
                    strategy.broadcastChanges(listener, changes);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.listenerMap.remove(listener);
                }
            }
        }

        protected void broadcastImpendingChanges(List<? extends OWLOntologyChange> changes) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
                ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
                if (strategy == null) continue;
                strategy.broadcastChanges(listener, changes);
            }
        }

        public void clear() {
            this.loaderListeners.clear();
            this.missingImportsListeners.clear();
            this.progressListeners.clear();
            this.vetoListeners.clear();
            this.listenerMap.clear();
            this.impendingChangeListenerMap.clear();
            this.broadcastChanges.set(true);
            this.loadCount.set(0);
            this.importsLoadCount.set(0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.listenerMap = new HashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
            this.impendingChangeListenerMap = new HashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
            this.vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
        }
    }
}

