/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import ru.avicomp.ontapi.InternalModelHolder;
import ru.avicomp.ontapi.OWLOntologyWrapper;
import ru.avicomp.ontapi.OntBaseModelImpl;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.internal.InternalModel;
import ru.avicomp.ontapi.jena.RWLockedGraph;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.utils.Graphs;

public class OntologyModelImpl
extends OntBaseModelImpl
implements OntologyModel {
    private static final long serialVersionUID = -2882895355499914294L;
    protected transient ChangeProcessor changer;

    protected OntologyModelImpl(Graph graph, OntologyManagerImpl.ModelConfig config) {
        super(graph, config);
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return (ChangeApplied)change.accept((OWLOntologyChangeVisitorEx)this.getChangeProcessor());
    }

    @Override
    public OntologyManagerImpl getOWLOntologyManager() {
        return (OntologyManagerImpl)super.getOWLOntologyManager();
    }

    protected ChangeProcessor getChangeProcessor() {
        return this.changer == null ? (this.changer = new ChangeProcessor()) : this.changer;
    }

    @Override
    public void clearCache() {
        this.getBase().clearCache();
    }

    @Override
    public OntGraphModel asGraphModel() {
        return this.getBase();
    }

    public static class Concurrent
    extends OWLOntologyWrapper
    implements OntologyModel,
    InternalModelHolder {
        private static final long serialVersionUID = 5823394836022970162L;

        protected Concurrent(OntologyModelImpl delegate, ReadWriteLock lock) {
            super(delegate, lock);
        }

        public OntologyModelImpl delegate() {
            return (OntologyModelImpl)this.delegate;
        }

        @Override
        public OntGraphModel asGraphModel() {
            this.lock.readLock().lock();
            try {
                OntGraphModel ontGraphModel = this.makeGraphModel();
                return ontGraphModel;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        protected OntGraphModel makeGraphModel() {
            InternalModel base = this.getBase();
            final OntPersonality p = base.getPersonality();
            UnionGraph orig = base.getGraph();
            UnionGraph copy = new UnionGraph(new RWLockedGraph(orig.getBaseGraph(), this.lock), orig.getUnderlying(), orig.getEventManager());
            return new OntGraphModelImpl((Graph)copy, p){

                @Override
                public OntGraphModelImpl addImport(OntGraphModel m) {
                    return super.addImport(this.asNonConcurrent(m));
                }

                @Override
                public OntGraphModelImpl removeImport(OntGraphModel m) {
                    return super.removeImport(this.asNonConcurrent(m));
                }

                private OntGraphModel asNonConcurrent(OntGraphModel m) {
                    return new OntGraphModelImpl(Graphs.asNonConcurrent(m.getGraph()), p);
                }
            };
        }

        @Override
        public void clearCache() {
            this.lock.readLock().lock();
            try {
                this.delegate().clearCache();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntologyManager getOWLOntologyManager() {
            return (OntologyManager)super.getOWLOntologyManager();
        }

        @Override
        public InternalModel getBase() {
            return this.delegate().getBase();
        }

        @Override
        public void setBase(InternalModel m) {
            this.delegate().setBase(m);
        }
    }

    protected class ChangeProcessor
    implements OWLOntologyChangeVisitorEx<ChangeApplied> {
        protected ChangeProcessor() {
        }

        public ChangeApplied visit(@Nonnull AddAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (OntologyModelImpl.this.containsAxiom(axiom)) {
                return ChangeApplied.NO_OPERATION;
            }
            OntologyModelImpl.this.getBase().add(axiom);
            return ChangeApplied.SUCCESSFULLY;
        }

        public ChangeApplied visit(@Nonnull RemoveAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (OntologyModelImpl.this.containsAxiom(axiom)) {
                OntologyModelImpl.this.getBase().remove(axiom);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull AddImport change) {
            OWLImportsDeclaration importDeclaration = change.getImportDeclaration();
            if (OntologyModelImpl.this.importsDeclarations().noneMatch(importDeclaration::equals)) {
                this.addImport(importDeclaration);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull RemoveImport change) {
            OWLImportsDeclaration importDeclaration = change.getImportDeclaration();
            if (OntologyModelImpl.this.importsDeclarations().anyMatch(importDeclaration::equals)) {
                this.removeImport(importDeclaration);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull AddOntologyAnnotation change) {
            OWLAnnotation annotation = change.getAnnotation();
            if (OntologyModelImpl.this.annotations().noneMatch(annotation::equals)) {
                OntologyModelImpl.this.getBase().add(annotation);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull RemoveOntologyAnnotation change) {
            OWLAnnotation annotation = change.getAnnotation();
            if (OntologyModelImpl.this.annotations().anyMatch(annotation::equals)) {
                OntologyModelImpl.this.getBase().remove(annotation);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (OntologyModelImpl.this.getOntologyID().equals((Object)id)) {
                return ChangeApplied.NO_OPERATION;
            }
            OntologyModelImpl.this.setOntologyID(id);
            return ChangeApplied.SUCCESSFULLY;
        }

        protected void addImport(OWLImportsDeclaration declaration) {
            OntologyModel ont = OntologyModelImpl.this.getOWLOntologyManager().getImportedOntology(declaration);
            if (ont == null) {
                OntologyModelImpl.this.getBase().getID().addImport(declaration.getIRI().getIRIString());
                return;
            }
            OntologyModelImpl.this.getBase().addImport(((InternalModelHolder)((Object)ont)).getBase());
        }

        protected void removeImport(OWLImportsDeclaration declaration) {
            OntologyModel ont = OntologyModelImpl.this.getOWLOntologyManager().getImportedOntology(declaration);
            OntologyModelImpl.this.getBase().getID().removeImport(declaration.getIRI().getIRIString());
            if (ont == null) {
                return;
            }
            OntologyModelImpl.this.getBase().removeImport(((InternalModelHolder)((Object)ont)).getBase());
        }
    }
}

