/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class OwlObjects {
    public static <O extends OWLObject> Stream<O> parseComponents(Class<O> view, HasComponents structure) {
        return structure.componentsWithoutAnnotations().map(o -> OwlObjects.toStream(view, o)).flatMap(Function.identity());
    }

    public static <O extends OWLObject> Stream<O> parseAnnotations(Class<O> view, HasAnnotations structure) {
        return structure.annotations().map(o -> OwlObjects.toStream(view, o)).flatMap(Function.identity());
    }

    public static <O extends OWLObject, A extends HasAnnotations & HasComponents> Stream<O> objects(Class<O> view, A container) {
        return Stream.concat(OwlObjects.parseComponents(view, container), OwlObjects.parseAnnotations(view, container));
    }

    public static <A extends HasAnnotations & HasComponents> Stream<IRI> iris(A container) {
        return Stream.concat(OwlObjects.objects(IRI.class, container), OwlObjects.objects(OWLObject.class, container).filter(HasIRI.class::isInstance).map(HasIRI.class::cast).map(HasIRI::getIRI));
    }

    private static <O extends OWLObject> Stream<O> toStream(Class<O> view, Object o) {
        if (view.isInstance(o)) {
            return Stream.of(view.cast(o));
        }
        if (o instanceof HasComponents) {
            if (o instanceof HasAnnotations) {
                return OwlObjects.objects(view, (HasComponents)((HasAnnotations)((HasComponents)o)));
            }
            return OwlObjects.parseComponents(view, (HasComponents)o);
        }
        if (o instanceof HasAnnotations) {
            return OwlObjects.parseAnnotations(view, (HasAnnotations)o);
        }
        Stream stream = null;
        if (o instanceof Stream) {
            stream = (Stream)o;
        } else if (o instanceof Collection) {
            stream = ((Collection)o).stream();
        }
        if (stream != null) {
            return stream.map(x -> OwlObjects.toStream(view, x)).flatMap(Function.identity());
        }
        return Stream.empty();
    }
}

