/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.config;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.config.OntSettings;
import ru.avicomp.ontapi.config.OntWriterConfiguration;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.OntModelConfig;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.transforms.GraphTransformers;

public class OntConfig
extends OntologyConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntConfig.class);
    private static final long serialVersionUID = 656765031127374396L;
    protected final Map<OptionSetting, Object> map = new HashMap<OptionSetting, Object>();
    protected transient OntPersonality personality;
    protected GraphTransformers.Store transformers;

    protected Object get(OptionSetting key) {
        return key.fromMap(this.map);
    }

    protected OntConfig put(OptionSetting key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public OntConfig setPersonality(OntPersonality p) {
        this.personality = OntApiException.notNull(p, "Null personality.");
        return this;
    }

    public OntPersonality getPersonality() {
        return this.personality == null ? (this.personality = OntConfig.getDefaultPersonality()) : this.personality;
    }

    public OntConfig setGraphTransformers(GraphTransformers.Store t) {
        this.transformers = OntApiException.notNull(t, "Null graph transformer store.");
        return this;
    }

    public GraphTransformers.Store getGraphTransformers() {
        return this.transformers == null ? (this.transformers = OntConfig.getDefaultTransformers()) : this.transformers;
    }

    public List<Scheme> getSupportedSchemes() {
        return (List)this.get(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES);
    }

    public OntConfig setSupportedSchemes(List<Scheme> schemes) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES, schemes instanceof Serializable ? schemes : new ArrayList(schemes));
    }

    public OntConfig disableWebAccess() {
        return this.setSupportedSchemes(Collections.singletonList(DefaultScheme.FILE));
    }

    public boolean isPerformTransformation() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS);
    }

    public OntConfig setPerformTransformation(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS, b);
    }

    public boolean isAllowBulkAnnotationAssertions() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS);
    }

    public OntConfig setAllowBulkAnnotationAssertions(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS, b);
    }

    public boolean isAllowReadDeclarations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS);
    }

    public OntConfig setAllowReadDeclarations(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS, b);
    }

    public boolean isIgnoreAnnotationAxiomOverlaps() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS);
    }

    public OntConfig setIgnoreAnnotationAxiomOverlaps(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS, b);
    }

    public boolean isUseOWLParsersToLoad() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD);
    }

    public OntConfig setUseOWLParsersToLoad(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD, b);
    }

    public boolean isIgnoreAxiomsReadErrors() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS);
    }

    public OntConfig setIgnoreAxiomsReadErrors(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS, b);
    }

    public boolean isSplitAxiomAnnotations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS);
    }

    public OntConfig setSplitAxiomAnnotations(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS, b);
    }

    public boolean isControlImports() {
        return (Boolean)this.get(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS);
    }

    public OntConfig setControlImports(boolean b) {
        return this.put(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS, b);
    }

    public OntConfig setLoadAnnotationAxioms(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, b);
    }

    public boolean shouldLoadAnnotations() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS);
    }

    public OntConfig withEntityExpansionLimit(@Nonnull String s) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, s);
    }

    public String getEntityExpansionLimit() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT);
    }

    public OntConfig withBannedParsers(@Nonnull String parsers) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, parsers);
    }

    public String getBannedParsers() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS);
    }

    public OntConfig setPriorityCollectionSorting(@Nonnull PriorityCollectionSorting sorting) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, sorting);
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return (PriorityCollectionSorting)this.get(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING);
    }

    protected List<String> getIgnoredImports() {
        return (List)this.map.computeIfAbsent(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, OptionSetting::getDefaultValue);
    }

    public OntConfig addIgnoredImport(@Nonnull IRI iri) {
        if (!this.getIgnoredImports().contains(iri.getIRIString())) {
            this.getIgnoredImports().add(iri.getIRIString());
        }
        return this;
    }

    public OntConfig clearIgnoredImports() {
        this.getIgnoredImports().clear();
        return this;
    }

    public OntConfig removeIgnoredImport(@Nonnull IRI iri) {
        this.getIgnoredImports().remove(iri.getIRIString());
        return this;
    }

    public OntConfig setAcceptingHTTPCompression(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, b);
    }

    public boolean shouldAcceptHTTPCompression() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION);
    }

    public OntConfig setConnectionTimeout(int t) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, t);
    }

    public int getConnectionTimeout() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT);
    }

    public OntConfig setFollowRedirects(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, b);
    }

    public boolean shouldFollowRedirects() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS);
    }

    public OntConfig setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy strategy) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, strategy);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return (MissingImportHandlingStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY);
    }

    public OntConfig setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy strategy) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, strategy);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return (MissingOntologyHeaderStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY);
    }

    public OntConfig setReportStackTraces(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, b);
    }

    public boolean shouldReportStackTraces() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES);
    }

    public OntConfig setRetriesToAttempt(int retries) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, retries);
    }

    public int getRetriesToAttempt() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT);
    }

    public OntConfig setStrict(boolean strict) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, strict);
    }

    public boolean shouldParseWithStrictConfiguration() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION);
    }

    public OntConfig setTreatDublinCoreAsBuiltIn(boolean value) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, value);
    }

    public boolean shouldTreatDublinCoreAsBuiltin() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN);
    }

    public OntConfig withSaveIdsForAllAnonymousIndividuals(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, b);
    }

    public boolean shouldSaveIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS);
    }

    public OntConfig withRemapAllAnonymousIndividualsIds(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, b);
    }

    public boolean shouldRemapIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS);
    }

    public OntConfig withUseNamespaceEntities(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, b);
    }

    public boolean shouldUseNamespaceEntities() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES);
    }

    public OntConfig withIndenting(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, b);
    }

    public boolean shouldIndent() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_INDENTING);
    }

    public OntConfig withIndentSize(int indent) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, indent);
    }

    public int getIndentSize() {
        return (Integer)this.get(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE);
    }

    public OntConfig withLabelsAsBanner(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, b);
    }

    public boolean shouldUseLabelsAsBanner() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER);
    }

    public OntConfig withBannersEnabled(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, b);
    }

    public boolean shouldUseBanners() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED);
    }

    public boolean shouldRepairIllegalPunnings() {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return true;
    }

    public OntConfig withRepairIllegalPunnings(boolean b) {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return this;
    }

    public OntLoaderConfiguration buildLoaderConfiguration() {
        OntLoaderConfiguration res = new OntLoaderConfiguration(null);
        res.personality = this.getPersonality();
        res.transformers = this.getGraphTransformers();
        for (OntSettings s : OntSettings.values()) {
            if (!s.isLoad()) continue;
            res.map.put(s, this.get(s));
        }
        return res;
    }

    public OntWriterConfiguration buildWriterConfiguration() {
        OntWriterConfiguration res = new OntWriterConfiguration(null);
        for (OntSettings s : OntSettings.values()) {
            if (!s.isWrite()) continue;
            res.map.put(s, this.get(s));
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntConfig)) {
            return false;
        }
        OntConfig that = (OntConfig)((Object)o);
        return Objects.equals((Object)this.getPersonality(), (Object)that.getPersonality()) && Objects.equals(this.getGraphTransformers(), that.getGraphTransformers()) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPersonality(), this.getGraphTransformers(), this.map});
    }

    public static OntConfig copy(OntologyConfigurator from) {
        OntConfig res = new OntConfig();
        if (from == null) {
            return res;
        }
        if (from instanceof OntConfig) {
            res.map.putAll(((OntConfig)from).map);
            res.setPersonality(((OntConfig)from).getPersonality());
            res.setGraphTransformers(((OntConfig)from).getGraphTransformers());
            return res;
        }
        res.map.put(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, new ArrayList<IRI>(OntConfig.ignoredImports(from)));
        res.map.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, from.shouldAcceptHTTPCompression());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, from.getConnectionTimeout());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, from.shouldFollowRedirects());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, from.shouldLoadAnnotations());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, from.getMissingImportHandlingStrategy());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, from.getMissingOntologyHeaderStrategy());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, from.shouldReportStackTraces());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, from.getRetriesToAttempt());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, from.shouldParseWithStrictConfiguration());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, from.shouldTreatDublinCoreAsBuiltin());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, from.getPriorityCollectionSorting());
        res.map.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, from.getBannedParsers());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, from.shouldSaveIds());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, from.shouldRemapIds());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, from.shouldUseNamespaceEntities());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, from.shouldIndent());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, from.shouldUseLabelsAsBanner());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, from.shouldUseBanners());
        res.map.put(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, from.getIndentSize());
        return res;
    }

    protected static Set<IRI> ignoredImports(OntologyConfigurator owl) {
        try {
            Field field = owl.getClass().getDeclaredField("ignoredImports");
            field.setAccessible(true);
            return (Set)field.get(owl);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new OntApiException("Can't get OntologyConfigurator#ignoredImports.", e);
        }
    }

    public static OntPersonality getDefaultPersonality() {
        Configurable.Mode mode = (Configurable.Mode)OntSettings.ONT_API_LOAD_CONF_PERSONALITY_MODE.getDefaultValue();
        if (!(mode instanceof OntModelConfig.StdMode)) {
            throw new OntApiException.Unsupported("Not supported: " + mode);
        }
        switch ((OntModelConfig.StdMode)mode) {
            case LAX: {
                return OntModelConfig.ONT_PERSONALITY_LAX;
            }
            case MEDIUM: {
                return OntModelConfig.ONT_PERSONALITY_MEDIUM;
            }
            case STRICT: {
                return OntModelConfig.ONT_PERSONALITY_STRICT;
            }
        }
        throw new OntApiException("Unsupported personality mode " + mode);
    }

    public static GraphTransformers.Store getDefaultTransformers() {
        List transformers = (List)((Object)OntSettings.ONT_API_LOAD_CONF_TRANSFORMERS.getDefaultValue());
        GraphTransformers.Store res = new GraphTransformers.Store();
        for (Class c : transformers) {
            res = res.add(new GraphTransformers.DefaultMaker(c));
        }
        return res;
    }

    @FunctionalInterface
    public static interface OptionSetting {
        public Serializable getDefaultValue();

        default public Object fromMap(Map<OptionSetting, Object> map) {
            Object res = map.get(this);
            if (res != null) {
                return res;
            }
            return this.getDefaultValue();
        }
    }

    @FunctionalInterface
    public static interface Scheme
    extends Serializable {
        public String key();

        default public boolean same(IRI iri) {
            return iri != null && Objects.equals(this.key(), iri.getScheme());
        }
    }

    public static enum DefaultScheme implements Scheme
    {
        HTTP,
        HTTPS,
        FTP,
        FILE;


        @Override
        public String key() {
            return this.name().toLowerCase();
        }

        public static Stream<DefaultScheme> all() {
            return Stream.of(DefaultScheme.values());
        }
    }
}

