/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public abstract class AbstractListBasedTranslator<Axiom extends OWLLogicalAxiom, ONT_SUBJECT extends OntObject, OWL_SUBJECT extends OWLObject, ONT_MEMBER extends OntObject, OWL_MEMBER extends OWLObject>
extends AxiomTranslator<Axiom> {
    abstract OWLObject getSubject(Axiom var1);

    abstract Property getPredicate();

    abstract Stream<? extends OWLObject> getObjects(Axiom var1);

    abstract Class<ONT_SUBJECT> getView();

    @Override
    public void write(Axiom axiom, OntGraphModel model) {
        WriteHelper.writeList(model, this.getSubject(axiom), this.getPredicate(), this.getObjects(axiom), axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, this.getPredicate(), null).filterKeep(this::filter);
    }

    protected boolean filter(OntStatement statement) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(RDFList.class);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return this.getPredicate().equals(statement.getPredicate()) && this.filter(statement);
    }

    ONTObject<Axiom> makeAxiom(OntStatement statement, Function<ONT_SUBJECT, ONTObject<? extends OWL_SUBJECT>> subjectExtractor, BiFunction<ONT_SUBJECT, RDFNode, Optional<OntList<ONT_MEMBER>>> listExtractor, Function<ONT_MEMBER, ONTObject<? extends OWL_MEMBER>> memberExtractor, Collector<ONTObject<? extends OWL_MEMBER>, ?, ? extends Collection<ONTObject<? extends OWL_MEMBER>>> collector, BiFunction<ONTObject<? extends OWL_SUBJECT>, Collection<ONTObject<? extends OWL_MEMBER>>, Axiom> axiomMaker) {
        OntObject ontSubject = (OntObject)statement.getSubject(this.getView());
        ONTObject<? extends OWL_SUBJECT> subject = subjectExtractor.apply(ontSubject);
        OntList list = listExtractor.apply(ontSubject, statement.getObject()).orElseThrow(() -> new OntApiException("Can't get OntList for statement " + Models.toString(statement)));
        Collection<ONTObject<? extends OWL_MEMBER>> members = list.members().map(memberExtractor).collect(collector);
        OWLLogicalAxiom res = (OWLLogicalAxiom)axiomMaker.apply(subject, members);
        return ONTObject.create(res, statement).append(() -> list.spec().map(FrontsTriple::asTriple));
    }
}

