/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public abstract class AbstractSubPropertyTranslator<Axiom extends OWLAxiom, P extends OntPE>
extends AxiomTranslator<Axiom> {
    abstract OWLPropertyExpression getSubProperty(Axiom var1);

    abstract OWLPropertyExpression getSuperProperty(Axiom var1);

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, RDFS.subPropertyOf, null).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return RDFS.subPropertyOf.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    @Override
    public void write(Axiom axiom, OntGraphModel model) {
        WriteHelper.writeTriple(model, (OWLObject)this.getSubProperty(axiom), RDFS.subPropertyOf, (OWLObject)this.getSuperProperty(axiom), (Stream<OWLAnnotation>)axiom.annotations());
    }
}

