/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.internal.AbstractNaryTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntDisjoint;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public abstract class AbstractTwoWayNaryTranslator<Axiom extends OWLAxiom & OWLNaryAxiom<OWL>, OWL extends OWLObject & IsAnonymous, ONT extends OntObject>
extends AbstractNaryTranslator<Axiom, OWL, ONT> {
    @Override
    public void write(Axiom axiom, OntGraphModel model) {
        Set operands = ((OWLNaryAxiom)axiom).operands().collect(Collectors.toSet());
        Set<OWLAnnotation> annotations = axiom.annotations().collect(Collectors.toSet());
        if (operands.isEmpty() && annotations.isEmpty()) {
            return;
        }
        if (operands.size() == 2) {
            this.write((OWLNaryAxiom)axiom, annotations, model);
        } else {
            Resource root = model.createResource();
            model.add(root, RDF.type, (RDFNode)this.getMembersType());
            model.add(root, this.getMembersPredicate(), (RDFNode)WriteHelper.addRDFList(model, operands.stream()));
            OntDisjoint res = (OntDisjoint)root.as(this.getDisjointView());
            WriteHelper.addAnnotations(res, annotations.stream());
        }
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return super.listStatements(model, config).andThen((Iterator)Models.listOntObjects(model, this.getDisjointView()).mapWith(OntObject::getRoot));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return super.testStatement(statement, config) || RDF.type.equals(statement.getPredicate()) && statement.getSubject().canAs(this.getDisjointView());
    }

    abstract Resource getMembersType();

    abstract Property getMembersPredicate();

    abstract Class<? extends OntDisjoint<ONT>> getDisjointView();

    ONTObject<Axiom> makeAxiom(OntStatement statement, Collection<ONTObject<OWLAnnotation>> annotations, Function<ONT, ONTObject<? extends OWL>> membersExtractor, BiFunction<Collection<ONTObject<? extends OWL>>, Collection<ONTObject<OWLAnnotation>>, Axiom> creator) {
        Collection members;
        OntObject subject = statement.getSubject();
        OntDisjoint disjoint = null;
        if (subject.canAs(this.getDisjointView())) {
            disjoint = (OntDisjoint)subject.as(this.getDisjointView());
            members = disjoint.members().map(membersExtractor).collect(Collectors.toSet());
        } else {
            members = Stream.of(subject, statement.getObject()).map(r -> (OntObject)r.as(this.getView())).map(membersExtractor).collect(Collectors.toSet());
        }
        OWLAxiom axiom = (OWLAxiom)creator.apply(members, annotations);
        return (disjoint != null ? ONTObject.create(axiom, disjoint) : ONTObject.create(axiom, statement)).append(annotations).appendWildcards(members);
    }
}

