/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class ClassAssertionTranslator
extends AxiomTranslator<OWLClassAssertionAxiom> {
    @Override
    public void write(OWLClassAssertionAxiom axiom, OntGraphModel model) {
        OntCE ce = WriteHelper.addClassExpression(model, axiom.getClassExpression());
        OWLIndividual individual = axiom.getIndividual();
        OntIndividual subject = individual.isAnonymous() ? (OntObject)WriteHelper.toResource((OWLObject)individual).inModel((Model)model).as(OntObject.class) : WriteHelper.addIndividual(model, individual);
        OntStatement statement = subject.addStatement(RDF.type, (RDFNode)ce);
        WriteHelper.addAnnotations(statement, (Stream<OWLAnnotation>)axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, RDF.type, null).filterKeep(s -> s.getObject().canAs(OntCE.class) && s.getSubject().canAs(OntIndividual.class));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.isDeclaration() && statement.getObject().canAs(OntCE.class) && statement.getSubject().canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLClassAssertionAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<? extends OWLIndividual> i = reader.get(statement.getSubject(OntIndividual.class));
        ONTObject<? extends OWLClassExpression> ce = reader.get((OntCE)statement.getObject().as(OntCE.class));
        Collection annotations = reader.get(statement, config);
        OWLClassAssertionAxiom res = reader.getOWLDataFactory().getOWLClassAssertionAxiom(ce.getObject(), i.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(i).append(ce);
    }
}

