/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class DeclarationTranslator
extends AxiomTranslator<OWLDeclarationAxiom> {
    @Override
    public void write(OWLDeclarationAxiom axiom, OntGraphModel model) {
        WriteHelper.writeDeclarationTriple(model, axiom.getEntity(), RDF.type, (RDFNode)WriteHelper.getType(axiom.getEntity()), axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        if (!config.isAllowReadDeclarations()) {
            return NullIterator.instance();
        }
        return Models.listEntities(model).mapWith(OntObject::getRoot);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        if (!statement.getSubject().isURIResource()) {
            return false;
        }
        if (!statement.getObject().isURIResource()) {
            return false;
        }
        if (!statement.isDeclaration()) {
            return false;
        }
        return Entities.find(statement.getResource()).map(Entities::getClassType).map(t -> statement.getModel().getOntEntity(t, statement.getSubject())).isPresent();
    }

    @Override
    public ONTObject<OWLDeclarationAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        OntEntity e = Entities.find(statement.getResource()).map(Entities::getClassType).map(t -> statement.getModel().getOntEntity(t, statement.getSubject())).orElseThrow(() -> new OntJenaException.IllegalArgument("Can't find entity by the statement " + statement));
        ONTObject<? extends OWLEntity> entity = reader.get(e);
        Collection annotations = reader.get(statement, config);
        OWLDeclarationAxiom res = reader.getOWLDataFactory().getOWLDeclarationAxiom(entity.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations);
    }
}

