/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.EnumMap;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;

public interface InternalConfig {
    public static final InternalConfig DEFAULT = InternalConfig.createFrom(new OntConfig().buildLoaderConfiguration());

    public boolean isLoadAnnotationAxioms();

    public boolean isAllowBulkAnnotationAssertions();

    public boolean isIgnoreAnnotationAxiomOverlaps();

    public boolean isAllowReadDeclarations();

    public boolean isSplitAxiomAnnotations();

    public boolean isIgnoreAxiomsReadErrors();

    default public boolean parallel() {
        return false;
    }

    default public InternalConfig snapshot() {
        return new Snapshot(this);
    }

    public static InternalConfig createFrom(final OntLoaderConfiguration conf) {
        return new InternalConfig(){

            @Override
            public boolean isLoadAnnotationAxioms() {
                return conf.isLoadAnnotationAxioms();
            }

            @Override
            public boolean isAllowBulkAnnotationAssertions() {
                return conf.isAllowBulkAnnotationAssertions();
            }

            @Override
            public boolean isIgnoreAnnotationAxiomOverlaps() {
                return conf.isIgnoreAnnotationAxiomOverlaps();
            }

            @Override
            public boolean isAllowReadDeclarations() {
                return conf.isAllowReadDeclarations();
            }

            @Override
            public boolean isSplitAxiomAnnotations() {
                return conf.isSplitAxiomAnnotations();
            }

            @Override
            public boolean isIgnoreAxiomsReadErrors() {
                return conf.isIgnoreAxiomsReadErrors();
            }
        };
    }

    public static class Snapshot
    implements InternalConfig {
        private final EnumMap<Key, Boolean> map = new EnumMap(Key.class);

        Snapshot(InternalConfig delegate) {
            this.map.put(Key.LOAD_ANNOTATIONS, delegate.isLoadAnnotationAxioms());
            this.map.put(Key.ALLOW_DECLARATION_BULK_ANNOTATIONS, delegate.isAllowBulkAnnotationAssertions());
            this.map.put(Key.IGNORE_ANNOTATION_OVERLAPS, delegate.isIgnoreAnnotationAxiomOverlaps());
            this.map.put(Key.ALLOW_DECLARATIONS, delegate.isAllowReadDeclarations());
            this.map.put(Key.SPLIT_AXIOM_ANNOTATIONS, delegate.isSplitAxiomAnnotations());
            this.map.put(Key.IGNORE_READ_ERRORS, delegate.isIgnoreAxiomsReadErrors());
        }

        @Override
        public boolean isLoadAnnotationAxioms() {
            return this.map.get((Object)Key.LOAD_ANNOTATIONS);
        }

        @Override
        public boolean isAllowBulkAnnotationAssertions() {
            return this.map.get((Object)Key.ALLOW_DECLARATION_BULK_ANNOTATIONS);
        }

        @Override
        public boolean isIgnoreAnnotationAxiomOverlaps() {
            return this.map.get((Object)Key.IGNORE_ANNOTATION_OVERLAPS);
        }

        @Override
        public boolean isAllowReadDeclarations() {
            return this.map.get((Object)Key.ALLOW_DECLARATIONS);
        }

        @Override
        public boolean isSplitAxiomAnnotations() {
            return this.map.get((Object)Key.SPLIT_AXIOM_ANNOTATIONS);
        }

        @Override
        public boolean isIgnoreAxiomsReadErrors() {
            return this.map.get((Object)Key.IGNORE_READ_ERRORS);
        }

        @Override
        public InternalConfig snapshot() {
            return this;
        }

        private static enum Key {
            LOAD_ANNOTATIONS,
            ALLOW_DECLARATION_BULK_ANNOTATIONS,
            IGNORE_ANNOTATION_OVERLAPS,
            ALLOW_DECLARATIONS,
            SPLIT_AXIOM_ANNOTATIONS,
            IGNORE_READ_ERRORS;

        }
    }
}

