/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class InverseObjectPropertiesTranslator
extends AxiomTranslator<OWLInverseObjectPropertiesAxiom> {
    @Override
    public void write(OWLInverseObjectPropertiesAxiom axiom, OntGraphModel model) {
        WriteHelper.writeTriple(model, (OWLObject)axiom.getFirstProperty(), OWL.inverseOf, (OWLObject)axiom.getSecondProperty(), (Stream<OWLAnnotation>)axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, OWL.inverseOf, null).filterDrop(s -> s.getSubject().isAnon() && s.getObject().isURIResource());
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        if (!OWL.inverseOf.equals(statement.getPredicate())) {
            return false;
        }
        if (statement.getSubject().isAnon() && statement.getObject().isURIResource()) {
            return false;
        }
        return statement.getSubject().canAs(OntOPE.class) && statement.getObject().canAs(OntOPE.class);
    }

    @Override
    public ONTObject<OWLInverseObjectPropertiesAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<? extends OWLObjectPropertyExpression> f = reader.get(statement.getSubject(OntOPE.class));
        ONTObject<? extends OWLObjectPropertyExpression> s = reader.get((OntOPE)statement.getObject().as(OntOPE.class));
        Collection annotations = reader.get(statement, config);
        OWLInverseObjectPropertiesAxiom res = reader.getOWLDataFactory().getOWLInverseObjectPropertiesAxiom(f.getObject(), s.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(f).append(s);
    }
}

