/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.internal.NoCacheDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;

public class MapDataFactory
extends NoCacheDataFactory {
    private Map<OntClass, ONTObject<OWLClass>> classes = new HashMap<OntClass, ONTObject<OWLClass>>();
    private Map<OntDT, ONTObject<OWLDatatype>> datatypes = new HashMap<OntDT, ONTObject<OWLDatatype>>();
    private Map<OntNAP, ONTObject<OWLAnnotationProperty>> annotationProperties = new HashMap<OntNAP, ONTObject<OWLAnnotationProperty>>();
    private Map<OntNDP, ONTObject<OWLDataProperty>> datatypeProperties = new HashMap<OntNDP, ONTObject<OWLDataProperty>>();
    private Map<OntNOP, ONTObject<OWLObjectProperty>> objectProperties = new HashMap<OntNOP, ONTObject<OWLObjectProperty>>();
    private Map<OntIndividual.Named, ONTObject<OWLNamedIndividual>> individuals = new HashMap<OntIndividual.Named, ONTObject<OWLNamedIndividual>>();
    private Map<Literal, ONTObject<OWLLiteral>> literals = new HashMap<Literal, ONTObject<OWLLiteral>>();

    public MapDataFactory(DataFactory factory) {
        super(factory);
    }

    @Override
    public void clear() {
        this.classes.clear();
        this.datatypes.clear();
        this.annotationProperties.clear();
        this.objectProperties.clear();
        this.datatypeProperties.clear();
        this.individuals.clear();
        this.literals.clear();
    }

    @Override
    public ONTObject<OWLClass> get(OntClass ce) {
        return this.classes.computeIfAbsent(ce, x$0 -> super.get((OntClass)x$0));
    }

    @Override
    public ONTObject<OWLDatatype> get(OntDT dt) {
        return this.datatypes.computeIfAbsent(dt, x$0 -> super.get((OntDT)x$0));
    }

    @Override
    public ONTObject<OWLAnnotationProperty> get(OntNAP nap) {
        return this.annotationProperties.computeIfAbsent(nap, x$0 -> super.get((OntNAP)x$0));
    }

    @Override
    public ONTObject<OWLDataProperty> get(OntNDP ndp) {
        return this.datatypeProperties.computeIfAbsent(ndp, x$0 -> super.get((OntNDP)x$0));
    }

    @Override
    public ONTObject<OWLObjectProperty> get(OntNOP nop) {
        return this.objectProperties.computeIfAbsent(nop, x$0 -> super.get((OntNOP)x$0));
    }

    @Override
    public ONTObject<OWLLiteral> get(Literal l) {
        return this.literals.computeIfAbsent(l, x$0 -> super.get((Literal)x$0));
    }

    @Override
    public ONTObject<OWLNamedIndividual> get(OntIndividual.Named i) {
        return this.individuals.computeIfAbsent(i, x$0 -> super.get((OntIndividual.Named)x$0));
    }
}

