/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.internal.AxiomParserProvider;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.model.OntAnnotation;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;

public class ReadHelper {
    protected static boolean testAnnotationAxiomOverlaps(OntStatement statement, InternalConfig conf, AxiomType<? extends OWLObjectPropertyAxiom> o, AxiomType<? extends OWLDataPropertyAxiom> d) {
        return !conf.isIgnoreAnnotationAxiomOverlaps() || Stream.of(d, o).map(AxiomParserProvider::get).noneMatch(a -> a.testStatement(statement, conf));
    }

    public static boolean isDeclarationStatement(OntStatement s) {
        return s.isDeclaration() && ReadHelper.isEntityOrAnonymousIndividual(s.getSubject());
    }

    public static boolean isEntityOrAnonymousIndividual(Resource o) {
        return o.isURIResource() || o.canAs(OntIndividual.Anonymous.class);
    }

    public static boolean isAnnotationAssertionStatement(OntStatement s, InternalConfig config) {
        return s.isAnnotation() && !s.isBulkAnnotation() && (config.isAllowBulkAnnotationAssertions() || !s.hasAnnotations());
    }

    public static Set<ONTObject<OWLAnnotation>> getAnnotations(OntStatement statement, InternalConfig conf, InternalDataFactory df) {
        ExtendedIterator res = ReadHelper.listAnnotations(statement);
        if (conf.isLoadAnnotationAxioms() && ReadHelper.isDeclarationStatement(statement)) {
            res = res.filterDrop(s -> ReadHelper.isAnnotationAssertionStatement(s, conf));
        }
        return res.mapWith(a -> ReadHelper.getAnnotation(a, df)).toSet();
    }

    public static Stream<ONTObject<OWLAnnotation>> objectAnnotations(OntObject obj, InternalDataFactory df) {
        return obj.annotations().map(a -> ReadHelper.getAnnotation(a, df));
    }

    public static ONTObject<OWLAnnotation> getAnnotation(OntStatement ann, InternalDataFactory df) {
        return ann.hasAnnotations() ? ReadHelper.getHierarchicalAnnotations(ann, df) : ReadHelper.getPlainAnnotation(ann, df);
    }

    private static ONTObject<OWLAnnotation> getPlainAnnotation(OntStatement ann, InternalDataFactory df) {
        ONTObject<OWLAnnotationProperty> p = df.get((OntNAP)ann.getPredicate().as(OntNAP.class));
        ONTObject<? extends OWLAnnotationValue> v = df.get(ann.getObject());
        OWLAnnotation res = df.getOWLDataFactory().getOWLAnnotation(p.getObject(), v.getObject(), Stream.empty());
        return ONTObject.create(res, ann).append(p).append(v);
    }

    private static ONTObject<OWLAnnotation> getHierarchicalAnnotations(OntStatement root, InternalDataFactory df) {
        OntObject subject = root.getSubject();
        ONTObject<OWLAnnotationProperty> p = df.get((OntNAP)root.getPredicate().as(OntNAP.class));
        ONTObject<? extends OWLAnnotationValue> v = df.get(root.getObject());
        Set children = ReadHelper.listAnnotations(root).mapWith(a -> ReadHelper.getHierarchicalAnnotations(a, df)).toSet();
        OWLAnnotation object = df.getOWLDataFactory().getOWLAnnotation(p.getObject(), v.getObject(), children.stream().map(ONTObject::getObject));
        ONTObject<OWLAnnotation> res = ONTObject.create(object, root);
        if (subject.canAs(OntAnnotation.class)) {
            res = res.append((OntObject)subject.as(OntAnnotation.class));
        }
        return res.append(p).append(v).append(children);
    }

    public static ONTObject<OWLFacetRestriction> getFacetRestriction(OntFR fr, InternalDataFactory df) {
        OWLFacetRestriction res = ReadHelper.calcOWLFacetRestriction(fr, df);
        return ONTObject.create(res, fr);
    }

    public static OWLFacetRestriction calcOWLFacetRestriction(OntFR fr, InternalDataFactory df) {
        OWLLiteral literal = df.get(OntApiException.notNull(fr, "Null facet restriction.").getValue()).getObject();
        Class<? extends OntObject> view = OntApiException.notNull(((OntObjectImpl)((Object)fr)).getActualClass(), "Can't determine view of facet restriction " + fr);
        if (OntFR.Length.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.LENGTH, literal);
        }
        if (OntFR.MinLength.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MIN_LENGTH, literal);
        }
        if (OntFR.MaxLength.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MAX_LENGTH, literal);
        }
        if (OntFR.MinInclusive.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, literal);
        }
        if (OntFR.MaxInclusive.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, literal);
        }
        if (OntFR.MinExclusive.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, literal);
        }
        if (OntFR.MaxExclusive.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, literal);
        }
        if (OntFR.Pattern.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.PATTERN, literal);
        }
        if (OntFR.FractionDigits.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.FRACTION_DIGITS, literal);
        }
        if (OntFR.TotalDigits.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.TOTAL_DIGITS, literal);
        }
        if (OntFR.LangRange.class.equals(view)) {
            return df.getOWLDataFactory().getOWLFacetRestriction(OWLFacet.LANG_RANGE, literal);
        }
        throw new OntApiException("Unsupported facet restriction " + fr);
    }

    public static ONTObject<? extends OWLDataRange> calcDataRange(OntDR dr, InternalDataFactory internalDataFactory, Set<Resource> seen) {
        if (OntApiException.notNull(dr, "Null data range").isURIResource()) {
            return internalDataFactory.get((OntDT)dr.as(OntDT.class));
        }
        if (seen.contains(dr)) {
            throw new OntApiException("Recursive loop on data range " + dr);
        }
        seen.add(dr);
        DataFactory df = internalDataFactory.getOWLDataFactory();
        if (dr instanceof OntDR.Restriction) {
            OntDR.Restriction _dr = (OntDR.Restriction)dr;
            ONTObject<OWLDatatype> d2 = internalDataFactory.get(_dr.getDatatype());
            Set restrictions = ReadHelper.listMembers(_dr.getList()).mapWith(f -> ReadHelper.getFacetRestriction(f, internalDataFactory)).toSet();
            OWLDatatypeRestriction res = df.getOWLDatatypeRestriction(d2.getObject(), restrictions.stream().map(ONTObject::getObject).collect(Collectors.toList()));
            return ONTObject.create(res, dr).append(restrictions);
        }
        if (dr instanceof OntDR.ComplementOf) {
            OntDR.ComplementOf _dr = (OntDR.ComplementOf)dr;
            ONTObject<? extends OWLDataRange> d3 = ReadHelper.calcDataRange(_dr.getDataRange(), internalDataFactory, seen);
            return ONTObject.create(df.getOWLDataComplementOf(d3.getObject()), _dr).append(d3);
        }
        if (dr instanceof OntDR.UnionOf || dr instanceof OntDR.IntersectionOf) {
            OntDR.ComponentsDR _dr = (OntDR.ComponentsDR)dr;
            Set dataRanges = ReadHelper.listMembers(_dr.getList()).mapWith(d -> ReadHelper.calcDataRange(d, internalDataFactory, seen)).toSet();
            OWLDataUnionOf res = dr instanceof OntDR.UnionOf ? df.getOWLDataUnionOf(dataRanges.stream().map(ONTObject::getObject)) : df.getOWLDataIntersectionOf(dataRanges.stream().map(ONTObject::getObject));
            return ONTObject.create(res, dr).append(dataRanges);
        }
        if (dr instanceof OntDR.OneOf) {
            OntDR.OneOf _dr = (OntDR.OneOf)dr;
            Set literals = _dr.values().map(internalDataFactory::get).collect(Collectors.toSet());
            OWLDataOneOf res = df.getOWLDataOneOf(literals.stream().map(ONTObject::getObject));
            return ONTObject.create(res, _dr);
        }
        throw new OntApiException("Unsupported data range expression " + dr);
    }

    public static ONTObject<? extends OWLClassExpression> calcClassExpression(OntCE ce, InternalDataFactory internalDataFactory, Set<Resource> seen) {
        if (OntApiException.notNull(ce, "Null class expression").isURIResource()) {
            return internalDataFactory.get((OntClass)ce.as(OntClass.class));
        }
        if (seen.contains(ce)) {
            throw new OntApiException("Recursive loop on class expression " + ce);
        }
        seen.add(ce);
        DataFactory df = internalDataFactory.getOWLDataFactory();
        Class<? extends OntObject> type = ReadHelper.getType(ce);
        if (OntCE.ObjectSomeValuesFrom.class.equals(type) || OntCE.ObjectAllValuesFrom.class.equals(type)) {
            OWLObjectSomeValuesFrom owl;
            OntCE.ComponentRestrictionCE _ce = (OntCE.ComponentRestrictionCE)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = internalDataFactory.get((OntOPE)_ce.getOnProperty());
            ONTObject<? extends OWLClassExpression> c2 = ReadHelper.calcClassExpression((OntCE)_ce.getValue(), internalDataFactory, seen);
            if (OntCE.ObjectSomeValuesFrom.class.equals(type)) {
                owl = df.getOWLObjectSomeValuesFrom(p.getObject(), c2.getObject());
            } else if (OntCE.ObjectAllValuesFrom.class.equals(type)) {
                owl = df.getOWLObjectAllValuesFrom(p.getObject(), c2.getObject());
            } else {
                throw new OntApiException("Should never happen");
            }
            return ONTObject.create(owl, _ce).append(p).append(c2);
        }
        if (OntCE.DataSomeValuesFrom.class.equals(type) || OntCE.DataAllValuesFrom.class.equals(type)) {
            OWLDataSomeValuesFrom owl;
            OntCE.ComponentRestrictionCE _ce = (OntCE.ComponentRestrictionCE)ce;
            ONTObject<OWLDataProperty> p = internalDataFactory.get((OntNDP)_ce.getOnProperty());
            ONTObject<? extends OWLDataRange> d = internalDataFactory.get((OntDR)_ce.getValue());
            if (OntCE.DataSomeValuesFrom.class.equals(type)) {
                owl = df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p.getObject(), d.getObject());
            } else if (OntCE.DataAllValuesFrom.class.equals(type)) {
                owl = df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)p.getObject(), d.getObject());
            } else {
                throw new OntApiException("Should never happen");
            }
            return ONTObject.create(owl, _ce).append(p).append(d);
        }
        if (OntCE.ObjectHasValue.class.equals(type)) {
            OntCE.ObjectHasValue _ce = (OntCE.ObjectHasValue)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = internalDataFactory.get((OntOPE)_ce.getOnProperty());
            ONTObject<? extends OWLIndividual> i2 = internalDataFactory.get((OntIndividual)_ce.getValue());
            return ONTObject.create(df.getOWLObjectHasValue(p.getObject(), i2.getObject()), _ce).append(p).append(i2);
        }
        if (OntCE.DataHasValue.class.equals(type)) {
            OntCE.DataHasValue _ce = (OntCE.DataHasValue)ce;
            ONTObject<OWLDataProperty> p = internalDataFactory.get((OntNDP)_ce.getOnProperty());
            ONTObject<OWLLiteral> l = internalDataFactory.get((Literal)_ce.getValue());
            return ONTObject.create(df.getOWLDataHasValue((OWLDataPropertyExpression)p.getObject(), l.getObject()), _ce).append(p);
        }
        if (OntCE.ObjectMinCardinality.class.equals(type) || OntCE.ObjectMaxCardinality.class.equals(type) || OntCE.ObjectCardinality.class.equals(type)) {
            OWLObjectMinCardinality owl;
            OntCE.CardinalityRestrictionCE _ce = (OntCE.CardinalityRestrictionCE)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = internalDataFactory.get((OntOPE)_ce.getOnProperty());
            ONTObject<? extends OWLClassExpression> c3 = ReadHelper.calcClassExpression(_ce.getValue() == null ? _ce.getModel().getOWLThing() : (OntCE)_ce.getValue(), internalDataFactory, seen);
            if (OntCE.ObjectMinCardinality.class.equals(type)) {
                owl = df.getOWLObjectMinCardinality(_ce.getCardinality(), p.getObject(), c3.getObject());
            } else if (OntCE.ObjectMaxCardinality.class.equals(type)) {
                owl = df.getOWLObjectMaxCardinality(_ce.getCardinality(), p.getObject(), c3.getObject());
            } else if (OntCE.ObjectCardinality.class.equals(type)) {
                owl = df.getOWLObjectExactCardinality(_ce.getCardinality(), p.getObject(), c3.getObject());
            } else {
                throw new OntApiException("Should never happen");
            }
            return ONTObject.create(owl, _ce).append(p).append(c3);
        }
        if (OntCE.DataMinCardinality.class.equals(type) || OntCE.DataMaxCardinality.class.equals(type) || OntCE.DataCardinality.class.equals(type)) {
            OWLDataMinCardinality owl;
            OntCE.CardinalityRestrictionCE _ce = (OntCE.CardinalityRestrictionCE)ce;
            ONTObject<OWLDataProperty> p = internalDataFactory.get((OntNDP)_ce.getOnProperty());
            ONTObject<? extends OWLDataRange> d = internalDataFactory.get(_ce.getValue() == null ? (OntDR)_ce.getModel().getOntEntity(OntDT.class, RDFS.Literal) : (OntDR)_ce.getValue());
            if (OntCE.DataMinCardinality.class.equals(type)) {
                owl = df.getOWLDataMinCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getObject(), d.getObject());
            } else if (OntCE.DataMaxCardinality.class.equals(type)) {
                owl = df.getOWLDataMaxCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getObject(), d.getObject());
            } else if (OntCE.DataCardinality.class.equals(type)) {
                owl = df.getOWLDataExactCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getObject(), d.getObject());
            } else {
                throw new OntApiException("Should never happen");
            }
            return ONTObject.create(owl, _ce).append(p).append(d);
        }
        if (OntCE.HasSelf.class.equals(type)) {
            OntCE.HasSelf _ce = (OntCE.HasSelf)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = internalDataFactory.get((OntOPE)_ce.getOnProperty());
            return ONTObject.create(df.getOWLObjectHasSelf(p.getObject()), _ce).append(p);
        }
        if (OntCE.UnionOf.class.equals(type) || OntCE.IntersectionOf.class.equals(type)) {
            OWLObjectUnionOf owl;
            OntCE.ComponentsCE _ce = (OntCE.ComponentsCE)ce;
            Set components = ReadHelper.listMembers(_ce.getList()).mapWith(c -> ReadHelper.calcClassExpression(c, internalDataFactory, seen)).toSet();
            if (OntCE.UnionOf.class.equals(type)) {
                owl = df.getOWLObjectUnionOf(components.stream().map(ONTObject::getObject));
            } else if (OntCE.IntersectionOf.class.equals(type)) {
                owl = df.getOWLObjectIntersectionOf(components.stream().map(ONTObject::getObject));
            } else {
                throw new OntApiException("Should never happen");
            }
            return ONTObject.create(owl, _ce).append(components);
        }
        if (OntCE.OneOf.class.equals(type)) {
            OntCE.OneOf _ce = (OntCE.OneOf)ce;
            Set components = ReadHelper.listMembers(_ce.getList()).mapWith(i -> internalDataFactory.get((OntIndividual)i)).toSet();
            OWLObjectOneOf owl = df.getOWLObjectOneOf(components.stream().map(ONTObject::getObject));
            return ONTObject.create(owl, _ce).append(components);
        }
        if (ce instanceof OntCE.ComplementOf) {
            OntCE.ComplementOf _ce = (OntCE.ComplementOf)ce;
            ONTObject<? extends OWLClassExpression> c4 = ReadHelper.calcClassExpression((OntCE)_ce.getValue(), internalDataFactory, seen);
            return ONTObject.create(df.getOWLObjectComplementOf(c4.getObject()), _ce).append(c4);
        }
        throw new OntApiException("Unsupported class expression " + ce);
    }

    public static ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable var, InternalDataFactory df) {
        if (!OntApiException.notNull(var, "Null swrl var").isURIResource()) {
            throw new OntApiException("Anonymous swrl var " + var);
        }
        return ONTObject.create(df.getOWLDataFactory().getSWRLVariable(df.toIRI(var.getURI())), var);
    }

    public static ONTObject<? extends SWRLDArgument> getSWRLLiteralArg(OntSWRL.DArg arg, InternalDataFactory df) {
        if (OntApiException.notNull(arg, "Null SWRL-D arg").isLiteral()) {
            return ONTObject.create(df.getOWLDataFactory().getSWRLLiteralArgument(df.get(arg.asLiteral()).getObject()), arg);
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return ReadHelper.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class), df);
        }
        throw new OntApiException("Unsupported SWRL-D arg " + arg);
    }

    public static ONTObject<? extends SWRLIArgument> getSWRLIndividualArg(OntSWRL.IArg arg, InternalDataFactory df) {
        if (OntApiException.notNull(arg, "Null SWRL-I arg").canAs(OntIndividual.class)) {
            return ONTObject.create(df.getOWLDataFactory().getSWRLIndividualArgument(df.get((OntIndividual)arg.as(OntIndividual.class)).getObject()), arg);
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return ReadHelper.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class), df);
        }
        throw new OntApiException("Unsupported SWRL-I arg " + arg);
    }

    public static ONTObject<? extends SWRLAtom> calcSWRLAtom(OntSWRL.Atom atom, InternalDataFactory df) {
        if (atom instanceof OntSWRL.Atom.BuiltIn) {
            OntSWRL.Atom.BuiltIn _atom = (OntSWRL.Atom.BuiltIn)atom;
            IRI iri = df.toIRI(((Resource)_atom.getPredicate()).getURI());
            List arguments = _atom.arguments().map(a -> ReadHelper.getSWRLLiteralArg(a, df)).collect(Collectors.toList());
            SWRLBuiltInAtom res = df.getOWLDataFactory().getSWRLBuiltInAtom(iri, arguments.stream().map(ONTObject::getObject).collect(Collectors.toList()));
            return ONTObject.create(res, _atom).appendWildcards(arguments);
        }
        if (atom instanceof OntSWRL.Atom.OntClass) {
            OntSWRL.Atom.OntClass _atom = (OntSWRL.Atom.OntClass)atom;
            ONTObject<? extends OWLClassExpression> c = df.get((OntCE)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> a2 = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLClassAtom(c.getObject(), a2.getObject()), _atom).append(c).append(a2);
        }
        if (atom instanceof OntSWRL.Atom.DataProperty) {
            OntSWRL.Atom.DataProperty _atom = (OntSWRL.Atom.DataProperty)atom;
            ONTObject<OWLDataProperty> p = df.get((OntNDP)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> f = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getFirstArg(), df);
            ONTObject<? extends SWRLDArgument> s = ReadHelper.getSWRLLiteralArg((OntSWRL.DArg)_atom.getSecondArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLDataPropertyAtom((OWLDataPropertyExpression)p.getObject(), f.getObject(), s.getObject()), _atom).append(p).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.ObjectProperty) {
            OntSWRL.Atom.ObjectProperty _atom = (OntSWRL.Atom.ObjectProperty)atom;
            ONTObject<? extends OWLObjectPropertyExpression> p = df.get((OntOPE)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> f = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getFirstArg(), df);
            ONTObject<? extends SWRLIArgument> s = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getSecondArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLObjectPropertyAtom(p.getObject(), f.getObject(), s.getObject()), _atom).append(p).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.DataRange) {
            OntSWRL.Atom.DataRange _atom = (OntSWRL.Atom.DataRange)atom;
            ONTObject<? extends OWLDataRange> d = df.get((OntDR)_atom.getPredicate());
            ONTObject<? extends SWRLDArgument> a3 = ReadHelper.getSWRLLiteralArg((OntSWRL.DArg)_atom.getArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLDataRangeAtom(d.getObject(), a3.getObject()), _atom).append(d).append(a3);
        }
        if (atom instanceof OntSWRL.Atom.DifferentIndividuals) {
            OntSWRL.Atom.DifferentIndividuals _atom = (OntSWRL.Atom.DifferentIndividuals)atom;
            ONTObject<? extends SWRLIArgument> f = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getFirstArg(), df);
            ONTObject<? extends SWRLIArgument> s = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getSecondArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLDifferentIndividualsAtom(f.getObject(), s.getObject()), _atom).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.SameIndividuals) {
            OntSWRL.Atom.SameIndividuals _atom = (OntSWRL.Atom.SameIndividuals)atom;
            ONTObject<? extends SWRLIArgument> f = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getFirstArg(), df);
            ONTObject<? extends SWRLIArgument> s = ReadHelper.getSWRLIndividualArg((OntSWRL.IArg)_atom.getSecondArg(), df);
            return ONTObject.create(df.getOWLDataFactory().getSWRLSameIndividualAtom(f.getObject(), s.getObject()), _atom).append(f).append(s);
        }
        throw new OntApiException("Unsupported SWRL atom " + atom);
    }

    public static Class<? extends OntObject> getType(OntCE ce) {
        if (ce instanceof OntObjectImpl) {
            return OntApiException.notNull(((OntObjectImpl)((Object)ce)).getActualClass(), "Can't determine type of class expression " + ce);
        }
        return OntObjectImpl.findActualClass(ce);
    }

    public static ExtendedIterator<OntStatement> listAnnotations(OntStatement s) {
        if (s instanceof OntStatementImpl) {
            return ((OntStatementImpl)s).listAnnotations();
        }
        return WrappedIterator.create(s.annotations().iterator());
    }

    public static <R extends RDFNode> ExtendedIterator<R> listMembers(OntList<R> list) {
        if (list instanceof OntListImpl) {
            return ((OntListImpl)list).listMembers();
        }
        return WrappedIterator.create(list.members().iterator());
    }
}

