/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import ru.avicomp.ontapi.owlapi.objects.OWLLiteralImpl;

public class WriteHelper {
    public static RDFNode toRDFNode(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return WriteHelper.toLiteral((OWLLiteral)object);
        }
        return WriteHelper.toResource(object);
    }

    public static Optional<Resource> resource(OWLObject o) throws OntApiException {
        return o == null ? Optional.empty() : Optional.of(WriteHelper.toResource(o));
    }

    public static Resource toResource(OWLObject object) throws OntApiException {
        if (object instanceof OWLIndividual) {
            return WriteHelper.toResource((OWLIndividual)object);
        }
        return WriteHelper.toResource(WriteHelper.toIRI(object));
    }

    private static Resource toResource(OWLIndividual individual) {
        return individual.isAnonymous() ? WriteHelper.toResource(individual.asOWLAnonymousIndividual()) : WriteHelper.toResource(individual.asOWLNamedIndividual().getIRI());
    }

    public static Resource toResource(OWLAnonymousIndividual individual) {
        return new ResourceImpl(WriteHelper.toBlankNode(individual), null);
    }

    public static Node toBlankNode(OWLAnonymousIndividual individual) {
        BlankNodeId id = OWLAnonymousIndividualImpl.asONT(individual).getBlankNodeId();
        return NodeFactory.createBlankNode((BlankNodeId)id);
    }

    private static Resource toResource(IRI iri) {
        return ResourceFactory.createResource((String)OntApiException.notNull(iri, "Null iri").getIRIString());
    }

    public static Property toProperty(OWLPropertyExpression object) {
        return WriteHelper.toProperty(WriteHelper.toIRI(object));
    }

    private static Property toProperty(IRI iri) {
        return ResourceFactory.createProperty((String)OntApiException.notNull(iri, "Null iri").getIRIString());
    }

    public static Literal toLiteral(OWLLiteral literal) {
        return new LiteralImpl(WriteHelper.toLiteralNode(literal), null);
    }

    public static Node toLiteralNode(OWLLiteral literal) {
        LiteralLabel lab = OWLLiteralImpl.asONT(literal).getLiteralLabel();
        return NodeFactory.createLiteral((LiteralLabel)lab);
    }

    public static Resource getType(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return OWL.Class;
        }
        if (entity.isOWLDataProperty()) {
            return OWL.DatatypeProperty;
        }
        if (entity.isOWLObjectProperty()) {
            return OWL.ObjectProperty;
        }
        if (entity.isOWLNamedIndividual()) {
            return OWL.NamedIndividual;
        }
        if (entity.isOWLAnnotationProperty()) {
            return OWL.AnnotationProperty;
        }
        if (entity.isOWLDatatype()) {
            return RDFS.Datatype;
        }
        throw new OntApiException("Unsupported " + entity);
    }

    public static Class<? extends OntEntity> getEntityView(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return OntClass.class;
        }
        if (entity.isOWLDataProperty()) {
            return OntNDP.class;
        }
        if (entity.isOWLObjectProperty()) {
            return OntNOP.class;
        }
        if (entity.isOWLNamedIndividual()) {
            return OntIndividual.Named.class;
        }
        if (entity.isOWLAnnotationProperty()) {
            return OntNAP.class;
        }
        if (entity.isOWLDatatype()) {
            return OntDT.class;
        }
        throw new OntApiException("Unsupported " + entity);
    }

    public static Class<? extends OntFR> getFRView(OWLFacet facet) {
        switch (facet) {
            case LENGTH: {
                return OntFR.Length.class;
            }
            case MIN_LENGTH: {
                return OntFR.MinLength.class;
            }
            case MAX_LENGTH: {
                return OntFR.MaxLength.class;
            }
            case MIN_INCLUSIVE: {
                return OntFR.MinInclusive.class;
            }
            case MAX_INCLUSIVE: {
                return OntFR.MaxInclusive.class;
            }
            case MIN_EXCLUSIVE: {
                return OntFR.MinExclusive.class;
            }
            case MAX_EXCLUSIVE: {
                return OntFR.MaxExclusive.class;
            }
            case PATTERN: {
                return OntFR.Pattern.class;
            }
            case FRACTION_DIGITS: {
                return OntFR.FractionDigits.class;
            }
            case TOTAL_DIGITS: {
                return OntFR.TotalDigits.class;
            }
            case LANG_RANGE: {
                return OntFR.LangRange.class;
            }
        }
        throw new OntApiException("Unsupported " + facet);
    }

    public static void writeAssertionTriple(OntGraphModel model, OWLObject subject, OWLPropertyExpression property, OWLObject object, Stream<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        Property p = (Property)WriteHelper.addRDFNode(model, (OWLObject)property).as(Property.class);
        RDFNode o = WriteHelper.addRDFNode(model, object);
        WriteHelper.addAnnotations(s.addStatement(p, o), annotations);
    }

    public static void writeDeclarationTriple(OntGraphModel model, OWLEntity subject, Property predicate, RDFNode object, Stream<OWLAnnotation> annotations) {
        WriteHelper.addAnnotations(((OntEntity)WriteHelper.toResource((OWLObject)subject).inModel((Model)model).addProperty(predicate, object).as(WriteHelper.getEntityView(subject))).getRoot(), annotations);
    }

    public static void writeTriple(OntGraphModel model, OWLObject subject, Property predicate, OWLObject object, Stream<OWLAnnotation> annotations) {
        WriteHelper.writeTriple(model, subject, predicate, WriteHelper.addRDFNode(model, object), annotations);
    }

    public static void writeTriple(OntGraphModel model, OWLObject subject, Property predicate, RDFNode object, Stream<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        WriteHelper.addAnnotations(s.addStatement(predicate, object), annotations);
    }

    public static void writeList(OntGraphModel model, OWLObject subject, Property predicate, Stream<? extends OWLObject> objects, Stream<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        WriteHelper.addAnnotations(s.addStatement(predicate, (RDFNode)WriteHelper.addRDFList(model, objects)), annotations);
    }

    public static RDFList addRDFList(OntGraphModel model, Stream<? extends OWLObject> objects) {
        return model.createList(objects.map(o -> WriteHelper.addRDFNode(model, o)).iterator());
    }

    public static OntNAP addAnnotationProperty(OntGraphModel model, OWLEntity entity) {
        String uri = entity.getIRI().getIRIString();
        return model.fetchOntEntity(OntNAP.class, uri);
    }

    public static OntOPE addObjectProperty(OntGraphModel model, OWLObjectPropertyExpression ope) {
        if (!ope.isOWLObjectProperty()) {
            return WriteHelper.addInverseOf(model, (OWLObjectInverseOf)ope);
        }
        return model.fetchOntEntity(OntNOP.class, ope.getNamedProperty().getIRI().getIRIString());
    }

    public static OntNDP addDataProperty(OntGraphModel model, OWLDataPropertyExpression dpe) {
        if (!dpe.isOWLDataProperty()) {
            throw new OntApiException("Unsupported " + dpe);
        }
        String uri = dpe.asOWLDataProperty().getIRI().getIRIString();
        return model.fetchOntEntity(OntNDP.class, uri);
    }

    public static OntEntity addOntEntity(OntGraphModel model, OWLEntity entity) {
        Class<? extends OntEntity> view = WriteHelper.getEntityView(entity);
        String uri = entity.getIRI().getIRIString();
        return model.fetchOntEntity(view, uri);
    }

    public static OntOPE.Inverse addInverseOf(OntGraphModel model, OWLObjectInverseOf io) {
        String uri = io.getInverseProperty().getNamedProperty().getIRI().getIRIString();
        return model.fetchOntEntity(OntNOP.class, uri).createInverse();
    }

    public static OntFR addFacetRestriction(OntGraphModel model, OWLFacetRestriction fr) {
        return model.createFacetRestriction(WriteHelper.getFRView(fr.getFacet()), WriteHelper.addLiteral(model, fr.getFacetValue()));
    }

    public static OntCE addClassExpression(OntGraphModel model, OWLClassExpression ce) {
        if (ce.isOWLClass()) {
            return (OntCE)WriteHelper.addOntEntity(model, (OWLEntity)ce.asOWLClass()).as(OntClass.class);
        }
        ClassExpressionType type = ce.getClassExpressionType();
        CETranslator cet = OntApiException.notNull(CETranslator.valueOf(type), "Unsupported class-expression " + ce + "/" + type);
        return (OntCE)((CETranslator.Translator)cet.translator).add(model, ce).as(OntCE.class);
    }

    public static OntDR addDataRange(OntGraphModel model, OWLDataRange dr) {
        if (dr.isOWLDatatype()) {
            return (OntDR)WriteHelper.addOntEntity(model, (OWLEntity)dr.asOWLDatatype()).as(OntDT.class);
        }
        DataRangeType type = dr.getDataRangeType();
        DRTranslator drt = OntApiException.notNull(DRTranslator.valueOf(type), "Unsupported data-range expression " + dr + "/" + type);
        return (OntDR)((DRTranslator.Translator)drt.translator).add(model, dr).as(OntDR.class);
    }

    public static OntIndividual.Anonymous getAnonymousIndividual(OntGraphModel model, OWLAnonymousIndividual ai) {
        Resource res = WriteHelper.toResource(OntApiException.notNull(ai, "Null anonymous individual.")).inModel((Model)model);
        if (!res.canAs(OntIndividual.Anonymous.class)) {
            return Models.asAnonymousIndividual((RDFNode)res);
        }
        return (OntIndividual.Anonymous)res.as(OntIndividual.Anonymous.class);
    }

    public static OntIndividual addIndividual(OntGraphModel model, OWLIndividual i) {
        if (i.isAnonymous()) {
            return WriteHelper.getAnonymousIndividual(model, i.asOWLAnonymousIndividual());
        }
        String uri = i.asOWLNamedIndividual().getIRI().getIRIString();
        return model.fetchOntEntity(OntIndividual.Named.class, uri);
    }

    public static RDFNode addRDFNode(OntGraphModel model, OWLObject o) {
        if (o instanceof OWLEntity) {
            return WriteHelper.addOntEntity(model, (OWLEntity)o);
        }
        if (o instanceof OWLLiteral) {
            return WriteHelper.addLiteral(model, (OWLLiteral)o);
        }
        if (o instanceof OWLObjectInverseOf) {
            return WriteHelper.addInverseOf(model, (OWLObjectInverseOf)o);
        }
        if (o instanceof OWLFacetRestriction) {
            return WriteHelper.addFacetRestriction(model, (OWLFacetRestriction)o);
        }
        if (o instanceof OWLClassExpression) {
            return WriteHelper.addClassExpression(model, (OWLClassExpression)o);
        }
        if (o instanceof OWLDataRange) {
            return WriteHelper.addDataRange(model, (OWLDataRange)o);
        }
        if (o instanceof OWLAnonymousIndividual) {
            return WriteHelper.getAnonymousIndividual(model, (OWLAnonymousIndividual)o);
        }
        if (o instanceof SWRLObject) {
            return WriteHelper.addSWRLObject(model, (SWRLObject)o);
        }
        return WriteHelper.toRDFNode(o).inModel((Model)model);
    }

    public static OntSWRL.Variable addSWRLVariable(OntGraphModel model, SWRLVariable var) {
        return model.createSWRLVariable(var.getIRI().getIRIString());
    }

    public static OntSWRL.Atom addSWRLAtom(OntGraphModel model, SWRLAtom atom) {
        SWRLAtomTranslator swrlt = OntApiException.notNull(SWRLAtomTranslator.valueOf(atom), "Unsupported swrl-atom " + atom);
        return (OntSWRL.Atom)((SWRLAtomTranslator.Translator)swrlt.translator).add(model, atom).as(OntSWRL.Atom.class);
    }

    public static RDFNode addSWRLObject(OntGraphModel model, SWRLObject o) {
        if (o instanceof SWRLAtom) {
            return WriteHelper.addSWRLAtom(model, (SWRLAtom)o);
        }
        if (o instanceof SWRLArgument) {
            if (o instanceof SWRLVariable) {
                return WriteHelper.addSWRLVariable(model, (SWRLVariable)o);
            }
            if (o instanceof SWRLLiteralArgument) {
                return WriteHelper.addRDFNode(model, (OWLObject)((SWRLLiteralArgument)o).getLiteral());
            }
            if (o instanceof SWRLIndividualArgument) {
                return WriteHelper.addRDFNode(model, (OWLObject)((SWRLIndividualArgument)o).getIndividual());
            }
        }
        throw new OntApiException("Unsupported SWRL-Object: " + o);
    }

    public static void addAnnotations(OntStatement statement, Stream<OWLAnnotation> annotations) {
        annotations.forEach(a -> {
            OntStatement st = statement.addAnnotation(WriteHelper.addAnnotationProperty(statement.getModel(), (OWLEntity)a.getProperty()), WriteHelper.addRDFNode(statement.getModel(), (OWLObject)a.getValue()));
            WriteHelper.addAnnotations(st, (Stream<OWLAnnotation>)a.annotations());
        });
    }

    public static void addAnnotations(OntObject object, Stream<OWLAnnotation> annotations) {
        WriteHelper.addAnnotations(OntApiException.notNull(object.getRoot(), "Can't determine root statement for " + object), annotations);
    }

    public static IRI toIRI(OWLObject object) {
        if (OntApiException.notNull(object, "Null owl-object specified.").isIRI()) {
            return (IRI)object;
        }
        if (object instanceof HasIRI) {
            return ((HasIRI)object).getIRI();
        }
        if (object instanceof OWLAnnotationObject) {
            return (IRI)((OWLAnnotationObject)object).asIRI().orElseThrow(() -> new OntApiException("Not iri: " + object));
        }
        if (object instanceof OWLClassExpression) {
            return WriteHelper.toIRI((OWLClassExpression)object);
        }
        if (object instanceof OWLPropertyExpression) {
            return WriteHelper.toIRI((OWLPropertyExpression)object);
        }
        throw new OntApiException("Unsupported owl-object: " + object);
    }

    private static IRI toIRI(OWLClassExpression expression) {
        OWLClass res = null;
        if (ClassExpressionType.OWL_CLASS.equals((Object)expression.getClassExpressionType())) {
            res = (OWLClass)expression;
        }
        return ((HasIRI)OntApiException.notNull(res, "Unsupported class-expression: " + expression)).getIRI();
    }

    private static IRI toIRI(OWLPropertyExpression expression) {
        if (expression.isOWLDataProperty()) {
            return expression.asOWLDataProperty().getIRI();
        }
        if (expression.isOWLObjectProperty()) {
            return expression.asOWLObjectProperty().getIRI();
        }
        if (expression.isOWLAnnotationProperty()) {
            return expression.asOWLAnnotationProperty().getIRI();
        }
        throw new OntApiException("Unsupported property-expression: " + expression);
    }

    public static Literal addLiteral(OntGraphModel model, OWLLiteral literal) {
        WriteHelper.addDataRange(model, (OWLDataRange)literal.getDatatype()).as(OntDT.class);
        return model.asRDFNode(WriteHelper.toLiteralNode(literal)).asLiteral();
    }

    private static enum CETranslator {
        OBJECT_MAX_CARDINALITY(ClassExpressionType.OBJECT_MAX_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectMaxCardinality, OntCE.ObjectMaxCardinality>(){

            @Override
            OntCE.ObjectMaxCardinality translate(OntGraphModel model, OWLObjectMaxCardinality expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntCE c = expression.getFiller() == null ? null : (OntCE)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntCE.class);
                return model.createObjectMaxCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_MAX_CARDINALITY(ClassExpressionType.DATA_MAX_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataMaxCardinality, OntCE.DataMaxCardinality>(){

            @Override
            OntCE.DataMaxCardinality translate(OntGraphModel model, OWLDataMaxCardinality expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDR d = expression.getFiller() == null ? null : (OntDR)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDR.class);
                return model.createDataMaxCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_MIN_CARDINALITY(ClassExpressionType.OBJECT_MIN_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectMinCardinality, OntCE.ObjectMinCardinality>(){

            @Override
            OntCE.ObjectMinCardinality translate(OntGraphModel model, OWLObjectMinCardinality expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntCE c = expression.getFiller() == null ? null : (OntCE)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntCE.class);
                return model.createObjectMinCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_MIN_CARDINALITY(ClassExpressionType.DATA_MIN_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataMinCardinality, OntCE.DataMinCardinality>(){

            @Override
            OntCE.DataMinCardinality translate(OntGraphModel model, OWLDataMinCardinality expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDR d = expression.getFiller() == null ? null : (OntDR)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDR.class);
                return model.createDataMinCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_EXACT_CARDINALITY(ClassExpressionType.OBJECT_EXACT_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectExactCardinality, OntCE.ObjectCardinality>(){

            @Override
            OntCE.ObjectCardinality translate(OntGraphModel model, OWLObjectExactCardinality expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntCE c = expression.getFiller() == null ? null : (OntCE)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntCE.class);
                return model.createObjectCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_EXACT_CARDINALITY(ClassExpressionType.DATA_EXACT_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataExactCardinality, OntCE.DataCardinality>(){

            @Override
            OntCE.DataCardinality translate(OntGraphModel model, OWLDataExactCardinality expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDR d = expression.getFiller() == null ? null : (OntDR)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDR.class);
                return model.createDataCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_ALL_VALUES_FROM(ClassExpressionType.OBJECT_ALL_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectAllValuesFrom, OntCE.ObjectAllValuesFrom>(){

            @Override
            OntCE.ObjectAllValuesFrom translate(OntGraphModel model, OWLObjectAllValuesFrom expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntCE c = (OntCE)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntCE.class);
                return model.createObjectAllValuesFrom(p, c);
            }
        }),
        DATA_ALL_VALUES_FROM(ClassExpressionType.DATA_ALL_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataAllValuesFrom, OntCE.DataAllValuesFrom>(){

            @Override
            OntCE.DataAllValuesFrom translate(OntGraphModel model, OWLDataAllValuesFrom expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDR d = (OntDR)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDR.class);
                return model.createDataAllValuesFrom(p, d);
            }
        }),
        OBJECT_SOME_VALUES_FROM(ClassExpressionType.OBJECT_SOME_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectSomeValuesFrom, OntCE.ObjectSomeValuesFrom>(){

            @Override
            OntCE.ObjectSomeValuesFrom translate(OntGraphModel model, OWLObjectSomeValuesFrom expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntCE c = (OntCE)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntCE.class);
                return model.createObjectSomeValuesFrom(p, c);
            }
        }),
        DATA_SOME_VALUES_FROM(ClassExpressionType.DATA_SOME_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataSomeValuesFrom, OntCE.DataSomeValuesFrom>(){

            @Override
            OntCE.DataSomeValuesFrom translate(OntGraphModel model, OWLDataSomeValuesFrom expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDR d = (OntDR)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDR.class);
                return model.createDataSomeValuesFrom(p, d);
            }
        }),
        OBJECT_HAS_VALUE(ClassExpressionType.OBJECT_HAS_VALUE, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectHasValue, OntCE.ObjectHasValue>(){

            @Override
            OntCE.ObjectHasValue translate(OntGraphModel model, OWLObjectHasValue expression) {
                OntOPE p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntIndividual i = WriteHelper.addIndividual(model, (OWLIndividual)expression.getFiller());
                return model.createObjectHasValue(p, i);
            }
        }),
        DATA_HAS_VALUE(ClassExpressionType.DATA_HAS_VALUE, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLDataHasValue, OntCE.DataHasValue>(){

            @Override
            OntCE.DataHasValue translate(OntGraphModel model, OWLDataHasValue expression) {
                OntNDP p = WriteHelper.addDataProperty(model, expression.getProperty());
                Literal l = WriteHelper.addLiteral(model, (OWLLiteral)expression.getFiller());
                return model.createDataHasValue(p, l);
            }
        }),
        HAS_SELF(ClassExpressionType.OBJECT_HAS_SELF, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectHasSelf, OntCE.HasSelf>(){

            @Override
            OntCE.HasSelf translate(OntGraphModel model, OWLObjectHasSelf expression) {
                return model.createHasSelf(WriteHelper.addObjectProperty(model, expression.getProperty()));
            }
        }),
        UNION_OF(ClassExpressionType.OBJECT_UNION_OF, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectUnionOf, OntCE.UnionOf>(){

            @Override
            OntCE.UnionOf translate(OntGraphModel model, OWLObjectUnionOf expression) {
                return model.createUnionOf(expression.operands().map(ce -> (OntCE)WriteHelper.addRDFNode(model, (OWLObject)ce).as(OntCE.class)).collect(Collectors.toList()));
            }
        }),
        INTERSECTION_OF(ClassExpressionType.OBJECT_INTERSECTION_OF, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectIntersectionOf, OntCE.IntersectionOf>(){

            @Override
            OntCE.IntersectionOf translate(OntGraphModel model, OWLObjectIntersectionOf expression) {
                return model.createIntersectionOf(expression.operands().map(ce -> (OntCE)WriteHelper.addRDFNode(model, (OWLObject)ce).as(OntCE.class)).collect(Collectors.toList()));
            }
        }),
        ONE_OF(ClassExpressionType.OBJECT_ONE_OF, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectOneOf, OntCE.OneOf>(){

            @Override
            OntCE.OneOf translate(OntGraphModel model, OWLObjectOneOf expression) {
                return model.createOneOf(expression.operands().map(i -> WriteHelper.addIndividual(model, i)).collect(Collectors.toList()));
            }
        }),
        COMPLEMENT_OF(ClassExpressionType.OBJECT_COMPLEMENT_OF, (Translator<? extends OWLClassExpression, ? extends OntCE>)new Translator<OWLObjectComplementOf, OntCE.ComplementOf>(){

            @Override
            OntCE.ComplementOf translate(OntGraphModel model, OWLObjectComplementOf expression) {
                return model.createComplementOf((OntCE)WriteHelper.addRDFNode(model, (OWLObject)expression.getOperand()).as(OntCE.class));
            }
        });

        private final ClassExpressionType type;
        private final Translator<? extends OWLClassExpression, ? extends OntCE> translator;

        private CETranslator(ClassExpressionType type, Translator<? extends OWLClassExpression, ? extends OntCE> translator) {
            this.type = type;
            this.translator = translator;
        }

        public static CETranslator valueOf(ClassExpressionType type) {
            for (CETranslator t : CETranslator.values()) {
                if (!t.type.equals((Object)type)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends OWLClassExpression, TO extends OntCE> {
            private Translator() {
            }

            private Resource add(OntGraphModel model, OWLClassExpression expression) {
                return this.translate(model, expression);
            }

            abstract TO translate(OntGraphModel var1, FROM var2);
        }
    }

    private static enum DRTranslator {
        ONE_OF(DataRangeType.DATA_ONE_OF, (Translator<? extends OWLDataRange, ? extends OntDR>)new Translator<OWLDataOneOf, OntDR.OneOf>(){

            @Override
            OntDR.OneOf translate(OntGraphModel model, OWLDataOneOf expression) {
                return model.createOneOfDataRange(expression.values().map(l -> WriteHelper.addLiteral(model, l)).collect(Collectors.toList()));
            }
        }),
        RESTRICTION(DataRangeType.DATATYPE_RESTRICTION, (Translator<? extends OWLDataRange, ? extends OntDR>)new Translator<OWLDatatypeRestriction, OntDR.Restriction>(){

            @Override
            OntDR.Restriction translate(OntGraphModel model, OWLDatatypeRestriction expression) {
                return model.createRestrictionDataRange((OntDT)WriteHelper.addRDFNode(model, (OWLObject)expression.getDatatype()).as(OntDT.class), expression.facetRestrictions().map(f -> WriteHelper.addFacetRestriction(model, f)).collect(Collectors.toList()));
            }
        }),
        COMPLEMENT_OF(DataRangeType.DATA_COMPLEMENT_OF, (Translator<? extends OWLDataRange, ? extends OntDR>)new Translator<OWLDataComplementOf, OntDR.ComplementOf>(){

            @Override
            OntDR.ComplementOf translate(OntGraphModel model, OWLDataComplementOf expression) {
                return model.createComplementOfDataRange((OntDR)WriteHelper.addRDFNode(model, (OWLObject)expression.getDataRange()).as(OntDR.class));
            }
        }),
        UNION_OF(DataRangeType.DATA_UNION_OF, (Translator<? extends OWLDataRange, ? extends OntDR>)new Translator<OWLDataUnionOf, OntDR.UnionOf>(){

            @Override
            OntDR.UnionOf translate(OntGraphModel model, OWLDataUnionOf expression) {
                return model.createUnionOfDataRange(expression.operands().map(dr -> (OntDR)WriteHelper.addRDFNode(model, (OWLObject)dr).as(OntDR.class)).collect(Collectors.toList()));
            }
        }),
        INTERSECTION_OF(DataRangeType.DATA_INTERSECTION_OF, (Translator<? extends OWLDataRange, ? extends OntDR>)new Translator<OWLDataIntersectionOf, OntDR.IntersectionOf>(){

            @Override
            OntDR.IntersectionOf translate(OntGraphModel model, OWLDataIntersectionOf expression) {
                return model.createIntersectionOfDataRange(expression.operands().map(dr -> (OntDR)WriteHelper.addRDFNode(model, (OWLObject)dr).as(OntDR.class)).collect(Collectors.toList()));
            }
        });

        private final DataRangeType type;
        private final Translator<? extends OWLDataRange, ? extends OntDR> translator;

        private DRTranslator(DataRangeType type, Translator<? extends OWLDataRange, ? extends OntDR> translator) {
            this.translator = translator;
            this.type = type;
        }

        public static DRTranslator valueOf(DataRangeType type) {
            for (DRTranslator t : DRTranslator.values()) {
                if (!t.type.equals((Object)type)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends OWLDataRange, TO extends OntDR> {
            private Translator() {
            }

            private Resource add(OntGraphModel model, OWLDataRange expression) {
                return this.translate(model, expression);
            }

            abstract TO translate(OntGraphModel var1, FROM var2);
        }
    }

    private static enum SWRLAtomTranslator {
        BUILT_IN(SWRLBuiltInAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLBuiltInAtom, OntSWRL.Atom.BuiltIn>(){

            @Override
            OntSWRL.Atom.BuiltIn translate(OntGraphModel model, SWRLBuiltInAtom atom) {
                return model.createBuiltInSWRLAtom(model.createResource(atom.getPredicate().getIRIString()), atom.arguments().map(a -> (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)a).as(OntSWRL.DArg.class)).collect(Collectors.toList()));
            }
        }),
        OWL_CLASS(SWRLClassAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLClassAtom, OntSWRL.Atom.OntClass>(){

            @Override
            OntSWRL.Atom.OntClass translate(OntGraphModel model, SWRLClassAtom atom) {
                return model.createClassSWRLAtom(WriteHelper.addClassExpression(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getArgument()).as(OntSWRL.IArg.class));
            }
        }),
        DATA_PROPERTY(SWRLDataPropertyAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLDataPropertyAtom, OntSWRL.Atom.DataProperty>(){

            @Override
            OntSWRL.Atom.DataProperty translate(OntGraphModel model, SWRLDataPropertyAtom atom) {
                return model.createDataPropertySWRLAtom(WriteHelper.addDataProperty(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.DArg.class));
            }
        }),
        DATA_RANGE(SWRLDataRangeAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLDataRangeAtom, OntSWRL.Atom.DataRange>(){

            @Override
            OntSWRL.Atom.DataRange translate(OntGraphModel model, SWRLDataRangeAtom atom) {
                return model.createDataRangeSWRLAtom(WriteHelper.addDataRange(model, atom.getPredicate()), (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getArgument()).as(OntSWRL.DArg.class));
            }
        }),
        DIFFERENT_INDIVIDUALS(SWRLDifferentIndividualsAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLDifferentIndividualsAtom, OntSWRL.Atom.DifferentIndividuals>(){

            @Override
            OntSWRL.Atom.DifferentIndividuals translate(OntGraphModel model, SWRLDifferentIndividualsAtom atom) {
                return model.createDifferentIndividualsSWRLAtom((OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        }),
        OBJECT_PROPERTY(SWRLObjectPropertyAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLObjectPropertyAtom, OntSWRL.Atom.ObjectProperty>(){

            @Override
            OntSWRL.Atom.ObjectProperty translate(OntGraphModel model, SWRLObjectPropertyAtom atom) {
                return model.createObjectPropertySWRLAtom(WriteHelper.addObjectProperty(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        }),
        SAME_INDIVIDUALS(SWRLSameIndividualAtom.class, (Translator<? extends SWRLAtom, ? extends OntSWRL.Atom>)new Translator<SWRLSameIndividualAtom, OntSWRL.Atom.SameIndividuals>(){

            @Override
            OntSWRL.Atom.SameIndividuals translate(OntGraphModel model, SWRLSameIndividualAtom atom) {
                return model.createSameIndividualsSWRLAtom((OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        });

        private final Translator<? extends SWRLAtom, ? extends OntSWRL.Atom> translator;
        private final Class<? extends SWRLAtom> type;

        private SWRLAtomTranslator(Class<? extends SWRLAtom> type, Translator<? extends SWRLAtom, ? extends OntSWRL.Atom> translator) {
            this.translator = translator;
            this.type = type;
        }

        private static SWRLAtomTranslator valueOf(SWRLAtom atom) {
            for (SWRLAtomTranslator t : SWRLAtomTranslator.values()) {
                if (!t.type.isInstance(atom)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends SWRLAtom, TO extends OntSWRL.Atom> {
            private Translator() {
            }

            private Resource add(OntGraphModel model, SWRLAtom atom) {
                return this.translate(model, atom);
            }

            abstract TO translate(OntGraphModel var1, FROM var2);
        }
    }
}

