/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RWLockedGraph
implements Graph {
    protected final Graph base;
    protected final ReadWriteLock lock;

    public RWLockedGraph(Graph base, ReadWriteLock lock) {
        this.base = Objects.requireNonNull(base, "Null base graph");
        this.lock = Objects.requireNonNull(lock, "Null lock");
    }

    public Graph get() {
        return this.base;
    }

    public ReadWriteLock lock() {
        return this.lock;
    }

    public boolean dependsOn(Graph other) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.dependsOn(other);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void add(Triple t) throws AddDeniedException {
        this.lock.writeLock().lock();
        try {
            this.base.add(t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void delete(Triple t) throws DeleteDeniedException {
        this.lock.writeLock().lock();
        try {
            this.base.delete(t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ExtendedIterator<Triple> find(Triple m) {
        this.lock.readLock().lock();
        try {
            ExtendedIterator extendedIterator = this.base.find(m);
            return extendedIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        this.lock.readLock().lock();
        try {
            ExtendedIterator extendedIterator = this.base.find(s, p, o);
            return extendedIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isIsomorphicWith(Graph g) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.isIsomorphicWith(g);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node s, Node p, Node o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.contains(s, p, o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(Triple t) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.contains(t);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.base.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Node s, Node p, Node o) {
        this.lock.writeLock().lock();
        try {
            this.base.remove(s, p, o);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            this.base.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.base.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isClosed() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.base.isClosed();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TransactionHandler getTransactionHandler() {
        this.lock.readLock().lock();
        try {
            TransactionHandler transactionHandler = this.base.getTransactionHandler();
            return transactionHandler;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Capabilities getCapabilities() {
        this.lock.readLock().lock();
        try {
            Capabilities capabilities = this.base.getCapabilities();
            return capabilities;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public GraphEventManager getEventManager() {
        this.lock.readLock().lock();
        try {
            GraphEventManager graphEventManager = this.base.getEventManager();
            return graphEventManager;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        this.lock.readLock().lock();
        try {
            GraphStatisticsHandler graphStatisticsHandler = this.base.getStatisticsHandler();
            return graphStatisticsHandler;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public PrefixMapping getPrefixMapping() {
        this.lock.readLock().lock();
        try {
            PrefixMapping prefixMapping = this.base.getPrefixMapping();
            return prefixMapping;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

