/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.CachedAnnotationImpl;
import ru.avicomp.ontapi.jena.impl.OntAnnotationImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.model.OntAnnotation;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.utils.Models;

public class CachedStatementImpl
extends OntStatementImpl {
    private Resource annotationResourceType;
    private List<OntAnnotation> annotationResources;
    private Set<OntStatement> assertionStatements;
    private final boolean isRoot;

    public CachedStatementImpl(Statement delegate) {
        super(delegate);
        this.isRoot = delegate instanceof OntStatementImpl && ((OntStatementImpl)delegate).isRootStatement();
    }

    @Override
    public boolean isRootStatement() {
        return this.isRoot;
    }

    @Override
    public OntStatement asRootStatement() {
        if (this.isRootStatement()) {
            return this;
        }
        throw new OntJenaException.Unsupported("Currently #asRoot transformation is not supported for " + Models.toString(this));
    }

    @Override
    protected ExtendedIterator<OntStatement> listSubjectAssertions() {
        Set<OntStatement> res = this.assertionStatements == null ? (this.assertionStatements = this.getAssertionStatementsAsSet()) : this.assertionStatements;
        return WrappedIterator.create(res.iterator());
    }

    @Override
    public ExtendedIterator<OntAnnotation> listAnnotationResources() {
        return WrappedIterator.create(this.getAnnotationList().iterator());
    }

    @Override
    public List<OntAnnotation> getAnnotationList() {
        if (this.annotationResources != null) {
            return this.annotationResources;
        }
        this.annotationResources = super.getAnnotationList();
        return this.annotationResources;
    }

    @Override
    protected List<OntAnnotation> getAnnotationResourcesAsList() {
        return super.listAnnotationResources().toList();
    }

    protected Set<OntStatement> getAssertionStatementsAsSet() {
        return super.listSubjectAssertions().mapWith(x -> new CachedStatementImpl((Statement)x)).toSet();
    }

    @Override
    public boolean hasAnnotations() {
        if (this.annotationResources != null && !this.annotationResources.isEmpty()) {
            return true;
        }
        if (this.assertionStatements != null && !this.assertionStatements.isEmpty()) {
            return true;
        }
        return !this.listAnnotations().toSet().isEmpty();
    }

    @Override
    protected Resource getAnnotationResourceType() {
        return this.annotationResourceType == null ? (this.annotationResourceType = CachedStatementImpl.detectAnnotationRootType(this.subject)) : this.annotationResourceType;
    }

    @Override
    public OntStatement addAnnotation(OntNAP property, RDFNode value) {
        return (OntStatement)this.noModify();
    }

    @Override
    public CachedStatementImpl deleteAnnotation(OntNAP property, RDFNode value) {
        return (CachedStatementImpl)this.noModify();
    }

    protected <R> R noModify() {
        throw new OntJenaException.Unsupported(Models.toString(this) + ": modifying is not allowed.");
    }

    @Override
    protected OntStatementImpl createRootStatement(final OntAnnotation resource) {
        return new CachedStatementImpl(this){

            @Override
            public boolean isRootStatement() {
                return true;
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    @Override
    protected OntStatementImpl createBaseStatement(final OntAnnotationImpl resource) {
        return new CachedStatementImpl(this){

            @Override
            public ExtendedIterator<OntStatement> listAnnotations() {
                return resource.listAssertions();
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    @Override
    protected OntAnnotationImpl wrapAsOntAnnotation(Resource annotation) {
        return new CachedAnnotationImpl(annotation.asNode(), (EnhGraph)this.getModel()){

            @Override
            public OntStatement getBase() {
                return CachedStatementImpl.this.createBaseStatement(this);
            }

            @Override
            protected <R> R noModify() {
                return CachedStatementImpl.this.noModify();
            }
        };
    }
}

