/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntAPropertyImpl;
import ru.avicomp.ontapi.jena.impl.OntClassImpl;
import ru.avicomp.ontapi.jena.impl.OntDPropertyImpl;
import ru.avicomp.ontapi.jena.impl.OntDatatypeImpl;
import ru.avicomp.ontapi.jena.impl.OntIndividualImpl;
import ru.avicomp.ontapi.jena.impl.OntOPEImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntModelConfig;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.utils.BuiltIn;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public enum Entities implements Configurable<OntObjectFactory>
{
    CLASS(OWL.Class, OntClassImpl.class){

        @Override
        Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
            switch (mode) {
                case MEDIUM: 
                case STRICT: {
                    return Collections.singleton(RDFS.Datatype);
                }
            }
            return Collections.emptySet();
        }

        @Override
        Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
            return vocabulary.classes();
        }

        public Class<OntClass> getClassType() {
            return OntClass.class;
        }
    }
    ,
    DATATYPE(RDFS.Datatype, OntDatatypeImpl.class){

        @Override
        Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
            switch (mode) {
                case MEDIUM: 
                case STRICT: {
                    return Collections.singleton(OWL.Class);
                }
            }
            return Collections.emptySet();
        }

        @Override
        Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
            return vocabulary.datatypes();
        }

        public Class<OntDT> getClassType() {
            return OntDT.class;
        }
    }
    ,
    ANNOTATION_PROPERTY(OWL.AnnotationProperty, OntAPropertyImpl.class){

        @Override
        Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
            switch (mode) {
                case STRICT: {
                    return Stream.of(OWL.ObjectProperty, OWL.DatatypeProperty).collect(Iter.toUnmodifiableSet());
                }
            }
            return Collections.emptySet();
        }

        @Override
        Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
            return Collections.unmodifiableSet(vocabulary.annotationProperties());
        }

        public Class<OntNAP> getClassType() {
            return OntNAP.class;
        }
    }
    ,
    DATA_PROPERTY(OWL.DatatypeProperty, OntDPropertyImpl.class){

        @Override
        Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
            switch (mode) {
                case STRICT: {
                    return Stream.of(OWL.ObjectProperty, OWL.AnnotationProperty).collect(Iter.toUnmodifiableSet());
                }
                case MEDIUM: {
                    return Collections.singleton(OWL.ObjectProperty);
                }
            }
            return Collections.emptySet();
        }

        @Override
        Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
            return Collections.unmodifiableSet(vocabulary.datatypeProperties());
        }

        public Class<OntNDP> getClassType() {
            return OntNDP.class;
        }
    }
    ,
    OBJECT_PROPERTY(OWL.ObjectProperty, OntOPEImpl.NamedPropertyImpl.class){

        @Override
        Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
            switch (mode) {
                case STRICT: {
                    return Stream.of(OWL.DatatypeProperty, OWL.AnnotationProperty).collect(Iter.toUnmodifiableSet());
                }
                case MEDIUM: {
                    return Collections.singleton(OWL.DatatypeProperty);
                }
            }
            return Collections.emptySet();
        }

        @Override
        Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
            return Collections.unmodifiableSet(vocabulary.objectProperties());
        }

        public Class<OntNOP> getClassType() {
            return OntNOP.class;
        }
    }
    ,
    INDIVIDUAL(OWL.NamedIndividual, OntIndividualImpl.NamedImpl.class){

        public Class<OntIndividual.Named> getClassType() {
            return OntIndividual.Named.class;
        }
    };

    public static final BuiltIn.Vocabulary BUILTIN;
    public static final Configurable<OntObjectFactory> ALL;
    private final Class<? extends OntObjectImpl> impl;
    private final Resource resourceType;
    private final Map<Configurable.Mode, OntObjectFactory> registry = new HashMap<Configurable.Mode, OntObjectFactory>();

    private Entities(Resource resourceType, Class<? extends OntObjectImpl> impl) {
        this.impl = impl;
        this.resourceType = resourceType;
    }

    public Resource getResourceType() {
        return this.resourceType;
    }

    public abstract Class<? extends OntEntity> getClassType();

    Set<Resource> bannedTypes(OntModelConfig.StdMode mode) {
        return Collections.emptySet();
    }

    Set<Resource> builtInURIs() {
        return this.builtInURIs(BUILTIN);
    }

    Set<Resource> builtInURIs(BuiltIn.Vocabulary vocabulary) {
        return Collections.emptySet();
    }

    public static Optional<Entities> find(Resource type) {
        for (Entities e : Entities.values()) {
            if (!Objects.equals(e.getResourceType(), type)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static Optional<Entities> find(Class<? extends OntEntity> type) {
        for (Entities e : Entities.values()) {
            if (!Objects.equals(e.getClassType(), type)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public void register(Configurable.Mode key, OntObjectFactory factory) {
        this.registry.put(OntJenaException.notNull(key, "Null mode-key"), OntJenaException.notNull(factory, "Null factory-value"));
    }

    public OntObjectFactory unregister(Configurable.Mode key) {
        return this.registry.remove(key);
    }

    public Set<Configurable.Mode> keys() {
        return this.registry.keySet();
    }

    @Override
    public OntObjectFactory select(Configurable.Mode m) {
        if (this.registry.containsKey(m)) {
            return this.registry.get(m);
        }
        return this.createDefaultFactory(m);
    }

    public OntObjectFactory createDefaultFactory(Configurable.Mode mode) {
        OntModelConfig.StdMode m = mode instanceof OntModelConfig.StdMode ? (OntModelConfig.StdMode)mode : OntModelConfig.StdMode.LAX;
        Set<Resource> bannedTypes = this.bannedTypes(m);
        Set<Resource> builtinURIs = this.builtInURIs();
        OntFinder.ByType finder = new OntFinder.ByType(this.resourceType);
        OntFilter illegalPunningsFilter = OntFilter.TRUE.accumulate((OntFilter[])bannedTypes.stream().map(OntFilter.HasType::new).map(OntFilter::negate).toArray(OntFilter[]::new));
        OntFilter standardEntity = new OntFilter.HasType(this.resourceType).and(illegalPunningsFilter);
        OntFilter.OneOf builtInEntity = new OntFilter.OneOf(builtinURIs);
        OntFilter filter = OntFilter.URI.and(standardEntity.or(builtInEntity));
        OntMaker maker = new OntMaker.WithType(this.impl, this.resourceType).restrict(illegalPunningsFilter);
        return new CommonOntObjectFactory(maker, finder, filter, new OntFilter[0]);
    }

    static {
        BUILTIN = BuiltIn.get();
        ALL = OntObjectImpl.concatFactories(OntFinder.TYPED, Entities.values());
    }
}

